/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.mainengine.api;

import org.eclipse.stp.b2j.core.jengine.internal.Version;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.DaemonInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPClient;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SoapDaemonUtils;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.api.ControllerConnector;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;
import org.w3c.dom.Element;

public class SoapDaemonConnector
implements DaemonInterface {
    WSEndpointReference epr;
    SessionAddress address;
    String password;

    public SoapDaemonConnector(SessionAddress address) throws Exception {
        this.address = address;
        this.epr = address.getRequiresEncryption() ? new WSEndpointReference("https://" + address.getListenerHost() + ":" + address.getListenerPortMinimum() + "/services/engine/") : new WSEndpointReference("http://" + address.getListenerHost() + ":" + address.getListenerPortMinimum() + "/services/engine/");
        if (address.getRequiresPassword()) {
            this.password = address.getPassword();
        }
        this.getVersion();
    }

    private void checkForErrors(Element body_elem) throws Exception {
        Element elem = Util.getFirstElement(body_elem, "Error");
        if (elem != null) {
            throw new Exception(SoapDaemonUtils.elementToError(elem));
        }
    }

    public void addVersion(Message version, byte[] jar) throws Exception {
        StringBuffer request = new StringBuffer();
        if (this.password != null) {
            request.append(SoapDaemonUtils.passwordToElement(this.password));
        }
        request.append(SoapDaemonUtils.versionToElement(version));
        request.append(SoapDaemonUtils.jarToElement(jar));
        String response = SOAPClient.invokeRequestResponse(this.epr, null, null, false, "", "", "Daemon/AddVersion", request.toString());
        Element body_elem = SoapDaemonUtils.getResponseBody(response);
        this.checkForErrors(body_elem);
    }

    public boolean supportsVersion(Message version) throws Exception {
        StringBuffer request = new StringBuffer();
        if (this.password != null) {
            request.append(SoapDaemonUtils.passwordToElement(this.password));
        }
        request.append(SoapDaemonUtils.versionToElement(version));
        String response = SOAPClient.invokeRequestResponse(this.epr, null, null, false, "", "", "Daemon/SupportsVersion", request.toString());
        Element body_elem = SoapDaemonUtils.getResponseBody(response);
        this.checkForErrors(body_elem);
        Element part_supported = Util.getFirstElement(body_elem, "SupportedVersion");
        return SoapDaemonUtils.elementToSupported(part_supported);
    }

    public Message getVersion() throws Exception {
        StringBuffer request = new StringBuffer();
        if (this.password != null) {
            request.append(SoapDaemonUtils.passwordToElement(this.password));
        }
        String response = SOAPClient.invokeRequestResponse(this.epr, null, null, false, "", "", "Daemon/GetVersion", request.toString());
        Element body_elem = SoapDaemonUtils.getResponseBody(response);
        this.checkForErrors(body_elem);
        Element part_Versions = Util.getFirstElement(body_elem, "Versions");
        Message versions = SoapDaemonUtils.elementToVersion(part_Versions);
        return versions;
    }

    public void close() {
    }

    public ControllerInterface newEngine(String description, TraceListener tl, JARDependency[] deps, SessionAddress engineaddress) throws Exception {
        tl.debug("Engine version " + Version.getVersionAsString());
        StringBuffer request = new StringBuffer();
        if (this.password != null) {
            request.append(SoapDaemonUtils.passwordToElement(this.password));
        }
        request.append(SoapDaemonUtils.descriptionToElement(description));
        request.append(SoapDaemonUtils.sessionAddressToElement(engineaddress));
        request.append(SoapDaemonUtils.jarDependencyToElement(deps));
        request.append(SoapDaemonUtils.versionToElement(Version.getVersion()));
        String response = SOAPClient.invokeRequestResponse(this.epr, null, null, false, "", "", "Daemon/CreateController", request.toString());
        Element body_elem = SoapDaemonUtils.getResponseBody(response);
        this.checkForErrors(body_elem);
        Element part_SessionAddress = Util.getFirstElement(body_elem, "SessionAddress");
        SessionAddress toconnect = SoapDaemonUtils.elementToSessionAddress(part_SessionAddress);
        ControllerConnector con = new ControllerConnector(toconnect, tl);
        return con;
    }

    public SessionAddress newSubController(int id, JARDependency[] deps, SessionAddress engineaddress) throws Exception {
        StringBuffer request = new StringBuffer();
        if (this.password != null) {
            request.append(SoapDaemonUtils.passwordToElement(this.password));
        }
        request.append(SoapDaemonUtils.sessionAddressToElement(engineaddress));
        request.append(SoapDaemonUtils.jarDependencyToElement(deps));
        request.append(SoapDaemonUtils.versionToElement(Version.getVersion()));
        request.append(SoapDaemonUtils.idToElement(id));
        String response = SOAPClient.invokeRequestResponse(this.epr, null, null, false, "", "", "Daemon/CreateSubcontroller", request.toString());
        Element body_elem = SoapDaemonUtils.getResponseBody(response);
        this.checkForErrors(body_elem);
        Element part_SessionAddress = Util.getFirstElement(body_elem, "SessionAddress");
        SessionAddress toconnect = SoapDaemonUtils.elementToSessionAddress(part_SessionAddress);
        return toconnect;
    }
}

