/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageConstants;

public class MessageUtils
implements MessageConstants {
    public static byte[] messageToBytes(Message m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            MessageUtils.writeMessage(bout, m);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bout.toByteArray();
    }

    public static Message bytesToMessage(byte[] b) {
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        Message m = null;
        try {
            m = MessageUtils.readMessage(bin);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return m;
    }

    public static void writeMessage(OutputStream bout, Message m) throws IOException {
        int len = m.length();
        MessageUtils.writeInt(bout, 305446639);
        MessageUtils.writeInt(bout, m.getType());
        if (m.callstack != null) {
            MessageUtils.writeInt(bout, len + 1);
        } else {
            MessageUtils.writeInt(bout, len);
        }
        int i = 0;
        while (i < len) {
            Object o = m.get(i);
            int typ = m.getType(i);
            MessageUtils.writeInt(bout, typ);
            switch (typ) {
                case 0: {
                    String s = (String)o;
                    if (s == null) {
                        MessageUtils.writeInt(bout, -123);
                        break;
                    }
                    byte[] dat = s.getBytes();
                    MessageUtils.writeInt(bout, dat.length);
                    bout.write(dat);
                    break;
                }
                case 1: {
                    Integer xi = (Integer)o;
                    MessageUtils.writeInt(bout, xi);
                    break;
                }
                case 2: {
                    Long xl = (Long)o;
                    MessageUtils.writeLong(bout, xl);
                    break;
                }
                case 3: {
                    Double xd = (Double)o;
                    MessageUtils.writeDouble(bout, xd);
                    break;
                }
                case 4: {
                    Message xm = (Message)o;
                    MessageUtils.writeMessage(bout, xm);
                    break;
                }
                case 5: {
                    byte[] b = (byte[])o;
                    MessageUtils.writeInt(bout, b.length);
                    bout.write(b);
                }
            }
            ++i;
        }
        if (m.callstack != null) {
            MessageUtils.writeInt(bout, 6);
            byte[] dat = m.callstack.toString().getBytes();
            MessageUtils.writeInt(bout, dat.length);
            bout.write(dat);
        }
        MessageUtils.writeInt(bout, 1126288045);
        bout.flush();
    }

    public static Message readMessage(InputStream bin) throws IOException {
        Message m = new Message();
        int tmpi = MessageUtils.readInt(bin);
        if (tmpi != 305446639) {
            throw new IOException("Invalid Message Start " + tmpi);
        }
        tmpi = MessageUtils.readInt(bin);
        m.setType(tmpi);
        int datalen = MessageUtils.readInt(bin);
        int i = 0;
        while (i < datalen) {
            int dtype = MessageUtils.readInt(bin);
            switch (dtype) {
                case 0: {
                    tmpi = MessageUtils.readInt(bin);
                    if (tmpi == -123) {
                        m.append((String)null);
                        break;
                    }
                    byte[] tmpb = MessageUtils.readBytes(bin, tmpi);
                    m.append(new String(tmpb, 0, tmpi));
                    break;
                }
                case 1: {
                    tmpi = MessageUtils.readInt(bin);
                    m.append(new Integer(tmpi));
                    break;
                }
                case 2: {
                    long tmpl = MessageUtils.readLong(bin);
                    m.append(new Long(tmpl));
                    break;
                }
                case 3: {
                    double tmpd = MessageUtils.readDouble(bin);
                    m.append(new Double(tmpd));
                    break;
                }
                case 4: {
                    Message tmpmsg = MessageUtils.readMessage(bin);
                    m.append(tmpmsg);
                    break;
                }
                case 6: {
                    tmpi = MessageUtils.readInt(bin);
                    byte[] tmpb = MessageUtils.readBytes(bin, tmpi);
                    m.callstack = new StringBuffer(new String(tmpb, 0, tmpi));
                    break;
                }
                default: {
                    tmpi = MessageUtils.readInt(bin);
                    byte[] tmpb = MessageUtils.readBytes(bin, tmpi);
                    m.append(tmpb, 0, tmpi);
                }
            }
            ++i;
        }
        tmpi = MessageUtils.readInt(bin);
        if (tmpi != 1126288045) {
            throw new IOException("Invalid Message End " + tmpi);
        }
        return m;
    }

    private static void writeInt(OutputStream o, int i) throws IOException {
        byte[] b = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        o.write(b);
    }

    private static void writeLong(OutputStream o, long i) throws IOException {
        byte[] b = new byte[]{(byte)(i >> 56), (byte)(i >> 48), (byte)(i >> 40), (byte)(i >> 32), (byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        o.write(b);
    }

    private static void writeDouble(OutputStream o, double i) throws IOException {
        long il = Double.doubleToRawLongBits(i);
        MessageUtils.writeLong(o, il);
    }

    private static int readInt(InputStream i) throws IOException {
        byte[] b = MessageUtils.readBytes(i, 4);
        int x = (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        return x;
    }

    private static long readLong(InputStream i) throws IOException {
        byte[] b = MessageUtils.readBytes(i, 8);
        long x = (long)(b[0] & 0xFF) << 56 | (long)(b[1] & 0xFF) << 48 | (long)(b[2] & 0xFF) << 40 | (long)(b[3] & 0xFF) << 32 | (long)(b[4] & 0xFF) << 24 | (long)(b[5] & 0xFF) << 16 | (long)(b[6] & 0xFF) << 8 | (long)(b[7] & 0xFF);
        return x;
    }

    private static double readDouble(InputStream i) throws IOException {
        long x = MessageUtils.readLong(i);
        return Double.longBitsToDouble(x);
    }

    private static byte[] readBytes(InputStream i, int len) throws IOException {
        byte[] b = new byte[len];
        int t = 0;
        int n = 0;
        while (t < len) {
            n = i.read(b, t, len - t);
            if (n == -1) {
                throw new IOException("End of Stream");
            }
            t += n;
        }
        return b;
    }
}

