/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.miniengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.stp.b2j.core.jengine.internal.api.EngineFactory;
import org.eclipse.stp.b2j.core.jengine.internal.api.Program;
import org.eclipse.stp.b2j.core.jengine.internal.core.Runner;
import org.eclipse.stp.b2j.core.jengine.internal.core.SubControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.DaemonInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedHashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedBarrier;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedSemaphore;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.MultiQueuedBlockingMap;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.ObjectBuffer;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.UnqueuedSemaphore;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ID;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;

public class MiniController
implements ControllerInterface,
SubControllerInterface {
    TraceListener tracelistener;
    Object tracelisteners_LOCK = new Object();
    ArrayList tracelisteners = new ArrayList();
    long clock_offset = 0L;
    Program program;
    Class program_class;
    Object IDS_LOCK = new Object();
    int IDS = 0;
    int controller_id = 0;
    Object variables_LOCK = new Object();
    HashMap variables = new HashMap();
    HashMap variable_values = new HashMap();
    ArrayList variable_names = new ArrayList();
    Object maps_LOCK = new Object();
    HashMap maps = new HashMap();
    HashMap maps_shared = new HashMap();
    Object semaphores_LOCK = new Object();
    HashMap semaphores = new HashMap();
    HashMap semaphore_values = new HashMap();
    Object mutex_LOCK = new Object();
    HashMap mutexes = new HashMap();
    Object barrier_LOCK = new Object();
    HashMap barriers = new HashMap();
    Object runners_LOCK = new Object();
    private int RUNNERS_ID = 1;
    LinkedList activeRunners = new LinkedList();
    RunnerThreadGroup runner_group = new RunnerThreadGroup();
    Object localmaps_LOCK = new Object();
    HashMap localmaps = new HashMap();
    MultiQueuedBlockingMap conversations = new MultiQueuedBlockingMap();
    ObjectBuffer trace_buffer = new ObjectBuffer();
    ObjectBuffer print_buffer = new ObjectBuffer();
    ObjectBuffer debug_buffer = new ObjectBuffer();
    TraceThread tracethread;
    PrintThread printthread;
    DebugThread debugthread;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextId() {
        int tmp;
        Object object = this.IDS_LOCK;
        synchronized (object) {
            tmp = this.IDS++;
        }
        return tmp;
    }

    public MiniController(TraceListener tl, JARDependency[] deps) {
        this.tracelistener = tl;
        this.tracethread = new TraceThread();
        this.printthread = new PrintThread();
        this.debugthread = new DebugThread();
        this.tracethread.start();
        this.printthread.start();
        this.debugthread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTraceListener(TraceListener listener) {
        Object object = this.tracelisteners_LOCK;
        synchronized (object) {
            this.tracelisteners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTraceListener(TraceListener listener) {
        Object object = this.tracelisteners_LOCK;
        synchronized (object) {
            this.tracelisteners.remove(listener);
        }
    }

    public void setHeadless(boolean headless) {
    }

    public void setLogLevel(boolean error, boolean warning, boolean info) throws Exception {
        Logger.PRINT_ERROR = error;
        Logger.PRINT_WARNING = warning;
        Logger.PRINT_INFO = info;
    }

    public long setProgram(Program p) throws Exception {
        JARDependency[] deps = p.getDependencies();
        this.clock_offset = System.currentTimeMillis();
        URL[] dep_urls = new URL[deps.length];
        int i = 0;
        while (i < deps.length) {
            dep_urls[i] = new File(deps[i].getFilePath()).toURL();
            ++i;
        }
        this.program = p;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.stp.b2j.core.jengine.internal.miniengine.MiniController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.program_class = this.program.getProgramClass(dep_urls, clazz.getClassLoader());
        return this.clock_offset;
    }

    public void closeConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws Exception {
        this.debug("Aborting...\n");
        Object object = this.runners_LOCK;
        synchronized (object) {
            int i = 0;
            while (i < this.activeRunners.size()) {
                Runner runner = (Runner)this.activeRunners.get(i);
                try {
                    runner.stop();
                }
                catch (Throwable throwable) {}
                ++i;
            }
        }
    }

    public long getClock() {
        return System.currentTimeMillis() - this.clock_offset;
    }

    public String getClientHost() throws Exception {
        return "localhost";
    }

    public String getHost() throws Exception {
        return "localhost";
    }

    public String[] getHosts() throws Exception {
        return new String[]{"localhost"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVariableNames() throws Exception {
        Object object = this.variables_LOCK;
        synchronized (object) {
            String[] varnames = new String[this.variable_names.size()];
            this.variable_names.toArray(varnames);
            return varnames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getEngineLocalStorageMap(String name) {
        Object object = this.localmaps_LOCK;
        synchronized (object) {
            HashMap map = (HashMap)this.localmaps.get(name);
            if (map == null) {
                map = new HashMap();
                this.localmaps.put(name, map);
            }
            return map;
        }
    }

    public void trace(Message m) throws Exception {
        this.trace_buffer.add(m);
    }

    public void print(String msg) throws Exception {
        this.print_buffer.add(msg);
    }

    public void debug(String msg) throws Exception {
        this.debug_buffer.add(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRunnerDeath(long id, Runner runner) throws Exception {
        Object object = this.runners_LOCK;
        synchronized (object) {
            this.activeRunners.remove(runner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinRunner(Long rid) throws Exception {
        long tmp = rid;
        Thread runner = null;
        Object object = this.runners_LOCK;
        synchronized (object) {
            int i = 0;
            while (i < this.activeRunners.size()) {
                Runner tmprunner = (Runner)this.activeRunners.get(i);
                if (tmp == tmprunner.getRunnerId()) {
                    runner = tmprunner;
                    break;
                }
                ++i;
            }
        }
        if (runner == null) {
            return;
        }
        runner.join();
    }

    public void sendMessage(String conversation, Message m) throws Exception {
        this.conversations.put(conversation, (Message)m.clone());
    }

    public Message sendAndReceiveMessage(String conversation, Message msg, String conversationReturn) throws Exception {
        this.conversations.put(conversation, (Message)msg.clone());
        Message m = this.conversations.get(new String[]{conversationReturn}, 0L);
        m.pop();
        return m;
    }

    public Message sendAndReceiveMessage(String conversation, Message msg, Message conversationReturns) throws Exception {
        this.conversations.put(conversation, (Message)msg.clone());
        String[] rets = new String[conversationReturns.length()];
        int i = 0;
        while (i < rets.length) {
            rets[i] = (String)conversationReturns.get(i);
            ++i;
        }
        return this.conversations.get(rets, 0L);
    }

    public Message receiveMessage(String conversation) throws Exception {
        Message m = this.conversations.get(new String[]{conversation}, 0L);
        m.pop();
        return m;
    }

    public Message receiveMessage(String conversation, long timeoutMS) throws Exception {
        try {
            Message m = this.conversations.get(new String[]{conversation}, timeoutMS);
            m.pop();
            return m;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public Message receiveMessage(Message conversationReturns) throws Exception {
        String[] rets = new String[conversationReturns.length()];
        int i = 0;
        while (i < rets.length) {
            rets[i] = (String)conversationReturns.get(i);
            ++i;
        }
        return this.conversations.get(rets, 0L);
    }

    public Message receiveMessage(Message conversationReturns, long timeoutMS) throws Exception {
        String[] rets = new String[conversationReturns.length()];
        int i = 0;
        while (i < rets.length) {
            rets[i] = (String)conversationReturns.get(i);
            ++i;
        }
        try {
            return this.conversations.get(rets, timeoutMS);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public Message launchRunner(int count, String method, int host_index) throws Exception {
        return (Message)this.launchRunner(count, method, new Message())[0];
    }

    public Message launchRunner(int count, String method, int host_index, List args) throws Exception {
        Message margs = new Message();
        int i = 0;
        while (i < args.size()) {
            margs.append((String)args.get(i));
            ++i;
        }
        return (Message)this.launchRunner(count, method, margs)[0];
    }

    public Message launchRunner(int count, String method, int host_index, Message args) throws Exception {
        return (Message)this.launchRunner(count, method, (Message)args.clone())[0];
    }

    public Message launchRunner(int count, String method, int host_index, String[] args) throws Exception {
        Message margs = new Message();
        int i = 0;
        while (i < args.length) {
            margs.append(args[i]);
            ++i;
        }
        return (Message)this.launchRunner(count, method, margs)[0];
    }

    public ArrayList launchRunnerLocal(int count, String method, ArrayList args) throws Exception {
        Message margs = new Message();
        int i = 0;
        while (i < args.size()) {
            margs.append((String)args.get(i));
            ++i;
        }
        return (ArrayList)this.launchRunner(count, method, margs)[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] launchRunner(int count, String method, Message args) throws Exception {
        Message launched = new Message();
        ArrayList<Runner> rthreads = new ArrayList<Runner>();
        int i = 0;
        while (i < count) {
            Object object = this.runners_LOCK;
            synchronized (object) {
                long rid = ID.CREATE_ID(this.controller_id, this.RUNNERS_ID++);
                ID.ID_HEX(rid);
                Object program_object = this.program_class.newInstance();
                Field runner_id = this.program_class.getDeclaredField("runner_id");
                runner_id.setAccessible(true);
                runner_id.setLong(program_object, rid);
                Field runner_args = this.program_class.getDeclaredField("runner_args");
                runner_args.setAccessible(true);
                runner_args.set(program_object, args.clone());
                Runner r = new Runner(this.runner_group, "JEngine (mini) Runner Thread (ID: " + ID.ID_HEX(rid) + ")", this, rid, this.program_class, program_object, method);
                this.activeRunners.add(r);
                r.start();
                launched.append(rid);
                rthreads.add(r);
            }
            ++i;
        }
        return new Object[]{launched, rthreads};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedSemaphore newSemaphore(String name, int initial) throws Exception {
        Object object = this.semaphores_LOCK;
        synchronized (object) {
            SharedSemaphore s = this.getSemaphore(name);
            if (s == null) {
                int sid = this.getNextId();
                s = new SharedSemaphore(this, name, sid);
                this.semaphores.put(new Integer(sid), s);
                this.semaphores.put(name, s);
                this.semaphore_values.put(new Integer(sid), new UnqueuedSemaphore(initial));
                s.semSignal(initial);
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedBarrier newBarrier(String name, int size) throws Exception {
        Object object = this.barrier_LOCK;
        synchronized (object) {
            SharedBarrier b = this.getBarrier(name);
            if (b == null) {
                b = new SharedBarrier(this.newSemaphore(String.valueOf(name) + "%mini_BARRIER_WAITING", 0), this.newSemaphore(String.valueOf(name) + "%mini_BARRIER_BARRIER", 0), size);
                this.barriers.put(name, b);
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedMutex newMutex(String name) throws Exception {
        Object object = this.mutex_LOCK;
        synchronized (object) {
            SharedMutex m = this.getMutex(name);
            if (m == null) {
                m = new SharedMutex(this.newSemaphore(String.valueOf(name) + "%mini_MUTEX", 1));
                this.mutexes.put(name, m);
            }
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedSemaphore getSemaphore(String name) throws Exception {
        Object object = this.semaphores_LOCK;
        synchronized (object) {
            return (SharedSemaphore)this.semaphores.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedBarrier getBarrier(String name) throws Exception {
        Object object = this.barrier_LOCK;
        synchronized (object) {
            return (SharedBarrier)this.barriers.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedMutex getMutex(String name) throws Exception {
        Object object = this.mutex_LOCK;
        synchronized (object) {
            return (SharedMutex)this.mutexes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedVariable newVariable(String name, int type, boolean dirty) throws Exception {
        Object object = this.variables_LOCK;
        synchronized (object) {
            SharedVariable v = this.getVariable(name);
            if (v == null) {
                int vid = this.getNextId();
                v = new SharedVariable(this, name, vid, type, null);
                this.variables.put(new Integer(vid), v);
                this.variables.put(name, v);
                this.variable_names.add(name);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedHashMap newHashMap(String name) throws Exception {
        Object object = this.maps_LOCK;
        synchronized (object) {
            SharedHashMap h = this.getHashMap(name);
            if (h == null) {
                int hid = this.getNextId();
                h = new SharedHashMap(this, name, hid);
                HashMap underlying = new HashMap();
                this.maps.put(new Integer(hid), underlying);
                this.maps.put(name, underlying);
                this.maps_shared.put(new Integer(hid), h);
                this.maps_shared.put(name, h);
            }
            return h;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedVariable getVariable(String name) throws Exception {
        Object object = this.variables_LOCK;
        synchronized (object) {
            return (SharedVariable)this.variables.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedHashMap getHashMap(String name) throws Exception {
        Object object = this.maps_LOCK;
        synchronized (object) {
            return (SharedHashMap)this.maps_shared.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalSemaphore(int id, int n) throws Exception {
        UnqueuedSemaphore sem;
        Object object = this.semaphores_LOCK;
        synchronized (object) {
            sem = (UnqueuedSemaphore)this.semaphore_values.get(new Integer(id));
        }
        sem.doSignal(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitSemaphore(int id, int n) throws Exception {
        UnqueuedSemaphore sem;
        Object object = this.semaphores_LOCK;
        synchronized (object) {
            sem = (UnqueuedSemaphore)this.semaphore_values.get(new Integer(id));
        }
        sem.doWait(n);
    }

    private HashMap getMap(int id) {
        Integer Id = new Integer(id);
        HashMap map = (HashMap)this.maps.get(Id);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hashmapSet(int id, String key, Object value) throws Exception {
        Object object = this.maps_LOCK;
        synchronized (object) {
            HashMap map = this.getMap(id);
            map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] hashmapGetKeys(int id) throws Exception {
        Object object = this.maps_LOCK;
        synchronized (object) {
            HashMap map = this.getMap(id);
            ArrayList list = new ArrayList(map.keySet());
            String[] keys = new String[list.size()];
            int i = 0;
            while (i < keys.length) {
                keys[i] = (String)list.get(i);
                ++i;
            }
            return keys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object hashmapGet(int id, String key) throws Exception {
        Object object = this.maps_LOCK;
        synchronized (object) {
            HashMap map = this.getMap(id);
            return map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hashmapClear(int id) throws Exception {
        Object object = this.maps_LOCK;
        synchronized (object) {
            HashMap map = this.getMap(id);
            map.clear();
        }
    }

    public boolean isVariableDirty(int id) throws Exception {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeVariable(int id, int type, Object newval) throws Exception {
        Object object = this.variables_LOCK;
        synchronized (object) {
            this.variable_values.put(new Integer(id), newval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fetchVariable(int id, int type) throws Exception {
        Object object = this.variables_LOCK;
        synchronized (object) {
            return this.variable_values.get(new Integer(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRunnerStackDump() throws Exception {
        Object object = this.runners_LOCK;
        synchronized (object) {
            int i = 0;
            while (i < this.activeRunners.size()) {
                Runner runner = (Runner)this.activeRunners.get(i);
                StringBuffer sb = new StringBuffer("MiniEngine - Runner Stack Dump:\n");
                String tmp = runner.getStack();
                sb.append(tmp);
                this.print(sb.toString());
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRunnerStackTrace(int msg_id) throws Exception {
        Object object = this.runners_LOCK;
        synchronized (object) {
            int i = 0;
            while (i < this.activeRunners.size()) {
                Runner runner = (Runner)this.activeRunners.get(i);
                Message m = runner.getStackContents();
                m.setType(msg_id);
                this.trace(m);
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        try {
            byte[] prog = StreamUtils.readAll(new FileInputStream(args[0]));
            Program program = new Program(prog, new byte[0][0], new JARDependency[0]);
            DaemonInterface d = EngineFactory.connectToMiniEngineDaemon();
            ControllerInterface c = d.newEngine("MiniEngine " + System.currentTimeMillis(), new PrintTraceListener(), new JARDependency[0], null);
            c.setProgram(program);
            Message m = c.launchRunner(1, "activity1", 0);
            System.out.println(m);
            int i = 0;
            while (i < 6) {
                Thread.sleep(10000L);
                System.out.println(i);
                ++i;
            }
            System.exit(0);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    class RunnerThreadGroup
    extends ThreadGroup {
        public RunnerThreadGroup() {
            super("Runner Thread Group");
        }

        public void uncaughtException(Thread t, Throwable e) {
            e.printStackTrace();
        }
    }

    class TraceThread
    extends Thread {
        public TraceThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                block5: while (true) {
                    Message m = (Message)MiniController.this.trace_buffer.next();
                    MiniController.this.tracelistener.trace(m);
                    Object object = MiniController.this.tracelisteners_LOCK;
                    // MONITORENTER : object
                    int k = 0;
                    while (true) {
                        if (k >= MiniController.this.tracelisteners.size()) {
                            // MONITOREXIT : object
                            continue block5;
                        }
                        ((TraceListener)MiniController.this.tracelisteners.get(k)).trace(m);
                        ++k;
                    }
                    break;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    class PrintThread
    extends Thread {
        public PrintThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                block5: while (true) {
                    String s = (String)MiniController.this.print_buffer.next();
                    MiniController.this.tracelistener.print(s);
                    Object object = MiniController.this.tracelisteners_LOCK;
                    // MONITORENTER : object
                    int k = 0;
                    while (true) {
                        if (k >= MiniController.this.tracelisteners.size()) {
                            // MONITOREXIT : object
                            continue block5;
                        }
                        ((TraceListener)MiniController.this.tracelisteners.get(k)).print(s);
                        ++k;
                    }
                    break;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    class DebugThread
    extends Thread {
        public DebugThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                block5: while (true) {
                    String s = (String)MiniController.this.debug_buffer.next();
                    MiniController.this.tracelistener.debug(s);
                    Object object = MiniController.this.tracelisteners_LOCK;
                    // MONITORENTER : object
                    int k = 0;
                    while (true) {
                        if (k >= MiniController.this.tracelisteners.size()) {
                            // MONITOREXIT : object
                            continue block5;
                        }
                        ((TraceListener)MiniController.this.tracelisteners.get(k)).debug(s);
                        ++k;
                    }
                    break;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    static class PrintTraceListener
    implements TraceListener {
        PrintTraceListener() {
        }

        public void trace(Message m) {
            System.out.println(m);
        }

        public void print(String s) {
            System.out.println(s);
        }

        public void debug(String s) {
            System.out.println(s);
        }
    }
}

