/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.multiplex;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.ByteArrayInBuffer;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexingInput;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.UnqueuedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;

public class MultiplexerInputStream
implements MultiplexingInput {
    InputStream instream;
    Object lock = new Object();
    Object notifier = new Object();
    HashMap instreams = new HashMap();
    HashMap locks = new HashMap();
    boolean closed = false;
    IOException ioexception;

    public MultiplexerInputStream(InputStream in) {
        this.instream = new BufferedInputStream(in);
        ReaderThread rthread = new ReaderThread();
        rthread.setDaemon(true);
        rthread.start();
    }

    public MultiplexerInputStream(InputStream in, String readername) {
        this.instream = new BufferedInputStream(in);
        ReaderThread rthread = new ReaderThread(readername);
        rthread.setDaemon(true);
        rthread.start();
    }

    public MultiplexerInputStream(InputStream in, String readername, ThreadGroup tg) {
        this.instream = new BufferedInputStream(in);
        ReaderThread rthread = new ReaderThread(tg, readername);
        rthread.setDaemon(true);
        rthread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnqueuedMutex getLock(short n) {
        Integer N = new Integer(n);
        Object object = this.lock;
        synchronized (object) {
            UnqueuedMutex nlock = (UnqueuedMutex)this.locks.get(N);
            if (nlock == null) {
                nlock = new UnqueuedMutex();
                this.locks.put(N, nlock);
            }
            return nlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        this.closed = true;
        Object object = this.lock;
        synchronized (object) {
            Collection tmp = this.instreams.values();
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                ((ByteArrayInBuffer)it.next()).setClosed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(IOException e) {
        this.closed = true;
        this.ioexception = e;
        Object object = this.lock;
        synchronized (object) {
            Collection tmp = this.instreams.values();
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                ((ByteArrayInBuffer)it.next()).setClosed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(short n) {
        Integer N = new Integer(n);
        Object object = this.lock;
        synchronized (object) {
            ByteArrayInBuffer in = (ByteArrayInBuffer)this.instreams.get(N);
            if (in == null) {
                in = new ByteArrayInBuffer();
                this.instreams.put(N, in);
            }
            if (this.closed) {
                if (this.ioexception != null) {
                    in.setClosed(this.ioexception);
                } else {
                    in.setClosed();
                }
            }
            return in;
        }
    }

    class ReaderThread
    extends Thread {
        ThreadGroup tg = null;

        public ReaderThread() {
        }

        public ReaderThread(String name) {
            super(name);
        }

        public ReaderThread(ThreadGroup tg, String name) {
            super(tg, name);
            this.tg = tg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                try {
                    short n = 0;
                    byte[] dat = null;
                    while (!MultiplexerInputStream.this.closed) {
                        n = StreamUtils.readShort(MultiplexerInputStream.this.instream);
                        dat = StreamUtils.readNBytes(MultiplexerInputStream.this.instream, 10000000);
                        if (dat.length <= 0) continue;
                        Integer N = new Integer(n);
                        Object object = MultiplexerInputStream.this.lock;
                        synchronized (object) {
                            ByteArrayInBuffer in = (ByteArrayInBuffer)MultiplexerInputStream.this.instreams.get(N);
                            if (in == null) {
                                in = new ByteArrayInBuffer();
                                MultiplexerInputStream.this.instreams.put(N, in);
                            }
                            in.add(dat);
                        }
                    }
                }
                catch (EOFException e) {
                    MultiplexerInputStream.this.closeAll();
                    if (this.tg != null) {
                        this.tg.uncaughtException(this, e);
                    }
                }
                catch (IOException e) {
                    MultiplexerInputStream.this.closeAll(e);
                    if (this.tg != null) {
                        this.tg.uncaughtException(this, e);
                    }
                }
                catch (Throwable t) {
                    MultiplexerInputStream.this.closeAll(new IOException("unknown error " + t));
                    Logger.error("unexpected error in MultiplexerInputStream", t);
                    if (this.tg == null) break block11;
                    this.tg.uncaughtException(this, t);
                }
            }
        }
    }
}

