/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.transport;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.sessiontransport.tcpip.TCPIPTransport;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.Session;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.SessionFactory;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class ReconnectTest {
    static SessionAddress address;

    public static void main(String[] args) throws Throwable {
        address = new SessionAddress("localhost", 9000, 9000, "localhost", 9000, 9000);
        address.setReconnectionFailureAbortTimeout(180000L);
        address.setRequiresLinkReconnection(true);
        address.setRequiresMultipleConnections(false);
        address.setRequiresMultipleStreams(false);
        Server server = new Server();
        server.start();
        Thread.sleep(300L);
        Client client = new Client();
        client.start();
        server.join();
        client.join();
        System.exit(0);
    }

    public static class Server
    extends Thread {
        public void run() {
            try {
                Session session = SessionFactory.newSession(address, false);
                session.begin();
                OutputStream out = session.getOutputStream((short)0);
                int i = 0;
                while (i < 10000000) {
                    out.write(i % 100);
                    ++i;
                }
                System.out.println("Server wrote OK");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static class Client
    extends Thread {
        public void run() {
            try {
                Session session = SessionFactory.newSession(address, true);
                session.begin();
                InputStream in = session.getInputStream((short)0);
                int i = 0;
                while (i < 10000000) {
                    int n = in.read();
                    if (i == 50000) {
                        TCPIPTransport transport = (TCPIPTransport)session.transport;
                        InputStream intercepted_in = transport.in;
                        System.out.println("Intercepted read");
                        int k = 0;
                        while (k < 49000) {
                            intercepted_in.read();
                            ++k;
                        }
                        System.out.println("Intercepted read finished");
                        session.transport.close();
                    }
                    if (n != i % 100) {
                        throw new Throwable("MISMATCH " + n + " != " + i % 100);
                    }
                    ++i;
                }
                System.out.println("Client read OK");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

