/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.text.DecimalFormat;
import org.eclipse.stp.b2j.core.jengine.internal.utils.XNode;
import org.eclipse.stp.b2j.core.jengine.internal.utils.XNodeSet;
import org.eclipse.stp.b2j.core.jengine.internal.utils.XPathAccessible;

public class XPU {
    private static boolean gt(XNodeSet a1, XNodeSet a2) {
        int i = 0;
        while (i < a2.size()) {
            String s2 = a2.get(i).toString();
            Double n2 = XPU.toNumber(s2);
            if (XPU.gt(a1, n2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean gt(XNodeSet a1, Number n2) {
        int i = 0;
        while (i < a1.size()) {
            String s1 = a1.get(i).toString();
            Double n1 = XPU.toNumber(s1);
            if (n1 > n2.doubleValue()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean ge(XNodeSet a1, XNodeSet a2) {
        int i = 0;
        while (i < a2.size()) {
            String s2 = a2.get(i).toString();
            Double n2 = XPU.toNumber(s2);
            if (XPU.ge(a1, n2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean ge(XNodeSet a1, Number n2) {
        int i = 0;
        while (i < a1.size()) {
            String s1 = a1.get(i).toString();
            Double n1 = XPU.toNumber(s1);
            if (n1 >= n2.doubleValue()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean equals(XNodeSet a1, XNodeSet a2) {
        int i = 0;
        while (i < a2.size()) {
            String s2 = a1.get(i).toString();
            if (XPU.equals(a1, s2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean equals(XNodeSet a1, Number n2) {
        int i = 0;
        while (i < a1.size()) {
            String s1 = a1.get(i).toString();
            Double n1 = XPU.toNumber(s1);
            if (((Object)n1).equals(n2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean equals(XNodeSet a1, String s2) {
        int i = 0;
        while (i < a1.size()) {
            String s1 = a1.get(i).toString();
            if (s1.equals(s2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Boolean and(Object o1, Object o2) {
        boolean b = XPU.toBoolean(o1) != false && XPU.toBoolean(o2) != false;
        return new Boolean(b);
    }

    public static Boolean or(Object o1, Object o2) {
        boolean b = XPU.toBoolean(o1) != false || XPU.toBoolean(o2) != false;
        return new Boolean(b);
    }

    public static boolean gt(Object o1, Object o2) {
        if (o1 instanceof XNodeSet) {
            if (o2 instanceof XNodeSet) {
                return XPU.gt((XNodeSet)o1, (XNodeSet)o2);
            }
            return XPU.gt((XNodeSet)o1, XPU.toNumber(o2));
        }
        if (o2 instanceof XNodeSet) {
            return !XPU.ge((XNodeSet)o2, XPU.toNumber(o1));
        }
        Double n1 = XPU.toNumber(o1);
        Double n2 = XPU.toNumber(o2);
        return n1 > n2;
    }

    public static boolean ge(Object o1, Object o2) {
        if (o1 instanceof XNodeSet) {
            if (o2 instanceof XNodeSet) {
                return XPU.ge((XNodeSet)o1, (XNodeSet)o2);
            }
            return XPU.ge((XNodeSet)o1, XPU.toNumber(o2));
        }
        if (o2 instanceof XNodeSet) {
            return !XPU.gt((XNodeSet)o2, XPU.toNumber(o1));
        }
        Double n1 = XPU.toNumber(o1);
        Double n2 = XPU.toNumber(o2);
        return n1 >= n2;
    }

    public static boolean lt(Object o1, Object o2) {
        return XPU.gt(o2, o1);
    }

    public static boolean le(Object o1, Object o2) {
        return XPU.ge(o2, o1);
    }

    public static boolean ne(Object o1, Object o2) {
        return !XPU.eq(o1, o2);
    }

    public static boolean eq(Object o1, Object o2) {
        if (o1 instanceof XNodeSet) {
            if (o2 instanceof XNodeSet) {
                return XPU.equals((XNodeSet)o1, (XNodeSet)o2);
            }
            if (o2 instanceof Number) {
                return XPU.equals((XNodeSet)o1, (Number)o2);
            }
            if (o2 instanceof String) {
                return XPU.equals((XNodeSet)o1, (String)o2);
            }
            return XPU.toBoolean(o1).equals(o2);
        }
        if (o2 instanceof XNodeSet) {
            if (o1 instanceof Number) {
                return XPU.equals((XNodeSet)o2, (Number)o1);
            }
            if (o1 instanceof String) {
                return XPU.equals((XNodeSet)o2, (String)o1);
            }
            return o1.equals(XPU.toBoolean(o2));
        }
        if (o1 instanceof Boolean || o2 instanceof Boolean) {
            Boolean b1 = XPU.toBoolean(o1);
            Boolean b2 = XPU.toBoolean(o2);
            return b1.equals(b2);
        }
        if (o1 instanceof Number || o2 instanceof Number) {
            Double n1 = XPU.toNumber(o1);
            Double n2 = XPU.toNumber(o2);
            return ((Object)n1).equals(n2);
        }
        String s1 = XPU.toString(o1);
        String s2 = XPU.toString(o2);
        return s1.equals(s2);
    }

    public static Double negate(Object o1) {
        return XPU.negate(XPU.toNumber(o1));
    }

    public static Double negate(Double o1) {
        return new Double(-o1.doubleValue());
    }

    public static Double add(Object o1, Object o2) {
        Double n1 = XPU.toNumber(o1);
        Double n2 = XPU.toNumber(o2);
        return new Double(n1 + n2);
    }

    public static Double subtract(Object o1, Object o2) {
        Double n1 = XPU.toNumber(o1);
        Double n2 = XPU.toNumber(o2);
        return new Double(n1 - n2);
    }

    public static Double multiply(Object o1, Object o2) {
        Double n1 = XPU.toNumber(o1);
        Double n2 = XPU.toNumber(o2);
        return new Double(n1 * n2);
    }

    public static Double div(Object o1, Object o2) {
        Double n1 = XPU.toNumber(o1);
        Double n2 = XPU.toNumber(o2);
        return new Double(n1 / n2);
    }

    public static Double mod(Object o1, Object o2) {
        Double n1 = XPU.toNumber(o1);
        Double n2 = XPU.toNumber(o2);
        return new Double(n1 % n2);
    }

    public static Double toNumber(Object o) {
        Double d;
        if (o instanceof Number) {
            return (Double)o;
        }
        if (o instanceof String) {
            try {
                return new Double((String)o);
            }
            catch (NumberFormatException numberFormatException) {
                return new Double(Double.NaN);
            }
        }
        if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                return new Double(1.0);
            }
            return new Double(0.0);
        }
        if (o instanceof XNodeSet) {
            return ((XNodeSet)o).toNumber();
        }
        if (o instanceof XPathAccessible && (d = ((XPathAccessible)o).toXpathNumber()) != null) {
            return d;
        }
        String s = XPU.toString(o);
        try {
            return new Double(s);
        }
        catch (NumberFormatException numberFormatException) {
            return new Double(Double.NaN);
        }
    }

    public static void toString(Object o, StringBuffer sb) {
        if (o != null) {
            if (o instanceof XPathAccessible) {
                ((XPathAccessible)o).appendXpathStringValue(sb);
            } else if (o instanceof Number) {
                DecimalFormat df = new DecimalFormat("############################0.##############################");
                sb.append(df.format(((Number)o).doubleValue()));
            } else {
                sb.append(o.toString());
            }
        }
    }

    public static String toString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof XPathAccessible) {
            return ((XPathAccessible)o).toXpathStringValue();
        }
        if (o instanceof Number) {
            DecimalFormat df = new DecimalFormat("###############################0.##################################");
            return df.format(((Number)o).doubleValue());
        }
        return o.toString();
    }

    public static Boolean toBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof XNodeSet) {
            return new Boolean(((XNodeSet)o).size() > 0);
        }
        if (o instanceof Number) {
            return new Boolean(((Number)o).doubleValue() != 0.0);
        }
        return new Boolean(((String)o).length() > 0);
    }

    public static XNodeSet getNodeSet(XNodeSet orig) {
        XNodeSet set = new XNodeSet();
        set.addAll(orig);
        return set;
    }

    public static XNodeSet getSingleNodeSet(String name, Object val, Object[] container, int containerIndex, XNode parent) {
        XNodeSet set = new XNodeSet();
        set.add(new XNode(name, val, container, containerIndex, parent));
        return set;
    }

    public static XNodeSet getSingleNodeSet(String name, Object val, Object[] container, int containerIndex) {
        return XPU.getSingleNodeSet(name, val, container, containerIndex, null);
    }

    public static XNodeSet getSingleNodeSet(XNode node) {
        XNodeSet set = new XNodeSet();
        set.add(node);
        return set;
    }

    public static XNodeSet nameTest(XNodeSet set, String name) {
        if (name.equals("*")) {
            return set;
        }
        XNodeSet ret = new XNodeSet();
        if (name.endsWith("*")) {
            name = name.substring(0, name.length() - 1);
            int i = 0;
            while (i < set.size()) {
                XNode node = set.get(i);
                if (node.name.startsWith(name)) {
                    ret.add(node);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < set.size()) {
                XNode node = set.get(i);
                if (node.name.equals(name)) {
                    ret.add(node);
                }
                ++i;
            }
        }
        return ret;
    }

    public static Double toNumber(XNodeSet set, Object o, int pos, XNodeSet context) {
        return XPU.toNumber(o);
    }

    public static String toString(XNodeSet set, Object o, int pos, XNodeSet context) {
        return XPU.toString(o);
    }

    public static Boolean toBoolean(XNodeSet set, Object o, int pos, XNodeSet context) {
        return XPU.toBoolean(o);
    }

    public static Boolean stringContains(XNodeSet set, Object o1, Object o2, int pos, XNodeSet context) {
        String s1 = (String)o1;
        String s2 = (String)o2;
        return new Boolean(s1.indexOf(s2) != -1);
    }

    public static Boolean stringStartsWith(XNodeSet set, Object o1, Object o2, int pos, XNodeSet context) {
        String s1 = (String)o1;
        String s2 = (String)o2;
        return new Boolean(s1.startsWith(s2));
    }

    public static Double stringLength(XNodeSet set, Object o, int pos, XNodeSet context) {
        String s1 = (String)o;
        return new Double(s1.length());
    }

    public static Boolean booleanTrue(XNodeSet set, int pos, XNodeSet context) {
        return Boolean.TRUE;
    }

    public static Boolean booleanFalse(XNodeSet set, int pos, XNodeSet context) {
        return Boolean.FALSE;
    }

    public static Boolean booleanNot(XNodeSet set, Object o, int pos, XNodeSet context) {
        Boolean b = (Boolean)o;
        return new Boolean(b == false);
    }

    public static Double numberFloor(XNodeSet set, Object o, int pos, XNodeSet context) {
        Number num = (Number)o;
        return new Double(Math.floor(num.doubleValue()));
    }

    public static Double numberCeiling(XNodeSet set, Object o, int pos, XNodeSet context) {
        Number num = (Number)o;
        return new Double(Math.ceil(num.doubleValue()));
    }

    public static Double numberRound(XNodeSet set, Object o, int pos, XNodeSet context) {
        Number num = (Number)o;
        return new Double(Math.floor(0.5 + num.doubleValue()));
    }

    public static Double numberSum(XNodeSet set, int pos, XNodeSet context) {
        double d = 0.0;
        int i = 0;
        while (i < set.size()) {
            XNode node = set.get(i);
            d += XPU.toNumber(node).doubleValue();
            ++i;
        }
        return new Double(d);
    }

    public static XNodeSet child(XNodeSet set, int pos, XNodeSet context) {
        XNodeSet ret = new XNodeSet();
        int i = 0;
        while (i < set.size()) {
            XNode node = set.get(i);
            XNodeSet children = node.getValue().getFieldSet(node);
            ret.addAll(children);
            ++i;
        }
        return ret;
    }

    public static XNodeSet descendant(XNodeSet set, int pos, XNodeSet context) {
        XNodeSet ret = new XNodeSet();
        int i = 0;
        while (i < set.size()) {
            XNode node = set.get(i);
            ret.add(node);
            XNodeSet tmp = node.getValue().getFieldSet(node);
            if (tmp.size() > 0) {
                ret.addAll(XPU.descendant(tmp, pos, context));
            }
            ++i;
        }
        return ret;
    }

    public static XNodeSet parent(XNodeSet set, int pos, XNodeSet context) {
        XNodeSet ret = new XNodeSet();
        int i = 0;
        while (i < set.size()) {
            XNode node = set.get(i).getParent();
            if (node != null) {
                ret.add(node);
            }
            ++i;
        }
        return ret;
    }

    public static XNodeSet ancestor(XNodeSet set, int pos, XNodeSet context) {
        XNodeSet ret = new XNodeSet();
        int i = 0;
        while (i < set.size()) {
            XNode node = set.get(i).getParent();
            if (node != null) {
                ret.add(node);
            }
            ++i;
        }
        ret.addAll(XPU.ancestor(ret, pos, context));
        return ret;
    }
}

