/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.eclipse.stp.b2j.core.jengine.internal.utils.CharStack;

public class XSDUtil {
    private static final double ONE_SECOND = 1000.0;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final long ONE_MONTH = 2678400000L;
    private static final long ONE_YEAR = 31536000000L;
    private static SimpleDateFormat sdf_gMonthDay = new SimpleDateFormat("--MM-dd");
    private static SimpleDateFormat sdf_gMonthDayString = new SimpleDateFormat("--MM-ddZ");
    private static SimpleDateFormat sdf_gDay = new SimpleDateFormat("---dd");
    private static SimpleDateFormat sdf_gDayString = new SimpleDateFormat("---ddZ");
    private static SimpleDateFormat sdf_gYearMonth = new SimpleDateFormat("yyyy--MM");
    private static SimpleDateFormat sdf_gYearMonthString = new SimpleDateFormat("yyyy-MMZ");
    private static SimpleDateFormat sdf_gYear = new SimpleDateFormat("yyyy");
    private static SimpleDateFormat sdf_gYearString = new SimpleDateFormat("yyyyZ");
    private static SimpleDateFormat sdf_gMonth = new SimpleDateFormat("--MM--");
    private static SimpleDateFormat sdf_gMonthString = new SimpleDateFormat("--MM--Z");
    private static SimpleDateFormat sdf_time = new SimpleDateFormat("HH:mm:ss");
    private static SimpleDateFormat sdf_timeMS = new SimpleDateFormat("HH:mm:ss.SSS");
    private static SimpleDateFormat sdf_timeString = new SimpleDateFormat("HH:mm:ss.SSSZ");
    private static SimpleDateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat sdf_dateString = new SimpleDateFormat("yyyy-MM-ddZ");
    private static SimpleDateFormat sdf_dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static SimpleDateFormat sdf_dateTimeMS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static SimpleDateFormat sdf_dateTimeString = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    private static int charArrayIndexOf(char c, char[] cs, int cslen, int index) {
        int i = index;
        while (i < cslen) {
            if (cs[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int stringBufferIndexOf(char c, StringBuffer sb, int index) {
        int sblen = sb.length();
        int i = index;
        while (i < sblen) {
            if (sb.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String fromXMLString(String s) {
        char[] cs = s.toCharArray();
        int cslen = cs.length;
        StringBuffer ret = new StringBuffer();
        char cs0 = '\u0000';
        char cs1 = '\u0000';
        char cs2 = '\u0000';
        char cs3 = '\u0000';
        char cs4 = '\u0000';
        char cs5 = '\u0000';
        int i = 0;
        while (i < cslen) {
            cs0 = cs[i];
            if (cs0 == '&') {
                int len = cslen - i;
                if (len > 3) {
                    cs1 = cs[i + 1];
                    cs2 = cs[i + 2];
                    cs3 = cs[i + 3];
                    if (cs1 == '#') {
                        int end_parse = XSDUtil.charArrayIndexOf(';', cs, cslen, i + 1);
                        if (end_parse != -1) {
                            char ccode = (char)Integer.parseInt(new String(cs, i + 2, end_parse - (i + 2)));
                            ret.append(String.valueOf(ccode));
                            i = end_parse;
                        }
                    } else if (cs1 == 'l' && cs2 == 't' && cs3 == ';') {
                        ret.append('<');
                        i += 3;
                    } else if (cs1 == 'g' && cs2 == 't' && cs3 == ';') {
                        ret.append('>');
                        i += 3;
                    }
                }
                if (len > 4) {
                    cs4 = cs[i + 4];
                    if (cs1 == 'a' && cs2 == 'm' && cs3 == 'p' && cs4 == ';') {
                        ret.append('&');
                        i += 4;
                    }
                }
                if (len > 5) {
                    cs5 = cs[i + 5];
                    if (cs1 == 'q' && cs2 == 'u' && cs3 == 'o' && cs4 == 't' && cs5 == ';') {
                        ret.append('\"');
                        i += 5;
                    } else if (cs1 == 'a' && cs2 == 'p' && cs3 == 'o' && cs4 == 's' && cs5 == ';') {
                        ret.append('\'');
                        i += 5;
                    }
                }
            } else {
                ret.append(cs0);
            }
            ++i;
        }
        return ret.toString();
    }

    public static String toXmlString(String val) {
        return XSDUtil.toXMLString(val);
    }

    public static String toXMLString(String val) {
        if (val == null) {
            return val;
        }
        if (val.indexOf(38) == -1) {
            return val;
        }
        char[] cs = val.toCharArray();
        int cslen = cs.length;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < cslen) {
            char c = cs[i];
            if (c == '>') {
                sb.append("&gt;");
            } else if (c == '<') {
                sb.append("&lt;");
            } else if (c == '\"') {
                sb.append("&quot;");
            } else if (c == '\'') {
                sb.append("&apos;");
            } else if (c == '&') {
                sb.append("&amp;");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static long parseDuration(String s) throws Exception {
        CharStack stack = new CharStack(s);
        boolean negate = false;
        char c = stack.pop();
        if (c == '-') {
            negate = true;
            c = stack.pop();
        }
        if (c != 'P') {
            throw new Exception("Error parsing duration - expected P or - (" + s + ")");
        }
        long ms = 0L;
        boolean time = false;
        if (stack.peek() == 'T') {
            time = true;
            stack.pop();
        }
        while (!stack.isEmpty()) {
            double num = stack.popNumber();
            long inum = (long)num;
            char type = stack.pop();
            if (type == 'S') {
                ms += (long)((int)(num *= 1000.0));
                continue;
            }
            if (type == 'T') {
                time = true;
                continue;
            }
            if (type == 'M') {
                if (time) {
                    ms += inum * 60000L;
                    continue;
                }
                ms += inum * 2678400000L;
                continue;
            }
            if (type == 'H') {
                ms += inum * 3600000L;
                continue;
            }
            if (type == 'D') {
                ms += inum * 86400000L;
                continue;
            }
            if (type != 'Y') continue;
            ms += inum * 31536000000L;
        }
        if (negate) {
            return -ms;
        }
        return ms;
    }

    private static long appendInt(StringBuffer sb, long t, long div, char postfix) {
        long c = t / div;
        if (c > 0L) {
            sb.append(c);
            sb.append(postfix);
        }
        return t - c * div;
    }

    private static long appendDecimal(StringBuffer sb, long t, double div, char postfix) {
        double c = (double)t / div;
        if (c > 0.0) {
            sb.append(c);
            sb.append(postfix);
        }
        return t - (long)(c * div);
    }

    public static String toDuration(long t) {
        StringBuffer sb = new StringBuffer();
        StringBuffer sbt = new StringBuffer();
        if (t < 0L) {
            sb.append("-");
            t = -t;
        }
        sb.append("P");
        t = XSDUtil.appendInt(sb, t, 31536000000L, 'Y');
        t = XSDUtil.appendInt(sb, t, 2678400000L, 'M');
        t = XSDUtil.appendInt(sb, t, 86400000L, 'D');
        t = XSDUtil.appendInt(sbt, t, 3600000L, 'H');
        t = XSDUtil.appendInt(sbt, t, 60000L, 'M');
        t = XSDUtil.appendDecimal(sbt, t, 1000.0, 'S');
        if (sbt.length() > 0) {
            sb.append("T");
            sb.append(sbt.toString());
        }
        return sb.toString();
    }

    private static String toXsdTimeZone(String s) {
        int len = s.length();
        return String.valueOf(s.substring(0, len - 2)) + ":" + s.substring(len - 2);
    }

    private static TimeZone getTimeZone(String tz) {
        SimpleTimeZone timezone = null;
        if (tz.endsWith("Z")) {
            timezone = new SimpleTimeZone(0, "GMT+00:00");
        } else {
            int len = tz.length();
            char c = tz.charAt(len - 6);
            if (c == '-') {
                String id = tz.substring(len - 6);
                CharStack stack = new CharStack(tz, len - 5);
                int rawOffset = 0;
                rawOffset = (int)((long)rawOffset - 3600000L * (long)((int)stack.popNumber()));
                stack.pop();
                rawOffset = (int)((long)rawOffset - 60000L * (long)((int)stack.popNumber()));
                timezone = new SimpleTimeZone(rawOffset, "GMT" + id);
            } else if (c == '+') {
                String id = tz.substring(len - 6);
                CharStack stack = new CharStack(tz, len - 5);
                int rawOffset = 0;
                rawOffset = (int)((long)rawOffset + 3600000L * (long)((int)stack.popNumber()));
                stack.pop();
                rawOffset = (int)((long)rawOffset + 60000L * (long)((int)stack.popNumber()));
                timezone = new SimpleTimeZone(rawOffset, "GMT" + id);
            } else {
                timezone = new SimpleTimeZone(0, "GMT+00:00");
            }
        }
        return timezone;
    }

    public static GregorianCalendar parseGMonthDay(String s) throws Exception {
        s = s.trim();
        GregorianCalendar cal = new GregorianCalendar(XSDUtil.getTimeZone(s));
        cal.setTime(sdf_gMonthDay.parse(s));
        return cal;
    }

    public static String toGMonthDay(GregorianCalendar cal) {
        SimpleDateFormat sdf = (SimpleDateFormat)sdf_gMonthDayString.clone();
        sdf.setTimeZone(cal.getTimeZone());
        return XSDUtil.toXsdTimeZone(sdf.format(cal));
    }

    public static GregorianCalendar parseGDay(String s) throws Exception {
        s = s.trim();
        GregorianCalendar cal = new GregorianCalendar(XSDUtil.getTimeZone(s));
        cal.setTime(sdf_gDay.parse(s));
        return cal;
    }

    public static String toGDay(GregorianCalendar cal) {
        SimpleDateFormat sdf = (SimpleDateFormat)sdf_gDayString.clone();
        sdf.setTimeZone(cal.getTimeZone());
        return XSDUtil.toXsdTimeZone(sdf.format(cal));
    }

    public static GregorianCalendar parseGYearMonth(String s) throws Exception {
        if ((s = s.trim()).charAt(0) == '-') {
            s = s.substring(1);
        }
        GregorianCalendar cal = new GregorianCalendar(XSDUtil.getTimeZone(s));
        cal.setTime(sdf_gYearMonth.parse(s));
        return cal;
    }

    public static String toGYearMonth(GregorianCalendar cal) {
        SimpleDateFormat sdf = (SimpleDateFormat)sdf_gYearMonthString.clone();
        sdf.setTimeZone(cal.getTimeZone());
        return XSDUtil.toXsdTimeZone(sdf.format(cal));
    }

    public static GregorianCalendar parseGYear(String s) throws Exception {
        if ((s = s.trim()).charAt(0) == '-') {
            s = s.substring(1);
        }
        GregorianCalendar cal = new GregorianCalendar(XSDUtil.getTimeZone(s));
        cal.setTime(sdf_gYear.parse(s));
        return cal;
    }

    public static String toGYear(GregorianCalendar cal) {
        SimpleDateFormat sdf = (SimpleDateFormat)sdf_gYearString.clone();
        sdf.setTimeZone(cal.getTimeZone());
        return XSDUtil.toXsdTimeZone(sdf.format(cal));
    }

    public static GregorianCalendar parseGMonth(String s) throws Exception {
        s = s.trim();
        GregorianCalendar cal = new GregorianCalendar(XSDUtil.getTimeZone(s));
        cal.setTime(sdf_gMonth.parse(s));
        return cal;
    }

    public static String toGMonth(GregorianCalendar cal) {
        SimpleDateFormat sdf = (SimpleDateFormat)sdf_gMonthString.clone();
        sdf.setTimeZone(cal.getTimeZone());
        return XSDUtil.toXsdTimeZone(sdf.format(cal));
    }

    public static GregorianCalendar parseTime(String s) throws Exception {
        s = s.trim();
        GregorianCalendar cal = new GregorianCalendar(XSDUtil.getTimeZone(s));
        if (s.charAt(8) == '.') {
            cal.setTime(sdf_timeMS.parse(s));
        } else {
            cal.setTime(sdf_time.parse(s));
        }
        return cal;
    }

    public static String toTime(GregorianCalendar cal) {
        SimpleDateFormat sdf = (SimpleDateFormat)sdf_timeString.clone();
        sdf.setTimeZone(cal.getTimeZone());
        return XSDUtil.toXsdTimeZone(sdf.format(cal));
    }

    public static GregorianCalendar parseDate(String s) throws Exception {
        if ((s = s.trim()).charAt(0) == '-') {
            s = s.substring(1);
        }
        GregorianCalendar cal = new GregorianCalendar(XSDUtil.getTimeZone(s));
        cal.setTime(sdf_date.parse(s));
        return cal;
    }

    public static String toDate(GregorianCalendar cal) {
        SimpleDateFormat sdf = (SimpleDateFormat)sdf_dateString.clone();
        sdf.setTimeZone(cal.getTimeZone());
        return XSDUtil.toXsdTimeZone(sdf.format(cal));
    }

    public static GregorianCalendar parseDateTime(String s) throws Exception {
        if ((s = s.trim()).charAt(0) == '-') {
            s = s.substring(1);
        }
        GregorianCalendar cal = new GregorianCalendar(XSDUtil.getTimeZone(s));
        if (s.charAt(19) == '.') {
            cal.setTime(sdf_dateTimeMS.parse(s));
        } else {
            cal.setTime(sdf_dateTime.parse(s));
        }
        return cal;
    }

    public static String toDateTime(GregorianCalendar cal) {
        SimpleDateFormat sdf = (SimpleDateFormat)sdf_dateTimeString.clone();
        sdf.setTimeZone(cal.getTimeZone());
        return XSDUtil.toXsdTimeZone(sdf.format(cal.getTime()));
    }

    public static void main(String[] args) {
        try {
            System.out.println(XSDUtil.fromXMLString("_&apos;&lt;&gt;&quot;&amp;_&apos;"));
            long t = XSDUtil.parseDuration("PT12.3S");
            System.out.println(t);
            String s = XSDUtil.toDuration(t);
            System.out.println(s);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(System.currentTimeMillis());
            System.out.println(gc.getTimeInMillis());
            System.out.println(XSDUtil.parseDateTime(XSDUtil.toDateTime(gc)).getTimeInMillis());
            System.out.println(XSDUtil.parseDateTime("2004-12-01T00:00:00Z").getTime());
            System.out.println(sdf_date.parse("2004-12-01").getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

