/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.misc.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static String nodeToString(Node n) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtil.nodeToString(n, bout);
        return new String(bout.toByteArray());
    }

    public static String nodeChildrenToString(Node n) throws Exception {
        StringBuffer sb = new StringBuffer();
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            sb.append(XMLUtil.nodeToString(children.item(i)));
            ++i;
        }
        return sb.toString();
    }

    public static void nodeToString(Node n, OutputStream out) throws Exception {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource ds = new DOMSource(n);
        StreamResult res = new StreamResult(out);
        tf.transform(ds, res);
    }

    public static String documentToString(Node n) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtil.documentToString(n, bout);
        return new String(bout.toByteArray());
    }

    public static void documentToString(Node n, OutputStream out) throws Exception {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        DOMSource ds = new DOMSource(n);
        StreamResult res = new StreamResult(out);
        tf.transform(ds, res);
    }

    public static void documentToCleanString(Node n, OutputStream out) throws Exception {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        DOMSource ds = new DOMSource(n);
        StreamResult res = new StreamResult(out);
        tf.transform(ds, res);
    }

    public static Document documentFromString(String doc) throws Exception {
        return XMLUtil.getDocumentBuilder().parse(new ByteArrayInputStream(doc.getBytes()));
    }

    public static Document documentFromString(InputStream in) throws Exception {
        return XMLUtil.getDocumentBuilder().parse(in);
    }

    public static Document blankDocument(String type) throws Exception {
        Document doc = XMLUtil.getDocumentBuilder().newDocument();
        Element element = doc.createElement(type);
        doc.appendChild(element);
        return doc;
    }

    public static DocumentBuilder getDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder;
    }
}

