/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.stp.b2j.core.misc.internal.B2jClassLoader;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransportProvider;

public class SessionTransportLoader {
    public static SessionTransportProvider getTransportProvider(String classname) {
        try {
            SessionTransportProvider[] transports = SessionTransportLoader.getTransports();
            int i = 0;
            while (i < transports.length) {
                if (transports[i].getProviderClassName().equals(classname)) {
                    return transports[i];
                }
                ++i;
            }
            return null;
        }
        catch (Throwable throwable) {
            try {
                return (SessionTransportProvider)B2jClassLoader.load(classname).newInstance();
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    public static SessionTransportProvider[] getTransportsUnfiltered() throws Exception {
        ArrayList providers = SessionTransportLoader.getExtensionPointClasses();
        SessionTransportProvider[] array = new SessionTransportProvider[providers.size()];
        providers.toArray(array);
        return array;
    }

    public static SessionTransportProvider[] getTransports() throws Exception {
        ArrayList providers = SessionTransportLoader.getExtensionPointClasses();
        SessionTransportProvider[] array = new SessionTransportProvider[providers.size()];
        providers.toArray(array);
        return array;
    }

    private static ArrayList getExtensionPointClasses() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList classes = new ArrayList();
        DependencyInfo[] deps = B2jPlatform.getAllDependencyInfo();
        int i = 0;
        while (i < deps.length) {
            Properties[] props = deps[i].getSessionTransports();
            int k = 0;
            while (k < props.length) {
                Class z = B2jClassLoader.load(props[k].getProperty("Class"));
                classes.add(z.newInstance());
                ++k;
            }
            ++i;
        }
        return classes;
    }
}

