/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageUtils;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ClassDefiner;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class Program {
    private static int PROGRAM_START = 99;
    private static int PROGRAM_END = 100;
    private static int PROGRAM_CLASS = 101;
    private static int PROGRAM_HOST = 102;
    private static int PROGRAM_EXTRA_CLASS = 103;
    private ArrayList addresses = new ArrayList();
    private ArrayList daemonaddresses = new ArrayList();
    private byte[] the_class = null;
    private Class real_class = null;
    private Object build_LOCK = new Object();
    private ArrayList extra_classes = new ArrayList();
    private static StreamUtils su = new StreamUtils();
    private JARDependency[] dependencies;

    public JARDependency[] getDependencies() {
        return this.dependencies;
    }

    private Program() {
    }

    public Program(byte[] main_class, byte[][] classes, JARDependency[] deps) {
        this.the_class = main_class;
        this.dependencies = deps;
        int i = 0;
        while (i < classes.length) {
            this.extra_classes.add(classes[i]);
            ++i;
        }
    }

    private void loadExtras(ClassDefiner definer) throws Exception {
        ArrayList left = new ArrayList();
        left.addAll(this.extra_classes);
        while (left.size() > 0) {
            StringBuffer errors = new StringBuffer();
            boolean cannot_ignore = false;
            int lsize = left.size();
            int i = 0;
            while (i < left.size()) {
                byte[] dat = (byte[])left.get(i);
                try {
                    definer.define(dat, 0, dat.length);
                    left.remove(i--);
                }
                catch (LinkageError e) {
                    errors.append("\nIGNORED LINKAGE ERROR: " + e);
                }
                catch (Throwable e) {
                    cannot_ignore = true;
                    errors.append("\n" + e);
                }
                ++i;
            }
            if (lsize != left.size()) continue;
            if (cannot_ignore) {
                throw new Exception(String.valueOf(left.size()) + " extra classes failed to load - " + errors);
            }
            if (errors.length() > 0) {
                Logger.warning("Ignored the following errors:\n" + errors);
            }
            left.clear();
        }
    }

    private Class build(byte[] class_bytes, ClassDefiner definer) throws Exception {
        return definer.define(class_bytes, 0, class_bytes.length);
    }

    public void addHostAddress(SessionAddress address, SessionAddress daemonaddress) {
        this.addresses.add(address);
        this.daemonaddresses.add(daemonaddress);
    }

    public int getAddressCount() {
        return this.addresses.size();
    }

    public SessionAddress getHostAddress(int index) {
        return (SessionAddress)this.addresses.get(index);
    }

    public SessionAddress getDaemonAddress(int index) {
        return (SessionAddress)this.daemonaddresses.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getProgramClass(URL[] dependencies) throws Exception {
        Object object = this.build_LOCK;
        synchronized (object) {
            if (this.real_class == null) {
                ClassDefiner definer = new ClassDefiner(dependencies);
                this.real_class = this.build(this.the_class, definer);
                this.loadExtras(definer);
            }
        }
        return this.real_class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getProgramClass(URL[] dependencies, ClassLoader loader) throws Exception {
        Object object = this.build_LOCK;
        synchronized (object) {
            if (this.real_class == null) {
                ClassDefiner definer = new ClassDefiner(dependencies, loader);
                this.real_class = this.build(this.the_class, definer);
                this.loadExtras(definer);
            }
        }
        return this.real_class;
    }

    public ArrayList getAddresses() {
        return this.addresses;
    }

    public ArrayList getDaemonAddresses() {
        return this.daemonaddresses;
    }

    private String strip(String source) {
        StringBuffer prog = new StringBuffer();
        int n = 0;
        while (true) {
            if ((n = source.indexOf("//@@START_STRIP", n)) == -1) break;
            int n_end = source.indexOf("//@@END_STRIP", n);
            prog.append(source.substring(0, n));
            source = source.substring(n_end);
        }
        prog.append(source);
        return prog.toString();
    }

    private String readAll(InputStream source) throws Exception {
        byte[] buf = new byte[1024];
        StringBuffer sbuf = new StringBuffer();
        int n = 0;
        while (n != -1) {
            n = source.read(buf, 0, buf.length);
            if (n <= 0) continue;
            sbuf.append(new String(buf, 0, n));
        }
        return sbuf.toString();
    }

    public byte[] writeProgram() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeProgram(bout);
        return bout.toByteArray();
    }

    public void writeProgram(OutputStream out) throws IOException {
        try {
            Message m = new Message(PROGRAM_START);
            MessageUtils.writeMessage(out, m);
            m = new Message(PROGRAM_CLASS);
            m.append(this.the_class);
            MessageUtils.writeMessage(out, m);
            int i = 0;
            while (i < this.extra_classes.size()) {
                m = new Message(PROGRAM_EXTRA_CLASS);
                m.append((byte[])this.extra_classes.get(i));
                MessageUtils.writeMessage(out, m);
                ++i;
            }
            i = 0;
            while (i < this.addresses.size()) {
                m = new Message(PROGRAM_HOST);
                m.append(SessionAddress.toString((SessionAddress)this.addresses.get(i)));
                m.append(SessionAddress.toString((SessionAddress)this.daemonaddresses.get(i)));
                MessageUtils.writeMessage(out, m);
                ++i;
            }
            m = new Message(PROGRAM_END);
            MessageUtils.writeMessage(out, m);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("" + e);
        }
    }

    public static Program readProgram(byte[] in) throws IOException {
        return Program.readProgram(new ByteArrayInputStream(in));
    }

    public static Program readProgram(InputStream in) throws IOException {
        try {
            Program p = new Program();
            Message m = MessageUtils.readMessage(in);
            if (m.getType() != PROGRAM_START) {
                throw Program.formatE("did not find program start message");
            }
            m = MessageUtils.readMessage(in);
            while (m.getType() != PROGRAM_END) {
                int t = m.getType();
                if (t == PROGRAM_CLASS) {
                    p.the_class = (byte[])m.get(0);
                } else if (t == PROGRAM_EXTRA_CLASS) {
                    p.extra_classes.add((byte[])m.get(0));
                } else if (t == PROGRAM_HOST) {
                    SessionAddress host = SessionAddress.fromString((String)m.get(0));
                    SessionAddress daemon = null;
                    if (m.length() > 0) {
                        daemon = SessionAddress.fromString((String)m.get(1));
                    } else {
                        daemon = (SessionAddress)host.clone();
                        daemon.setRequiresEncryption(false);
                        daemon.setPassword(null);
                    }
                    p.addHostAddress(host, daemon);
                } else {
                    Logger.error("PROGRAM: unrecognised message type " + m);
                }
                m = MessageUtils.readMessage(in);
            }
            return p;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("" + e);
        }
    }

    private static IOException formatE(Object o) {
        return new IOException("Program:" + o.toString());
    }

    private static void debug(Object o) {
        Logger.info("Program:" + o.toString());
    }
}

