/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.api;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.stp.b2j.core.jengine.internal.api.EngineFactory;
import org.eclipse.stp.b2j.core.jengine.internal.api.Program;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.DaemonInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedSemaphore;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SoapDaemon;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class Test
implements TraceListener {
    boolean SHOW_PRINTS = true;
    boolean SHOW_THROUGHPUT = true;
    int TRACES_PER_USER = 2;
    long l = System.currentTimeMillis();
    double n = 0.0;

    public static void main(String[] args) {
        new Test(args);
    }

    public Test(String[] args) {
        Runtime runtime = Runtime.getRuntime();
        System.out.println(String.valueOf(runtime.totalMemory()) + " " + (runtime.totalMemory() - runtime.freeMemory()));
        System.out.println("Java Engine Test");
        if (args.length < 1) {
            System.out.println("Usage: Test <program source file>");
            System.exit(1);
        }
        try {
            FileInputStream fin = new FileInputStream(args[0]);
            System.out.println("Getting program");
            Program p = null;
            fin.close();
            SessionAddress addr = new SessionAddress("localhost", -1, -1, "localhost", SoapDaemon.DAEMON_PORT, SoapDaemon.DAEMON_PORT);
            p.addHostAddress(addr, addr);
            System.out.println("Starting a SoapDaemon");
            new SoapDaemon(new File("."), new File("./b2j.jar"), SoapDaemon.DAEMON_PORT);
            System.out.println("Connecting to daemon");
            DaemonInterface dcon = EngineFactory.connectToMainEngineDaemon(new SessionAddress("localhost", -1, -1, "localhost", SoapDaemon.DAEMON_PORT, SoapDaemon.DAEMON_PORT));
            System.out.println("Creating a new engine");
            ControllerInterface ccon = dcon.newEngine("My Engine " + System.currentTimeMillis(), this, new JARDependency[0], addr);
            System.out.println("Running the program");
            ccon.setProgram(p);
            ccon.launchRunner(1, "engine_main", 0);
            System.out.println("Program launched!");
            SharedVariable runmult = null;
            SharedSemaphore usercount = null;
            while (true) {
                try {
                    Thread.sleep(1000L);
                    runmult = ccon.getVariable("run_multiplier");
                    usercount = ccon.getSemaphore("usercount");
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
            try {
                runmult.varFetch();
                System.out.println("RUN MULTIPLIER = " + runmult);
                System.out.println("USERCOUNT = " + usercount);
                usercount.semSignal(1000);
                System.out.println("Usercount 100, run multiplier 1");
                Thread.sleep(20000L);
                System.out.println("Usercount 100, run multiplier 10");
                runmult.setValue(10);
                runmult.varStore();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void trace(Message trace) {
        if (this.SHOW_THROUGHPUT) {
            if (System.currentTimeMillis() > this.l) {
                this.n /= 2.0;
                this.n /= (double)this.TRACES_PER_USER;
                System.out.println(this.n);
                this.l = System.currentTimeMillis() + 2000L;
                this.n = 0.0;
            }
            this.n += 1.0;
        }
    }

    public void print(String msg) {
        if (this.SHOW_PRINTS) {
            if (msg.endsWith("\n")) {
                System.out.print("ENGINE:" + msg);
            } else {
                System.out.println("ENGINE:" + msg);
            }
        }
    }

    public void debug(String msg) {
        if (this.SHOW_PRINTS) {
            if (msg.endsWith("\n")) {
                System.out.print("ENGINE DEBUG:" + msg);
            } else {
                System.out.println("ENGINE DEBUG:" + msg);
            }
        }
    }
}

