/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdl;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.eclipse.stp.b2j.core.misc.internal.XMLUtil;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslatorException;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLTypeTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslatorException;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.CompilerUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDLTranslator {
    XSDTypeTranslator[] codecs;
    XSDMap xsdmap;
    WSDLMap wsdlmap;
    NamespaceTranslator nt;
    TranslatorLog log;
    String LOG_SOURCE = "WSDLTranslator";

    public WSDLTranslator(Util compiler_util, TranslatorLog log, XSDMap xsdmap, WSDLMap wsdlmap) {
        this.xsdmap = xsdmap;
        this.wsdlmap = wsdlmap;
        this.log = log;
        this.nt = compiler_util.createNamespaceTranslator();
    }

    public void translateMessage(ArrayList states, Element elem) throws NamespaceException {
        String bname = elem.getAttribute("name");
        String pkg = this.nt.getPackage(bname, true);
        String name = NamespaceTranslator.getName(bname);
        WSDLState state = new WSDLState(pkg, name, "java.lang.Object");
        state.addInterface("org.eclipse.stp.b2j.core.jengine.internal.utils.XPathAccessible");
        state.setMessage(true);
        ArrayList parts = Util.getAllElements(elem, "part");
        String[] part_types = new String[parts.size()];
        String[] part_names = new String[parts.size()];
        String[] part_elements = new String[parts.size()];
        int i = 0;
        while (i < parts.size()) {
            String qtype;
            String pname;
            Element part = (Element)parts.get(i);
            String pnamealias = pname = part.getAttribute("name");
            String ptype = part.getAttribute("type");
            if (ptype.length() == 0) {
                ptype = part.getAttribute("element");
                pnamealias = NamespaceTranslator.getName(part.getAttribute("element"));
            }
            part_types[i] = qtype = this.nt.qualify(ptype, false);
            part_names[i] = pname;
            part_elements[i] = pnamealias;
            state.addField(qtype, NamespaceTranslator.getElement(pname), pnamealias);
            state.appendLine("public " + qtype + "[] " + NamespaceTranslator.getElement(pname) + " = new " + qtype + "[0];");
            ++i;
        }
        i = 0;
        while (i < this.codecs.length) {
            if (this.codecs[i] instanceof WSDLTypeTranslator) {
                try {
                    this.codecs[i].translateComplex(this.nt, name, new String[0], new String[0], part_types, part_names, part_elements, elem);
                    state.appendLine(this.codecs[i].getMethods());
                    state.addInterfaces(this.codecs[i].getImplementations());
                    state.addImports(this.codecs[i].getImports());
                }
                catch (XSDTypeTranslatorException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        states.add(state);
    }

    public void translatePortType(ArrayList states, Element elem) throws NamespaceException {
        String bname = elem.getAttribute("name");
        String pkg = this.nt.getPackage(bname, true);
        String name = NamespaceTranslator.getName(bname);
        WSDLState state = new WSDLState(pkg, name);
        state.setInterface(true);
        ArrayList ops = Util.getAllElements(elem, "operation");
        int i = 0;
        while (i < ops.size()) {
            Element op = (Element)ops.get(i);
            this.translateOperation(state, op);
            ++i;
        }
        this.log.logWarning(this.LOG_SOURCE, "Didn't add port interface " + bname + " to the compilation list because it doesn't have a purpose");
    }

    public void translateOperation(WSDLState state, Element elem) throws NamespaceException {
        String opname = elem.getAttribute("name");
        Element input = Util.getFirstElement(elem, "input");
        Element output = Util.getFirstElement(elem, "output");
        ArrayList faults = Util.getAllElements(elem, "fault");
        String inputname = "";
        if (input != null) {
            inputname = input.getAttribute("message");
            inputname = this.nt.qualify(inputname, false);
        }
        String outputname = "void";
        if (output != null) {
            outputname = output.getAttribute("message");
            outputname = this.nt.qualify(outputname, false);
        }
        if (faults.size() > 0) {
            state.appendLine("public " + outputname + " " + opname + "(" + inputname + " input) throws ");
            state.incrementScope();
            int i = 0;
            while (i < faults.size()) {
                Element fault = (Element)faults.get(i);
                String faultname = fault.getAttribute("message");
                faultname = this.nt.qualify(faultname, false);
                state.appendLine(faultname);
                ++i;
            }
            state.appendLine(";");
            state.decrementScope();
        } else {
            state.appendLine("public " + outputname + " " + opname + "(" + inputname + " input);");
        }
    }

    public void translateDefinitions(ArrayList states, Element definitions) throws NamespaceException {
        this.nt.addNamespaces(definitions);
        ArrayList elems = Util.getAllElements(definitions);
        int i = 0;
        while (i < elems.size()) {
            Element def = (Element)elems.get(i);
            String name = NamespaceTranslator.getName(def);
            if (name.equals("message")) {
                this.translateMessage(states, def);
            } else if (name.equals("portType")) {
                this.translatePortType(states, def);
            } else {
                this.log.logWarning(this.LOG_SOURCE, "Unknown definition child \"" + name + "\"");
            }
            ++i;
        }
        this.nt.removeNamespaces(definitions);
    }

    public WSDLState[] getJava(String[] wsdl, WSDLBindingTranslator[] bindings, XSDTypeTranslator[] codecs) throws Exception {
        this.codecs = codecs;
        ArrayList states = new ArrayList();
        int w = 0;
        while (w < wsdl.length) {
            DocumentBuilder builder = XMLUtil.getDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(wsdl[w].getBytes()));
            Element definitions = doc.getDocumentElement();
            if (!NamespaceTranslator.getName(definitions).equals("definitions")) {
                throw new WSDLBindingTranslatorException("Expected top level <definitions> element but found " + definitions.getTagName());
            }
            int k = 0;
            while (k < codecs.length) {
                codecs[k].readWSDL(definitions);
                ++k;
            }
            k = 0;
            while (k < bindings.length) {
                bindings[k].readWSDL(definitions);
                ++k;
            }
            this.translateDefinitions(states, definitions);
            ++w;
        }
        HashMap<String, WSDLState> test = new HashMap<String, WSDLState>();
        int i = 0;
        while (i < states.size()) {
            WSDLState state = (WSDLState)states.get(i);
            if (test.get(state.getClassName()) != null) {
                states.remove(i--);
            } else {
                test.put(state.getClassName(), state);
            }
            ++i;
        }
        WSDLState[] ret = new WSDLState[states.size()];
        int i2 = 0;
        while (i2 < ret.length) {
            ret[i2] = (WSDLState)states.get(i2);
            ++i2;
        }
        return ret;
    }

    public CompilerUnit[] getDefinitionSources(String[] wsdl, WSDLBindingTranslator[] bindings, XSDTypeTranslator[] codecs) throws Exception {
        CompilerUnit[] java = this.getJava(wsdl, bindings, codecs);
        return java;
    }

    class WSDLState
    implements CompilerUnit {
        int SCOPE = 1;
        StringBuffer decl = new StringBuffer();
        StringBuffer prog = new StringBuffer();
        String pkg_name;
        String class_name;
        String base_class;
        boolean isMessage = false;
        boolean iface = false;
        ArrayList ifaces = new ArrayList();
        ArrayList imports = new ArrayList();
        ArrayList field_types = new ArrayList();
        ArrayList field_names = new ArrayList();
        ArrayList field_elements = new ArrayList();

        public WSDLState(String pkg_name, String class_name) {
            this.pkg_name = pkg_name;
            this.class_name = class_name;
        }

        public WSDLState(String pkg_name, String class_name, String extend) {
            this.pkg_name = pkg_name;
            this.class_name = class_name;
            this.base_class = extend;
        }

        public void setMessage(boolean b) {
            this.isMessage = b;
        }

        public void setInterface(boolean b) {
            this.iface = b;
        }

        private void addInterface(String iface) {
            this.ifaces.add(iface);
        }

        private void addInterfaces(String[] ifaces) {
            int i = 0;
            while (i < ifaces.length) {
                this.addInterface(ifaces[i]);
                ++i;
            }
        }

        private void addImport(String iport) {
            this.imports.add(iport);
        }

        private void addImports(String[] ifaces) {
            int i = 0;
            while (i < ifaces.length) {
                this.addImport(ifaces[i]);
                ++i;
            }
        }

        private void addField(String type, String name, String elemname) {
            this.field_types.add(type);
            this.field_names.add(name);
            this.field_elements.add(elemname);
        }

        public String getQualifiedName() {
            return String.valueOf(this.pkg_name) + "." + this.class_name;
        }

        public String getPackageName() {
            return this.pkg_name;
        }

        public String getClassName() {
            return NamespaceTranslator.getJavaClassName(this.class_name);
        }

        private void appendLine(String s) {
            int i = 0;
            while (i < this.SCOPE) {
                this.prog.append("  ");
                ++i;
            }
            this.prog.append(s).append("\n");
        }

        private void incrementScope() {
            ++this.SCOPE;
        }

        private void decrementScope() {
            if (this.SCOPE >= 1) {
                --this.SCOPE;
            }
        }

        public void declToString(StringBuffer buf) {
            buf.append(this.decl);
        }

        public void progToString(StringBuffer buf) {
            String clazz = "class";
            if (this.iface) {
                clazz = "interface";
            }
            buf.append("//@@START_STRIP\n");
            buf.append("package " + this.pkg_name + ";\n");
            buf.append("import org.eclipse.stp.b2j.core.jengine.internal.utils.*;\n");
            buf.append("import org.eclipse.stp.b2j.core.jengine.internal.core.*;\n");
            buf.append("import org.eclipse.stp.b2j.core.jengine.internal.message.Message;\n");
            int i = 0;
            while (i < this.imports.size()) {
                buf.append("import " + this.imports.get(i) + ";\n");
                ++i;
            }
            if (this.base_class == null) {
                buf.append("public " + clazz + " " + NamespaceTranslator.getJavaClassName(this.class_name) + "  \n");
            } else {
                buf.append("public " + clazz + " " + NamespaceTranslator.getJavaClassName(this.class_name) + " extends " + this.base_class + " \n");
            }
            if (this.ifaces.size() > 0) {
                buf.append(" implements\n");
            }
            i = 0;
            while (i < this.ifaces.size()) {
                buf.append("  " + this.ifaces.get(i));
                if (i < this.ifaces.size() - 1) {
                    buf.append(",");
                }
                buf.append("\n");
                ++i;
            }
            buf.append("{\n");
            buf.append("//@@END_STRIP\n");
            buf.append("\n");
            buf.append("  //WSDL messages have no tag name\n");
            buf.append("  public String " + NamespaceTranslator.getElementTagName() + " = null;\n");
            buf.append("\n");
            buf.append(this.prog);
            buf.append("\n");
            buf.append("public static String getStackTrace(Throwable t) {\n");
            buf.append("    try {\n");
            buf.append("  \t  java.io.ByteArrayOutputStream bout = new java.io.ByteArrayOutputStream();\n");
            buf.append("\t  t.printStackTrace(new java.io.PrintStream(bout));\n");
            buf.append("\t  return new String(bout.toByteArray());\n");
            buf.append("    } catch (Exception e) { return t.toString(); }\n");
            buf.append("}\n");
            buf.append("\n");
            if (this.isMessage) {
                this.xpathToString(buf);
            }
            buf.append("//@@START_STRIP\n");
            buf.append("}\n");
            buf.append("//@@END_STRIP\n\n");
        }

        public void xpathToString(StringBuffer buf) {
            String elemname;
            String fieldname;
            buf.append("public XNodeSet getFieldSet() {\n");
            buf.append("  XNodeSet fields = new XNodeSet(" + this.field_names.size() + ");\n");
            int i = 0;
            while (i < this.field_names.size()) {
                fieldname = String.valueOf(this.field_names.get(i));
                elemname = String.valueOf(this.field_elements.get(i));
                buf.append("  if (" + fieldname + " != null)\n");
                buf.append("    for (int i = 0; i < " + fieldname + ".length; i++)\n");
                buf.append("      fields.add(new XNode(\"" + elemname + "\"," + fieldname + "[i]," + fieldname + ",i,null));\n");
                ++i;
            }
            buf.append("  return fields;\n");
            buf.append("}\n");
            buf.append("public XNodeSet getFieldSet(XNode parent) {\n");
            buf.append("  XNodeSet fields = new XNodeSet(" + this.field_names.size() + ");\n");
            i = 0;
            while (i < this.field_names.size()) {
                fieldname = String.valueOf(this.field_names.get(i));
                elemname = String.valueOf(this.field_elements.get(i));
                buf.append("  if (" + fieldname + " != null)\n");
                buf.append("    for (int i = 0; i < " + fieldname + ".length; i++)\n");
                buf.append("      fields.add(new XNode(\"" + elemname + "\"," + fieldname + "[i]," + fieldname + ",i,parent));\n");
                ++i;
            }
            buf.append("  return fields;\n");
            buf.append("}\n");
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("//WSDL CLASS\n");
            this.declToString(buf);
            this.progToString(buf);
            return buf.toString();
        }
    }
}

