/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.BPELPartnerLinkRole;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.BPELPartnerLinkType;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.BPELProperty;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.BPELPropertyAlias;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.InvalidWsdlException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMessage;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLOperation;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLPortType;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.misc.internal.XMLConfigUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDLMap {
    String LOG_SOURCE = "WSDL Translator";
    TranslatorLog log;
    NamespaceTranslator nt;
    Util compiler_util;
    HashMap qname_to_portType = new HashMap();
    HashMap qname_to_message = new HashMap();
    HashMap qname_to_bpel_partnerLinkType = new HashMap();
    HashMap qname_to_bpel_property = new HashMap();
    ArrayList bpel_propertyAliasList = new ArrayList();

    public WSDLMessage getMessage(String qname) {
        return (WSDLMessage)this.qname_to_message.get(qname);
    }

    public WSDLPortType getPortType(String qname) {
        return (WSDLPortType)this.qname_to_portType.get(qname);
    }

    public BPELPartnerLinkType getPartnerLinkType(String qname) {
        return (BPELPartnerLinkType)this.qname_to_bpel_partnerLinkType.get(qname);
    }

    public BPELProperty getProperty(String qname) {
        return (BPELProperty)this.qname_to_bpel_property.get(qname);
    }

    public String[] getAllPropertyNames() {
        ArrayList list = new ArrayList();
        list.addAll(this.qname_to_bpel_property.keySet());
        String[] tmp = new String[list.size()];
        list.toArray(tmp);
        return tmp;
    }

    public BPELPropertyAlias[] getPropertyAliases() {
        BPELPropertyAlias[] tmp = new BPELPropertyAlias[this.bpel_propertyAliasList.size()];
        this.bpel_propertyAliasList.toArray(tmp);
        return tmp;
    }

    private void readPart(WSDLMessage m, Element part) throws NamespaceException, InvalidWsdlException {
        this.nt.addNamespaces(part);
        String name = part.getAttribute("name");
        String type = part.getAttribute("type");
        if (type.length() == 0) {
            type = part.getAttribute("element");
        }
        String qtype = this.nt.qualify(type, false);
        this.log.logInfo(this.LOG_SOURCE, "Found Message Part " + name + " (" + this.compiler_util.getQNameFromQName(qtype) + ")");
        m.part_to_xsdtype.put(name, qtype);
        this.nt.removeNamespaces(part);
    }

    private void readMessage(Element message) throws NamespaceException, InvalidWsdlException {
        this.nt.addNamespaces(message);
        String name = message.getAttribute("name");
        String qname = this.nt.qualify(name, true);
        WSDLMessage m = new WSDLMessage();
        m.qname = qname;
        this.log.logInfo(this.LOG_SOURCE, "message " + this.compiler_util.getQNameFromQName(qname));
        ArrayList parts = Util.getAllElements(message);
        int i = 0;
        while (i < parts.size()) {
            Element elem = (Element)parts.get(i);
            if (NamespaceTranslator.getName(elem).equals("part")) {
                this.readPart(m, elem);
            }
            ++i;
        }
        this.qname_to_message.put(qname, m);
        this.nt.removeNamespaces(message);
    }

    private void readPortType(Element port) throws NamespaceException, InvalidWsdlException {
        this.nt.addNamespaces(port);
        String type = port.getAttribute("name");
        WSDLPortType portType = new WSDLPortType();
        portType.name = this.nt.qualify(type, true);
        this.log.logInfo(this.LOG_SOURCE, "portType " + this.compiler_util.getQNameFromQName(portType.name));
        this.qname_to_portType.put(portType.name, portType);
        ArrayList ops = Util.getAllElements(port);
        int i = 0;
        while (i < ops.size()) {
            Element op = (Element)ops.get(i);
            this.nt.addNamespaces(op);
            if (NamespaceTranslator.getName(op).equals("operation")) {
                String opname = op.getAttribute("name");
                WSDLOperation operation = new WSDLOperation();
                boolean input_detected = false;
                boolean output_detected = false;
                ArrayList msgs = Util.getAllElements(op);
                int k = 0;
                while (k < msgs.size()) {
                    Element msg = (Element)msgs.get(k);
                    this.nt.addNamespaces(msg);
                    String msgtag = NamespaceTranslator.getName(msg);
                    String msgname = msg.getAttribute("name");
                    String msgtype = msg.getAttribute("message");
                    msgtype = this.nt.qualify(msgtype, false);
                    if (msgtag.equals("input")) {
                        input_detected = true;
                        operation.message_types.put("input", msgtype);
                        operation.type = output_detected ? 2 : 0;
                    } else if (msgtag.equals("output")) {
                        output_detected = true;
                        operation.message_types.put("output", msgtype);
                        operation.type = input_detected ? 1 : 3;
                    } else if (msgtag.equals("fault")) {
                        operation.message_types.put(msgname, msgtype);
                    }
                    this.nt.removeNamespaces(msg);
                    ++k;
                }
                this.log.logInfo(this.LOG_SOURCE, "  operation " + opname);
                portType.name_to_operation.put(opname, operation);
            }
            this.nt.removeNamespaces(op);
            ++i;
        }
        this.nt.removeNamespaces(port);
    }

    private void readPropertyAlias(Element pal) throws NamespaceException, InvalidWsdlException {
        this.nt.addNamespaces(pal);
        String propertyName = pal.getAttribute("propertyName");
        String messageType = pal.getAttribute("messageType");
        String messagePart = pal.getAttribute("part");
        String xsdType = pal.getAttribute("type");
        String xsdElement = pal.getAttribute("element");
        if (messageType != null) {
            if (messagePart == null) {
                throw new InvalidWsdlException("<propertyAlias> element with 'messageType' must also contain 'part' attribute");
            }
        } else if (xsdType == null && xsdElement == null) {
            throw new InvalidWsdlException("<propertyAlias> element must contain one of 'messageType'+'part', 'type' or 'element' attributes");
        }
        String query = null;
        ArrayList queries = Util.getAllElements(pal);
        int i = 0;
        while (i < queries.size()) {
            Element elem = (Element)queries.get(i);
            if (NamespaceTranslator.getName(elem).equals("query")) {
                query = Util.getTextDirectlyUnder(elem).trim();
                break;
            }
            ++i;
        }
        if (query == null) {
            query = "";
        }
        BPELPropertyAlias alias = new BPELPropertyAlias();
        alias.qpropertyName = this.nt.qualify(propertyName, false);
        if (messageType != null && messageType.length() != 0) {
            alias.qmessageType = this.nt.qualify(messageType, false);
            alias.messagePart = messagePart;
            this.log.logInfo(this.LOG_SOURCE, "BPEL property alias for " + this.compiler_util.getQNameFromQName(alias.qpropertyName) + " (" + this.compiler_util.getQNameFromQName(alias.qmessageType) + " -> " + alias.messagePart + ")");
        }
        if (xsdType != null && xsdType.length() != 0) {
            alias.qxsdType = this.nt.qualify(xsdType, false);
            this.log.logInfo(this.LOG_SOURCE, "BPEL property alias for " + this.compiler_util.getQNameFromQName(alias.qpropertyName) + " (" + this.compiler_util.getQNameFromQName(alias.qxsdType) + ")");
        }
        if (xsdElement != null && xsdElement.length() != 0) {
            alias.qxsdElement = this.nt.qualify(xsdElement, false);
            this.log.logInfo(this.LOG_SOURCE, "BPEL property alias for " + this.compiler_util.getQNameFromQName(alias.qpropertyName) + " (" + this.compiler_util.getQNameFromQName(alias.qxsdElement) + ")");
        }
        alias.query = query;
        this.bpel_propertyAliasList.add(alias);
        this.nt.removeNamespaces(pal);
    }

    private void readProperty(Element prop) throws NamespaceException, InvalidWsdlException {
        this.nt.addNamespaces(prop);
        String name = prop.getAttribute("name");
        String type = prop.getAttribute("type");
        BPELProperty varprop = new BPELProperty();
        varprop.qname = this.nt.qualify(name, true);
        varprop.qType = this.nt.qualify(type, false);
        this.log.logInfo(this.LOG_SOURCE, "BPEL variable property " + this.compiler_util.getQNameFromQName(varprop.qname));
        this.qname_to_bpel_property.put(varprop.qname, varprop);
        this.nt.removeNamespaces(prop);
    }

    private void readPartnerLinkType(Element plink) throws NamespaceException, InvalidWsdlException {
        this.nt.addNamespaces(plink);
        String name = plink.getAttribute("name");
        BPELPartnerLinkType plinkType = new BPELPartnerLinkType();
        plinkType.name = this.nt.qualify(name, true);
        this.log.logInfo(this.LOG_SOURCE, "BPEL partner link type " + this.compiler_util.getQNameFromQName(plinkType.name));
        this.qname_to_bpel_partnerLinkType.put(plinkType.name, plinkType);
        ArrayList roles = Util.getAllElements(plink);
        int i = 0;
        while (i < roles.size()) {
            Element role = (Element)roles.get(i);
            this.nt.addNamespaces(role);
            if (NamespaceTranslator.getName(role).equals("role")) {
                BPELPartnerLinkRole plinkRole = new BPELPartnerLinkRole();
                plinkRole.name = role.getAttribute("name");
                plinkRole.qportType = this.nt.qualify(role.getAttribute("portType"), false);
                this.log.logInfo(this.LOG_SOURCE, "  role " + plinkRole.name + " (" + this.compiler_util.getQNameFromQName(plinkRole.qportType) + ")");
                plinkType.addRole(plinkRole);
                if (Util.getFirstElement(role, "portType") != null) {
                    this.log.logWarning(this.LOG_SOURCE, "element <portType> under partner link type element <role> has been replaced with the attribute @portType on element <role>, the element <portType> will be ignored");
                }
            }
            this.nt.removeNamespaces(role);
            ++i;
        }
        this.nt.removeNamespaces(plink);
    }

    private void readMessages(Element definitions) throws NamespaceException, InvalidWsdlException {
        this.nt = this.compiler_util.createNamespaceTranslator();
        this.nt.addNamespaces(definitions);
        ArrayList elems = Util.getAllElements(definitions);
        int i = 0;
        while (i < elems.size()) {
            Element elem = (Element)elems.get(i);
            String tagname = NamespaceTranslator.getName(elem);
            if (tagname.equals("message")) {
                this.readMessage(elem);
            }
            ++i;
        }
        this.nt.removeNamespaces(definitions);
    }

    private void readPortTypes(Element definitions) throws NamespaceException, InvalidWsdlException {
        this.nt = this.compiler_util.createNamespaceTranslator();
        this.nt.addNamespaces(definitions);
        ArrayList elems = Util.getAllElements(definitions);
        int i = 0;
        while (i < elems.size()) {
            Element elem = (Element)elems.get(i);
            String tagname = NamespaceTranslator.getName(elem);
            if (tagname.equals("portType")) {
                this.readPortType(elem);
            }
            ++i;
        }
        this.nt.removeNamespaces(definitions);
    }

    private void readPartnerLinkTypes(Element definitions) throws NamespaceException, InvalidWsdlException {
        this.nt = this.compiler_util.createNamespaceTranslator();
        this.nt.addNamespaces(definitions);
        ArrayList elems = Util.getAllElements(definitions);
        int i = 0;
        while (i < elems.size()) {
            Element elem = (Element)elems.get(i);
            String tagname = NamespaceTranslator.getName(elem);
            if (tagname.equals("partnerLinkType")) {
                this.readPartnerLinkType(elem);
            }
            ++i;
        }
        this.nt.removeNamespaces(definitions);
    }

    private void readPropertyAliases(Element definitions) throws NamespaceException, InvalidWsdlException {
        this.nt = this.compiler_util.createNamespaceTranslator();
        this.nt.addNamespaces(definitions);
        ArrayList elems = Util.getAllElements(definitions);
        int i = 0;
        while (i < elems.size()) {
            Element elem = (Element)elems.get(i);
            String tagname = NamespaceTranslator.getName(elem);
            if (tagname.equals("propertyAlias")) {
                this.readPropertyAlias(elem);
            }
            ++i;
        }
        this.nt.removeNamespaces(definitions);
    }

    private void readProperties(Element definitions) throws NamespaceException, InvalidWsdlException {
        this.nt = this.compiler_util.createNamespaceTranslator();
        this.nt.addNamespaces(definitions);
        ArrayList elems = Util.getAllElements(definitions);
        int i = 0;
        while (i < elems.size()) {
            Element elem = (Element)elems.get(i);
            String tagname = NamespaceTranslator.getName(elem);
            if (tagname.equals("property")) {
                this.readProperty(elem);
            }
            ++i;
        }
        this.nt.removeNamespaces(definitions);
    }

    public WSDLMap(Util compiler_util, TranslatorLog log, String[] wsdlxml) throws Exception {
        Element definitions;
        this.log = log;
        this.compiler_util = compiler_util;
        Document[] docs = new Document[wsdlxml.length];
        this.nt = compiler_util.createNamespaceTranslator();
        int i = 0;
        while (i < wsdlxml.length) {
            Document doc;
            DocumentBuilder builder = XMLConfigUtil.getDocumentBuilder();
            docs[i] = doc = builder.parse(new ByteArrayInputStream(wsdlxml[i].getBytes()));
            ++i;
        }
        i = 0;
        while (i < docs.length) {
            definitions = docs[i].getDocumentElement();
            this.readMessages(definitions);
            ++i;
        }
        i = 0;
        while (i < docs.length) {
            definitions = docs[i].getDocumentElement();
            this.readPortTypes(definitions);
            ++i;
        }
        i = 0;
        while (i < docs.length) {
            definitions = docs[i].getDocumentElement();
            this.readPartnerLinkTypes(definitions);
            ++i;
        }
        i = 0;
        while (i < docs.length) {
            definitions = docs[i].getDocumentElement();
            this.readProperties(definitions);
            ++i;
        }
        i = 0;
        while (i < docs.length) {
            definitions = docs[i].getDocumentElement();
            this.readPropertyAliases(definitions);
            ++i;
        }
    }
}

