/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLOperation;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLPortType;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.InternalBindingTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.MessageCodec;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.XMLCodec;
import org.eclipse.stp.b2j.core.jengine.internal.utils.TranslatorUtils;
import org.eclipse.stp.b2j.core.jengine.internal.utils.UIDPool;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslatorException;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslator;
import org.w3c.dom.Element;

public class InternalMessageBindingTranslator
implements WSDLBindingTranslator,
InternalBindingTranslator {
    UIDPool uidpool = new UIDPool();
    public static final String NAMESPACE_ENGINEBINDING = "http://www.eclipse.org/stp/b2j/2006/02";
    HashMap conversations = new HashMap();
    int CONVERSATION_ID = 0;
    int PICK_ID = 0;
    MessageCodec codec_message;
    XMLCodec codec_xml;
    XSDTypeTranslator[] codecs;
    HashMap bindings = new HashMap();
    WSDLMap wsdlmap;
    XSDMap xsdmap;
    NamespaceTranslator engNT;
    ClassLoader dependancy_loader;
    TranslatorLog log;
    Util compiler_util;
    StringBuffer picksb;
    String pickConversationId;
    String pickTimeoutId;
    int index;
    ArrayList inputFields;

    public String getID() {
        return this.getClass().getName();
    }

    public String getHumanReadableName() {
        return "Internal Messaging Binding";
    }

    public void init(Util compiler_util, TranslatorLog log, XSDMap xsdmap, WSDLMap wsdlmap, ClassLoader dependancy_loader) {
        this.xsdmap = xsdmap;
        this.wsdlmap = wsdlmap;
        this.dependancy_loader = dependancy_loader;
        this.compiler_util = compiler_util;
        this.log = log;
        this.codec_message = new MessageCodec();
        this.codec_xml = new XMLCodec();
        this.codecs = new XSDTypeTranslator[]{this.codec_message, this.codec_xml};
    }

    private boolean isBindingOurs(NamespaceTranslator nt, Element elem) throws NamespaceException {
        if (this.engNT == null) {
            this.engNT = this.compiler_util.createNamespaceTranslator();
            this.engNT.addNamespace("xmlns:engine", NAMESPACE_ENGINEBINDING);
        }
        ArrayList elems = Util.getAllElements(elem);
        int i = 0;
        while (i < elems.size()) {
            Element engbinding = (Element)elems.get(i);
            nt.addNamespaces(engbinding);
            if (nt.checkQName(engbinding, NAMESPACE_ENGINEBINDING, "binding")) {
                return true;
            }
            nt.removeNamespaces(engbinding);
            ++i;
        }
        return false;
    }

    public void readWSDL(Element wsdl_definitions) throws NamespaceException, WSDLBindingTranslatorException {
        NamespaceTranslator nt = this.compiler_util.createNamespaceTranslator();
        nt.addNamespaces(wsdl_definitions);
        ArrayList elems = Util.getAllElements(wsdl_definitions);
        int i = 0;
        while (i < elems.size()) {
            Element elem = (Element)elems.get(i);
            nt.addNamespaces(elem);
            if (NamespaceTranslator.getName(elem).equals("binding")) {
                String ptype = elem.getAttribute("type");
                if (this.isBindingOurs(nt, elem)) {
                    Binding binding = new Binding();
                    binding.qname = nt.qualify(elem.getTagName(), true);
                    binding.qportType = nt.qualify(ptype, false);
                    binding.bindingName = nt.qualify(elem.getAttribute("name"), true);
                    this.bindings.put(binding.qportType, binding);
                    this.bindings.put(binding.qname, binding);
                    this.bindings.put(binding.bindingName, binding);
                }
            } else if (NamespaceTranslator.getName(elem).equals("service")) {
                ArrayList ports = Util.getAllElements(elem);
                int k = 0;
                while (k < ports.size()) {
                    Binding binding;
                    Element port = (Element)ports.get(k);
                    nt.addNamespaces(port);
                    if (NamespaceTranslator.getName(port).equals("port") && (binding = (Binding)this.bindings.get(nt.qualify(port.getAttribute("binding"), false))) != null) {
                        ArrayList addresses = Util.getAllElements(port);
                        int z = 0;
                        while (z < addresses.size()) {
                            Element address = (Element)addresses.get(z);
                            nt.addNamespaces(address);
                            if (nt.checkQName(address, NAMESPACE_ENGINEBINDING, "address")) {
                                binding.address_location = address.getAttribute("conversation");
                            }
                            nt.removeNamespaces(address);
                            ++z;
                        }
                    }
                    nt.removeNamespaces(port);
                    ++k;
                }
            }
            nt.removeNamespaces(elem);
            ++i;
        }
        nt.removeNamespaces(wsdl_definitions);
    }

    public XSDTypeTranslator[] getCodecs() {
        return this.codecs;
    }

    private void checkForBindingNamed(String name) throws WSDLBindingTranslatorException {
        if (name == null) {
            return;
        }
        Binding binding = (Binding)this.bindings.get(name);
        if (binding == null) {
            throw new WSDLBindingTranslatorException("no Engine Internal Message binding found named '" + this.compiler_util.getQNameFromQName(name) + "'");
        }
    }

    private void checkForBinding(String qportType) throws WSDLBindingTranslatorException {
        Binding binding = (Binding)this.bindings.get(qportType);
        if (binding == null) {
            throw new WSDLBindingTranslatorException("no Engine Internal Message binding found for port type " + this.compiler_util.getQNameFromQName(qportType));
        }
    }

    private String getConversationID(String qportType, String operation, boolean request) {
        String conversationKey = String.valueOf(qportType) + "." + operation;
        Integer cid = (Integer)this.conversations.get(String.valueOf(qportType) + "." + operation);
        if (cid == null) {
            cid = new Integer(this.CONVERSATION_ID++);
            this.conversations.put(conversationKey, cid);
        }
        if (request) {
            return "\"->:" + cid + "\"";
        }
        return "\"<-:" + cid + "\"";
    }

    public String translateInvocation(NamespaceTranslator nt, String qportType, String bindingName, String operation, String eprFieldName, String correlationSetFieldNameIn, String correlationSetFieldNameOut, String inputFieldName, String outputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        StringBuffer sb = new StringBuffer();
        this.checkForBindingNamed(bindingName);
        this.checkForBinding(qportType);
        WSDLPortType wsdlPortType = this.wsdlmap.getPortType(qportType);
        WSDLOperation wsdlOp = wsdlPortType.getOperation(operation);
        String conversationRequestID = this.getConversationID(qportType, operation, true);
        String conversationResponseID = this.getConversationID(qportType, operation, false);
        if (wsdlOp.getType() == 1) {
            if (outputFieldName.length() == 0) {
                throw new WSDLBindingTranslatorException("WSDL operation is of type Request-response but no output variable specified");
            }
            sb.append(outputFieldName).append(" = ");
            sb.append("engine.sendAndReceiveMessage(");
            sb.append(String.valueOf(conversationRequestID) + "+\"@\"+" + eprFieldName + ".getAddress()");
            sb.append(",");
            sb.append(inputFieldName);
            sb.append(",");
            sb.append(String.valueOf(conversationResponseID) + "+\"@\"+" + eprFieldName + ".getAddress()");
            sb.append(");\n");
        } else if (wsdlOp.getType() == 0) {
            sb.append("engine.sendMessage(");
            sb.append(String.valueOf(conversationRequestID) + "+\"@\"+" + eprFieldName + ".getAddress()");
            sb.append(",");
            sb.append(inputFieldName);
            sb.append(");\n");
        } else {
            throw new WSDLBindingTranslatorException("Unsupported WSDL operation type - only One-way and Request-response are supported (if this is supposed to be request-response, check ordering of <in> and <out>)");
        }
        return sb.toString();
    }

    public String translateReceive(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String inputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        StringBuffer sb = new StringBuffer();
        this.checkForBindingNamed(bindingName);
        this.checkForBinding(qportType);
        WSDLPortType wsdlPortType = this.wsdlmap.getPortType(qportType);
        wsdlPortType.getOperation(operation);
        String conversationRequestID = this.getConversationID(qportType, operation, true);
        sb.append(inputFieldName).append(" = ");
        sb.append("engine.receiveMessage(");
        sb.append(String.valueOf(conversationRequestID) + "+\"@\"+" + eprFieldName + ".getAddress()");
        sb.append(");\n");
        return sb.toString();
    }

    public String translateReply(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String outputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        StringBuffer sb = new StringBuffer();
        this.checkForBindingNamed(bindingName);
        this.checkForBinding(qportType);
        WSDLPortType wsdlPortType = this.wsdlmap.getPortType(qportType);
        wsdlPortType.getOperation(operation);
        String conversationResponseID = this.getConversationID(qportType, operation, false);
        sb.append("engine.sendMessage(");
        sb.append(String.valueOf(conversationResponseID) + "+\"@\"+" + eprFieldName + ".getAddress()");
        sb.append(",");
        sb.append(outputFieldName);
        sb.append(");\n");
        return sb.toString();
    }

    public String translateDefaultEPR(NamespaceTranslator nt, String qportType, String bindingName) throws NamespaceException, WSDLBindingTranslatorException {
        StringBuffer sb = new StringBuffer();
        this.checkForBindingNamed(bindingName);
        this.checkForBinding(qportType);
        Binding binding = (Binding)this.bindings.get(qportType);
        if (bindingName != null) {
            binding = (Binding)this.bindings.get(bindingName);
        }
        sb.append("new WSEndpointReference(\"" + TranslatorUtils.toJavaStringStrict(binding.address_location) + "\")");
        return sb.toString();
    }

    public void translatePickStart(int onMessageCount, int onAlarmCount, String pickTimeoutId) throws NamespaceException, WSDLBindingTranslatorException {
        this.picksb = new StringBuffer();
        this.index = 0;
        this.inputFields = new ArrayList();
        this.pickTimeoutId = pickTimeoutId;
        this.pickConversationId = "engine_internal_pick" + this.PICK_ID++;
        this.picksb.append("String[] " + this.pickConversationId + " = new String[" + onMessageCount + "];\n");
    }

    public void translatePickOnMessage(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String inputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        this.inputFields.add(inputFieldName);
        this.checkForBindingNamed(bindingName);
        this.checkForBinding(qportType);
        WSDLPortType wsdlPortType = this.wsdlmap.getPortType(qportType);
        wsdlPortType.getOperation(operation);
        String conversationRequestID = this.getConversationID(qportType, operation, true);
        this.picksb.append(String.valueOf(this.pickConversationId) + "[" + this.index + "] = " + conversationRequestID + "+\"@\"+" + eprFieldName + ".getAddress();\n");
        ++this.index;
    }

    public String translatePickFinish(String indexFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        String pickedMessage = "engine_internal_pick_message" + this.PICK_ID++;
        this.picksb.append("Message ");
        this.picksb.append(pickedMessage).append(" = ");
        this.picksb.append("engine.receiveMessage(");
        this.picksb.append(this.pickConversationId);
        this.picksb.append(",");
        this.picksb.append(this.pickTimeoutId);
        this.picksb.append(");\n");
        String pickedConversationId = "engine_internal_pick_conversation" + this.PICK_ID++;
        this.picksb.append("if (" + pickedMessage + " == null) {\n");
        this.picksb.append("  //timeout\n");
        this.picksb.append("  " + indexFieldName + " = -1;\n");
        this.picksb.append("} else {\n");
        this.picksb.append("  //received a message\n");
        this.picksb.append("String " + pickedConversationId + " = (String)" + pickedMessage + ".pop();\n");
        int i = 0;
        while (i < this.inputFields.size()) {
            if (i > 0) {
                this.picksb.append("} else ");
            }
            this.picksb.append("if (" + pickedConversationId + ".equals(" + this.pickConversationId + "[" + i + "])) {\n");
            this.picksb.append("  " + this.inputFields.get(i) + " = " + pickedMessage + ";\n");
            this.picksb.append("  " + indexFieldName + " = " + i + ";\n");
            if (i == this.inputFields.size() - 1) {
                this.picksb.append("}\n");
            }
            ++i;
        }
        this.picksb.append("}\n");
        return this.picksb.toString();
    }

    public String getDeclarations() {
        StringBuffer decl = new StringBuffer();
        return decl.toString();
    }

    public String[] getImports() {
        return new String[0];
    }

    class Binding {
        String qname;
        String qportType;
        String bindingName;
        String address_location = "~";

        Binding() {
        }
    }
}

