/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLOperation;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLPortType;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.eclipse.stp.b2j.core.jengine.internal.utils.TranslatorUtils;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslatorException;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslator;
import org.w3c.dom.Element;

public class SOAPBindingTranslator
implements WSDLBindingTranslator {
    private static final String LOG_SOURCE = "SOAP Binding";
    XSDTypeTranslator[] codecs = new XSDTypeTranslator[0];
    WSDLMap wsdlmap;
    XSDMap xsdmap;
    TranslatorLog log;
    Util compiler_util;
    ClassLoader dependancy_loader;
    int PICK_ID = 0;
    HashMap bindings = new HashMap();
    StringBuffer picksb;
    String pickEprsId;
    String pickTransportUrisId;
    String pickRpcTypesId;
    String pickOperationNamespacesId;
    String pickOperationsId;
    String pickSoapActionsId;
    String pickCorrelationSetsId;
    String pickMessageExchangesId;
    String pickTimeoutId;
    int index;
    ArrayList inputTypes;
    ArrayList inputFields;
    ArrayList wsdlOps;

    public String getID() {
        return this.getClass().getName();
    }

    public String getHumanReadableName() {
        return "Default SOAP Binding";
    }

    public void init(Util compiler_util, TranslatorLog log, XSDMap xsdmap, WSDLMap wsdlmap, ClassLoader dependancy_loader) {
        this.xsdmap = xsdmap;
        this.wsdlmap = wsdlmap;
        this.dependancy_loader = dependancy_loader;
        this.compiler_util = compiler_util;
        this.log = log;
    }

    private void checkForBindingNamed(String name) throws WSDLBindingTranslatorException {
        if (name == null) {
            return;
        }
        PortTypeBinding binding = (PortTypeBinding)this.bindings.get(name);
        if (binding == null) {
            throw new WSDLBindingTranslatorException("no SOAP binding found named '" + this.compiler_util.getQNameFromQName(name) + "'");
        }
    }

    private void checkForBinding(String qportType) throws WSDLBindingTranslatorException {
        PortTypeBinding binding = (PortTypeBinding)this.bindings.get(qportType);
        if (binding == null) {
            throw new WSDLBindingTranslatorException("no SOAP binding found for port type " + this.compiler_util.getQNameFromQName(qportType));
        }
    }

    public void readWSDL(Element wsdl_definitions) throws NamespaceException, WSDLBindingTranslatorException {
        NamespaceTranslator nt = this.compiler_util.createNamespaceTranslator();
        nt.addNamespaces(wsdl_definitions);
        ArrayList elems = Util.getAllElements(wsdl_definitions);
        int i = 0;
        while (i < elems.size()) {
            Element elem = (Element)elems.get(i);
            nt.addNamespaces(elem);
            if (NamespaceTranslator.getName(elem).equals("binding")) {
                String ptype = elem.getAttribute("type");
                PortTypeBinding binding = new PortTypeBinding();
                binding.bindingName = nt.qualify(elem.getAttribute("name"), true);
                binding.qname = nt.qualify(elem.getAttribute("name"), true);
                binding.qportType = nt.qualify(ptype, false);
                ArrayList subelems = Util.getAllElements(elem);
                int k = 0;
                while (k < subelems.size()) {
                    Element bindingelem = (Element)subelems.get(k);
                    nt.addNamespaces(bindingelem);
                    if (nt.checkQName(bindingelem, "http://schemas.xmlsoap.org/wsdl/soap/", "binding")) {
                        binding.style = bindingelem.getAttribute("style");
                        binding.transport = bindingelem.getAttribute("transport");
                        this.bindings.put(binding.qportType, binding);
                        this.bindings.put(binding.qname, binding);
                        this.bindings.put(binding.bindingName, binding);
                        this.log.logInfo(LOG_SOURCE, "Found SOAP Binding named " + binding.bindingName);
                    }
                    if (NamespaceTranslator.getName(bindingelem).equals("operation")) {
                        ArrayList opelems = Util.getAllElements(bindingelem);
                        OperationBinding opbinding = new OperationBinding();
                        opbinding.opname = bindingelem.getAttribute("name");
                        int j = 0;
                        while (j < opelems.size()) {
                            int m;
                            Element opelem = (Element)opelems.get(j);
                            nt.addNamespaces(opelem);
                            if (nt.checkQName(opelem, "http://schemas.xmlsoap.org/wsdl/soap/", "operation")) {
                                opbinding.soapAction = opelem.getAttribute("soapAction");
                                opbinding.encodingStyle = opelem.getAttribute("style");
                                if (opbinding.encodingStyle.length() > 0) {
                                    if (binding.style.length() == 0) {
                                        binding.style = opbinding.encodingStyle;
                                    } else if (!binding.style.equalsIgnoreCase(opbinding.encodingStyle)) {
                                        throw new WSDLBindingTranslatorException("Binding " + this.compiler_util.getQNameFromQName(binding.qname) + " has elements which specify more than one type of encoding style - this is currently unsupported");
                                    }
                                }
                                binding.opbindings.put(opbinding.opname, opbinding);
                            }
                            if (NamespaceTranslator.getName(opelem).equals("input")) {
                                ArrayList inputelems = Util.getAllElements(opelem);
                                m = 0;
                                while (m < inputelems.size()) {
                                    Element inputelem = (Element)inputelems.get(m);
                                    nt.addNamespaces(inputelem);
                                    if (nt.checkQName(inputelem, "http://schemas.xmlsoap.org/wsdl/soap/", "body")) {
                                        InputBinding inbinding = new InputBinding();
                                        inbinding.namespace = inputelem.getAttribute("namespace");
                                        inbinding.use = inputelem.getAttribute("use");
                                        inbinding.encodingStyle = inputelem.getAttribute("encodingStyle");
                                        opbinding.input = inbinding;
                                    }
                                    nt.removeNamespaces(inputelem);
                                    ++m;
                                }
                            } else if (NamespaceTranslator.getName(opelem).equals("output")) {
                                ArrayList outputelems = Util.getAllElements(opelem);
                                m = 0;
                                while (m < outputelems.size()) {
                                    Element outputelem = (Element)outputelems.get(m);
                                    nt.addNamespaces(outputelem);
                                    if (nt.checkQName(outputelem, "http://schemas.xmlsoap.org/wsdl/soap/", "body")) {
                                        OutputBinding outbinding = new OutputBinding();
                                        outbinding.namespace = outputelem.getAttribute("namespace");
                                        outbinding.use = outputelem.getAttribute("use");
                                        outbinding.encodingStyle = outputelem.getAttribute("encodingStyle");
                                        opbinding.output = outbinding;
                                    }
                                    nt.removeNamespaces(outputelem);
                                    ++m;
                                }
                            }
                            nt.removeNamespaces(opelem);
                            ++j;
                        }
                    }
                    nt.removeNamespaces(bindingelem);
                    ++k;
                }
            } else if (NamespaceTranslator.getName(elem).equals("service")) {
                elem.getAttribute("name");
                ArrayList subelems = Util.getAllElements(elem);
                int k = 0;
                while (k < subelems.size()) {
                    String qbindingName;
                    PortTypeBinding ptbinding;
                    Element serviceelem = (Element)subelems.get(k);
                    nt.addNamespaces(serviceelem);
                    if (NamespaceTranslator.getName(serviceelem).equals("port") && (ptbinding = (PortTypeBinding)this.bindings.get(qbindingName = nt.qualify(serviceelem.getAttribute("binding"), false))) != null) {
                        ArrayList addresselems = Util.getAllElements(serviceelem);
                        int j = 0;
                        while (j < addresselems.size()) {
                            Element addresselem = (Element)addresselems.get(j);
                            nt.addNamespaces(addresselem);
                            if (nt.checkQName(addresselem, "http://schemas.xmlsoap.org/wsdl/soap/", "address")) {
                                ptbinding.address_location = addresselem.getAttribute("location");
                            }
                            nt.removeNamespaces(addresselem);
                            ++j;
                        }
                    }
                    nt.removeNamespaces(serviceelem);
                    ++k;
                }
            }
            nt.removeNamespaces(elem);
            ++i;
        }
        nt.removeNamespaces(wsdl_definitions);
    }

    public XSDTypeTranslator[] getCodecs() {
        return this.codecs;
    }

    public String translateInvocation(NamespaceTranslator nt, String qportType, String bindingName, String operation, String eprFieldName, String correlationSetFieldNameIn, String correlationSetFieldNameOut, String inputFieldName, String outputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        StringBuffer sb = new StringBuffer();
        this.checkForBindingNamed(bindingName);
        this.checkForBinding(qportType);
        WSDLPortType wsdlPortType = this.wsdlmap.getPortType(qportType);
        WSDLOperation wsdlOp = wsdlPortType.getOperation(operation);
        PortTypeBinding binding = (PortTypeBinding)this.bindings.get(qportType);
        OperationBinding opbinding = (OperationBinding)binding.opbindings.get(operation);
        if (opbinding == null) {
            throw new WSDLBindingTranslatorException("No SOAP binding found for operation " + operation + " in port type " + this.compiler_util.getQNameFromQName(qportType));
        }
        String btype = null;
        if (binding.style.equalsIgnoreCase("rpc")) {
            btype = "RPC";
        } else if (binding.style.equalsIgnoreCase("document")) {
            btype = "Document";
        } else if (binding.style.equals("")) {
            btype = "Document";
        } else {
            throw new WSDLBindingTranslatorException("Unsupported SOAP binding style - only RPC or Document style bindings are supported");
        }
        boolean rpc_style = btype.equalsIgnoreCase("RPC");
        String soapAction = opbinding.soapAction;
        if (soapAction == null) {
            soapAction = "";
        }
        if (wsdlOp.getType() == 1) {
            if (opbinding.input == null) {
                throw new WSDLBindingTranslatorException("No SOAP binding found for operation " + operation + " input element in port type " + this.compiler_util.getQNameFromQName(qportType));
            }
            if (opbinding.output == null) {
                throw new WSDLBindingTranslatorException("No SOAP binding found for operation " + operation + " output element in port type " + this.compiler_util.getQNameFromQName(qportType));
            }
            String inputType = wsdlOp.getMessageType("input");
            String outputType = wsdlOp.getMessageType("output");
            sb.append(String.valueOf(outputFieldName) + " = (" + outputType + ")" + outputType + ".fromXMLNoRootTags(SOAPClient.invokeRequestResponse(" + eprFieldName + "," + correlationSetFieldNameOut + ",null," + rpc_style + ",\"" + TranslatorUtils.toJavaStringStrict(opbinding.input.namespace) + "\",\"" + operation + "\",\"" + TranslatorUtils.toJavaStringStrict(soapAction) + "\"," + inputType + ".toXMLNoRootTags(" + inputFieldName + ",true)));");
        } else if (wsdlOp.getType() == 0) {
            if (opbinding.input == null) {
                throw new WSDLBindingTranslatorException("No SOAP binding found for operation " + operation + " input element in port type " + this.compiler_util.getQNameFromQName(qportType));
            }
            String inputType = wsdlOp.getMessageType("input");
            sb.append("SOAPClient.invokeOneWay(" + eprFieldName + "," + correlationSetFieldNameOut + ",null," + rpc_style + ",\"" + TranslatorUtils.toJavaStringStrict(opbinding.input.namespace) + "\",\"" + operation + "\",\"" + TranslatorUtils.toJavaStringStrict(soapAction) + "\"," + inputType + ".toXMLNoRootTags(" + inputFieldName + ",true));");
        } else {
            throw new WSDLBindingTranslatorException("Unsupported WSDL operation type - only One-way and Request-response are supported (if this is supposed to be request-response, check ordering of <in> and <out>)");
        }
        return sb.toString();
    }

    public String translateReceive(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String inputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        StringBuffer sb = new StringBuffer();
        this.checkForBindingNamed(bindingName);
        this.checkForBinding(qportType);
        WSDLPortType wsdlPortType = this.wsdlmap.getPortType(qportType);
        WSDLOperation wsdlOp = wsdlPortType.getOperation(operation);
        PortTypeBinding binding = (PortTypeBinding)this.bindings.get(qportType);
        OperationBinding opbinding = (OperationBinding)binding.opbindings.get(operation);
        if (opbinding == null) {
            throw new WSDLBindingTranslatorException("No SOAP binding found for operation " + operation + " in port type " + this.compiler_util.getQNameFromQName(qportType));
        }
        String btype = null;
        if (binding.style.equalsIgnoreCase("rpc")) {
            btype = "RPC";
        } else if (binding.style.equalsIgnoreCase("document")) {
            btype = "Document";
        } else if (binding.style.equals("")) {
            btype = "Document";
        } else {
            throw new WSDLBindingTranslatorException("Unsupported SOAP binding style - only RPC or Document style bindings are supported");
        }
        boolean rpc_style = btype.equalsIgnoreCase("RPC");
        String soapAction = opbinding.soapAction;
        if (soapAction == null) {
            soapAction = "";
        }
        String inputType = wsdlOp.getMessageType("input");
        wsdlOp.getMessageType("output");
        sb.append(String.valueOf(inputFieldName) + " = (" + inputType + ")" + inputType + ".fromXMLNoRootTags(SOAPServer.receive(" + eprFieldName + ",new BPELCorrelatable(" + correlationSetFieldName + "),\"" + messageExchange + "\",null," + rpc_style + ",\"" + TranslatorUtils.toJavaStringStrict(opbinding.input.namespace) + "\",\"" + operation + "\",\"" + TranslatorUtils.toJavaStringStrict(soapAction) + "\"));");
        if (wsdlOp.getType() == 0) {
            sb.append("SOAPServer.reply(" + eprFieldName + ",\"" + messageExchange + "\",null," + rpc_style + ",\"" + TranslatorUtils.toJavaStringStrict(opbinding.input.namespace) + "\",\"" + operation + "\",\"" + TranslatorUtils.toJavaStringStrict(soapAction) + "\",null);\n");
        }
        return sb.toString();
    }

    public String translateReply(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String outputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        StringBuffer sb = new StringBuffer();
        this.checkForBindingNamed(bindingName);
        this.checkForBinding(qportType);
        WSDLPortType wsdlPortType = this.wsdlmap.getPortType(qportType);
        WSDLOperation wsdlOp = wsdlPortType.getOperation(operation);
        PortTypeBinding binding = (PortTypeBinding)this.bindings.get(qportType);
        OperationBinding opbinding = (OperationBinding)binding.opbindings.get(operation);
        if (opbinding == null) {
            throw new WSDLBindingTranslatorException("No SOAP binding found for operaion " + operation + " in port type " + this.compiler_util.getQNameFromQName(qportType));
        }
        String btype = null;
        if (binding.style.equalsIgnoreCase("rpc")) {
            btype = "RPC";
        } else if (binding.style.equalsIgnoreCase("document")) {
            btype = "Document";
        } else if (binding.style.equals("")) {
            btype = "Document";
        } else {
            throw new WSDLBindingTranslatorException("Unsupported SOAP binding style - only RPC or Document style bindings are supported");
        }
        boolean rpc_style = btype.equalsIgnoreCase("RPC");
        String soapAction = opbinding.soapAction;
        if (soapAction == null) {
            soapAction = "";
        }
        wsdlOp.getMessageType("input");
        String outputType = wsdlOp.getMessageType("output");
        sb.append("SOAPServer.reply(" + eprFieldName + ",\"" + messageExchange + "\",null," + rpc_style + ",\"" + TranslatorUtils.toJavaStringStrict(opbinding.output.namespace) + "\",\"" + operation + "\",\"" + TranslatorUtils.toJavaStringStrict(soapAction) + "\"," + outputType + ".toXMLNoRootTags(" + outputFieldName + ",true));");
        return sb.toString();
    }

    public String translateDefaultEPR(NamespaceTranslator nt, String qportType, String bindingName) throws NamespaceException, WSDLBindingTranslatorException {
        StringBuffer sb = new StringBuffer();
        this.checkForBindingNamed(bindingName);
        this.checkForBinding(qportType);
        PortTypeBinding ptbinding = (PortTypeBinding)this.bindings.get(qportType);
        if (bindingName != null) {
            ptbinding = (PortTypeBinding)this.bindings.get(bindingName);
        }
        sb.append("new WSEndpointReference(\"" + TranslatorUtils.toJavaStringStrict(ptbinding.address_location) + "\")");
        return sb.toString();
    }

    public void translatePickStart(int onMessageCount, int onAlarmCount, String timeoutFieldLongMS) throws NamespaceException, WSDLBindingTranslatorException {
        this.picksb = new StringBuffer();
        this.index = 0;
        this.inputTypes = new ArrayList();
        this.inputFields = new ArrayList();
        this.wsdlOps = new ArrayList();
        this.pickTimeoutId = timeoutFieldLongMS;
        this.pickEprsId = "engine_soapbinding_pick_epr" + this.PICK_ID;
        this.pickTransportUrisId = "engine_soapbinding_pick_transpuri" + this.PICK_ID;
        this.pickRpcTypesId = "engine_soapbinding_pick_rpctype" + this.PICK_ID;
        this.pickOperationNamespacesId = "engine_soapbinding_pick_opns" + this.PICK_ID;
        this.pickOperationsId = "engine_soapbinding_pick_op" + this.PICK_ID;
        this.pickSoapActionsId = "engine_soapbinding_pick_soapaction" + this.PICK_ID;
        this.pickCorrelationSetsId = "engine_soapbinding_pick_correlation" + this.PICK_ID;
        this.pickMessageExchangesId = "engine_soapbinding_pick_msgexchnge" + this.PICK_ID;
        ++this.PICK_ID;
        this.picksb.append("WSEndpointReference[] " + this.pickEprsId + " = new WSEndpointReference[" + onMessageCount + "];\n");
        this.picksb.append("String[] " + this.pickTransportUrisId + " = new String[" + onMessageCount + "];\n");
        this.picksb.append("boolean[] " + this.pickRpcTypesId + " = new boolean[" + onMessageCount + "];\n");
        this.picksb.append("String[] " + this.pickOperationNamespacesId + " = new String[" + onMessageCount + "];\n");
        this.picksb.append("String[] " + this.pickOperationsId + " = new String[" + onMessageCount + "];\n");
        this.picksb.append("String[] " + this.pickSoapActionsId + " = new String[" + onMessageCount + "];\n");
        this.picksb.append("Correlatable[] " + this.pickCorrelationSetsId + " = new Correlatable[" + onMessageCount + "];\n");
        this.picksb.append("String[] " + this.pickMessageExchangesId + " = new String[" + onMessageCount + "];\n");
    }

    public void translatePickOnMessage(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String inputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        this.checkForBindingNamed(bindingName);
        this.checkForBinding(qportType);
        WSDLPortType wsdlPortType = this.wsdlmap.getPortType(qportType);
        WSDLOperation wsdlOp = wsdlPortType.getOperation(operation);
        PortTypeBinding binding = (PortTypeBinding)this.bindings.get(qportType);
        OperationBinding opbinding = (OperationBinding)binding.opbindings.get(operation);
        if (opbinding == null) {
            throw new WSDLBindingTranslatorException("No SOAP binding found for operation " + operation + " in port type " + this.compiler_util.getQNameFromQName(qportType));
        }
        String btype = null;
        if (binding.style.equalsIgnoreCase("rpc")) {
            btype = "RPC";
        } else if (binding.style.equalsIgnoreCase("document")) {
            btype = "Document";
        } else if (binding.style.equals("")) {
            btype = "Document";
        } else {
            throw new WSDLBindingTranslatorException("Unsupported SOAP binding style - only RPC or Document style bindings are supported");
        }
        boolean rpc_style = btype.equalsIgnoreCase("RPC");
        String soapAction = opbinding.soapAction;
        if (soapAction == null) {
            soapAction = "";
        }
        String inputType = wsdlOp.getMessageType("input");
        wsdlOp.getMessageType("output");
        this.inputTypes.add(inputType);
        this.inputFields.add(inputFieldName);
        this.wsdlOps.add(wsdlOp);
        String operationNamespaceID = "\"" + TranslatorUtils.toJavaStringStrict(opbinding.input.namespace) + "\"";
        String operationID = "\"" + operation + "\"";
        String soapActionID = "\"" + TranslatorUtils.toJavaStringStrict(soapAction) + "\"";
        this.picksb.append(String.valueOf(this.pickEprsId) + "[" + this.index + "] = " + eprFieldName + ";\n");
        this.picksb.append(String.valueOf(this.pickTransportUrisId) + "[" + this.index + "] = null;\n");
        this.picksb.append(String.valueOf(this.pickRpcTypesId) + "[" + this.index + "] = " + rpc_style + ";\n");
        this.picksb.append(String.valueOf(this.pickOperationNamespacesId) + "[" + this.index + "] = " + operationNamespaceID + ";\n");
        this.picksb.append(String.valueOf(this.pickOperationsId) + "[" + this.index + "] = " + operationID + ";\n");
        this.picksb.append(String.valueOf(this.pickSoapActionsId) + "[" + this.index + "] = " + soapActionID + ";\n");
        this.picksb.append(String.valueOf(this.pickCorrelationSetsId) + "[" + this.index + "] = new BPELCorrelatable(" + correlationSetFieldName + ");\n");
        this.picksb.append(String.valueOf(this.pickMessageExchangesId) + "[" + this.index + "] = \"" + messageExchange + "\";\n");
        ++this.index;
    }

    public String translatePickFinish(String indexFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        String pickedMessage = "engine_soapbinding_pick_message" + this.PICK_ID++;
        this.picksb.append("String[] " + pickedMessage + " = SOAPServer.pick(" + this.pickEprsId + "," + this.pickCorrelationSetsId + "," + this.pickMessageExchangesId + "," + this.pickTransportUrisId + "," + this.pickRpcTypesId + "," + this.pickOperationNamespacesId + "," + this.pickOperationsId + "," + this.pickSoapActionsId + "," + this.pickTimeoutId + ");\n");
        String pickedOperationNamespaceId = "engine_soapbinding_picked_opns" + this.PICK_ID++;
        String pickedOperationId = "engine_soapbinding_picked_op" + this.PICK_ID++;
        String pickedSoapActionId = "engine_soapbinding_picked_soapaction" + this.PICK_ID++;
        this.picksb.append("if (" + pickedMessage + " == null) {\n");
        this.picksb.append("  //timeout\n");
        this.picksb.append("  " + indexFieldName + " = -1;\n");
        this.picksb.append("} else {\n");
        this.picksb.append("  //received a message\n");
        this.picksb.append("String " + pickedOperationNamespaceId + " = " + pickedMessage + "[0];\n");
        this.picksb.append("String " + pickedOperationId + " = " + pickedMessage + "[1];\n");
        this.picksb.append("String " + pickedSoapActionId + " = " + pickedMessage + "[2];\n");
        int i = 0;
        while (i < this.inputFields.size()) {
            if (i > 0) {
                this.picksb.append("} else ");
            }
            this.picksb.append("if (");
            this.picksb.append(pickedOperationNamespaceId + " == " + this.pickOperationNamespacesId + "[" + i + "]");
            this.picksb.append("&& " + pickedOperationId + " == " + this.pickOperationsId + "[" + i + "]");
            this.picksb.append("&& " + pickedSoapActionId + " == " + this.pickSoapActionsId + "[" + i + "]");
            this.picksb.append(") {\n");
            WSDLOperation wsdlOp = (WSDLOperation)this.wsdlOps.get(i);
            if (wsdlOp.getType() == 0) {
                this.picksb.append("SOAPServer.reply(" + this.pickEprsId + "[" + i + "]," + this.pickMessageExchangesId + "[" + i + "]," + this.pickTransportUrisId + "[" + i + "]," + this.pickRpcTypesId + "[" + i + "]," + this.pickOperationNamespacesId + "[" + i + "]," + this.pickOperationsId + "[" + i + "]," + this.pickSoapActionsId + "[" + i + "],null);\n");
            }
            String inputType = (String)this.inputTypes.get(i);
            String inputFieldName = (String)this.inputFields.get(i);
            this.picksb.append("  " + inputFieldName + " = (" + inputType + ")" + inputType + ".fromXMLNoRootTags(" + pickedMessage + "[3]);\n");
            this.picksb.append("  " + indexFieldName + " = " + i + ";\n");
            if (i == this.inputFields.size() - 1) {
                this.picksb.append("}\n");
            }
            ++i;
        }
        this.picksb.append("}\n");
        return this.picksb.toString();
    }

    public String getDeclarations() {
        return "";
    }

    public String[] getImports() {
        return new String[]{String.valueOf(this.getClass().getPackage().getName()) + ".*"};
    }

    class PortTypeBinding {
        String qname;
        String qportType;
        String style;
        String transport;
        String address_location;
        String bindingName;
        HashMap opbindings = new HashMap();

        PortTypeBinding() {
        }
    }

    class OperationBinding {
        String soapAction;
        String opname;
        InputBinding input;
        OutputBinding output;
        String encodingStyle;

        OperationBinding() {
        }
    }

    class InputBinding {
        String namespace;
        String use;
        String encodingStyle;

        InputBinding() {
        }
    }

    class OutputBinding {
        String namespace;
        String use;
        String encodingStyle;

        OutputBinding() {
        }
    }
}

