/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap;

import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELCorrelationSet;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPClientTransport;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPServerTransportListener;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.SOAPClientTransportHTTP;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.SOAPServerTransportHTTP;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SoapDaemon;

public class SOAPFactory {
    public static final boolean DEBUG = false;
    static HashMap soapClients = new HashMap();
    static Object soapClients_LOCK = new Object();

    public static void addServerTransportListenerForEPR(WSEndpointReference epr, String transportURI, boolean rpc_type, SOAPServerTransportListener listener) throws Exception {
        if (transportURI == null) {
            String addr = epr.getAddress();
            String lc_addr = addr.toLowerCase();
            if (lc_addr.startsWith("http")) {
                transportURI = "http://schemas.xmlsoap.org/soap/http";
            } else {
                throw new Exception("Could not detect valid SOAP transport for endpoint reference");
            }
        }
        if (!transportURI.equalsIgnoreCase("http://schemas.xmlsoap.org/soap/http")) {
            throw new Exception("Could not detect valid SOAP transport for URI \"" + transportURI + "\"");
        }
        new SOAPServerTransportHTTP(epr, rpc_type, listener);
    }

    public static SOAPClientTransport getClientTransportForEPR(WSEndpointReference epr, BPELCorrelationSet cset, String transportURI) throws Exception {
        String addr;
        if (transportURI == null) {
            addr = epr.getAddress();
            String lc_addr = addr.toLowerCase();
            if (lc_addr.startsWith("http")) {
                transportURI = "http://schemas.xmlsoap.org/soap/http";
            } else {
                throw new Exception("Could not detect valid SOAP transport for endpoint reference");
            }
        }
        if (transportURI.equalsIgnoreCase("http://schemas.xmlsoap.org/soap/http")) {
            addr = epr.getAddress().toLowerCase();
            String proxy_host = null;
            int proxy_port = 8080;
            if (addr.startsWith("https")) {
                if (SoapDaemon.SOAP_HTTPS_PROXY_ON) {
                    proxy_host = SoapDaemon.SOAP_HTTPS_PROXY_HOST;
                    proxy_port = SoapDaemon.SOAP_HTTPS_PROXY_PORT;
                }
            } else if (SoapDaemon.SOAP_HTTP_PROXY_ON) {
                proxy_host = SoapDaemon.SOAP_HTTP_PROXY_HOST;
                proxy_port = SoapDaemon.SOAP_HTTP_PROXY_PORT;
            }
            return new SOAPClientTransportHTTP(epr.getAddress(), cset, proxy_host, proxy_port, SoapDaemon.SOAP_PROXY_EXCLUDED_HOSTS);
        }
        throw new Exception("Could not detect valid SOAP transport for URI \"" + transportURI + "\"");
    }
}

