/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.CookieCache;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPClient;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.QueuedBlockingMap;

public class HTTPClientPool {
    private static int MAX_CONCURRENT_CONNECTIONS = 15000;
    private static int MAX_POOL_WAIT = 0;
    private static QueuedBlockingMap clients = new QueuedBlockingMap();
    private static HashMap available_clients = new HashMap();

    private static String getKey(URL url, String correlation) throws IOException {
        if (correlation == null) {
            correlation = "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CRLN:");
        sb.append(correlation);
        sb.append("URL:");
        sb.append(url.getProtocol());
        sb.append("://");
        sb.append(url.getHost());
        sb.append(":");
        int port = url.getPort();
        if (port == -1) {
            try {
                port = url.getDefaultPort();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                port = url.getProtocol().equalsIgnoreCase("http") ? 80 : (url.getProtocol().equalsIgnoreCase("https") ? 443 : 80);
            }
        }
        sb.append(port);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HTTPClient getConnectionFromPool(String key, URL address) throws IOException {
        try {
            HTTPClient client = (HTTPClient)clients.get(key, 1L);
            client.setResource(address);
            return client;
        }
        catch (InterruptedException interruptedException) {
            HashMap client = available_clients;
            synchronized (client) {
                Integer total = (Integer)available_clients.get(key);
                if (total == null) {
                    total = new Integer(0);
                }
                if (total < MAX_CONCURRENT_CONNECTIONS) {
                    HTTPClient client2 = new HTTPClient(address);
                    total = new Integer(total + 1);
                    available_clients.put(key, total);
                    return client2;
                }
            }
            long timeout = MAX_POOL_WAIT;
            if (timeout <= 0L) {
                timeout = 0L;
            }
            try {
                return (HTTPClient)clients.get(key, timeout);
            }
            catch (InterruptedException x) {
                throw new IOException("Timed out waiting for a client from the pool (" + timeout + "ms) - " + x);
            }
        }
    }

    private static void returnConnectionToPool(String key, HTTPClient client) {
        try {
            clients.put(key, client);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static byte[] doGet(URL address, String[][] headers) throws IOException {
        return HTTPClientPool.doGet(address, headers, null, -1, null);
    }

    public static byte[] doGet(URL address, String[][] headers, CookieCache cookies) throws IOException {
        return HTTPClientPool.doGet(address, headers, null, -1, null, cookies);
    }

    public static byte[] doGet(URL address, String[][] headers, String correlationKey) throws IOException {
        return HTTPClientPool.doGet(address, headers, null, -1, correlationKey, null);
    }

    public static byte[] doGet(URL address, String[][] headers, String proxy_host, int proxy_port) throws IOException {
        return HTTPClientPool.doGet(address, headers, proxy_host, proxy_port, null);
    }

    public static byte[] doGet(URL address, String[][] headers, String proxy_host, int proxy_port, CookieCache cookies) throws IOException {
        return HTTPClientPool.doGet(address, headers, proxy_host, proxy_port, null, cookies);
    }

    public static byte[] doGet(URL address, String[][] headers, String proxy_host, int proxy_port, String correlationKey, CookieCache cookies) throws IOException {
        String key = HTTPClientPool.getKey(address, correlationKey);
        HTTPClient client = HTTPClientPool.getConnectionFromPool(key, address);
        byte[] ret = null;
        Throwable err = null;
        try {
            client.setProxy(proxy_host, proxy_port);
            ret = client.doGet(headers, cookies);
        }
        catch (Throwable t) {
            err = t;
        }
        HTTPClientPool.returnConnectionToPool(key, client);
        if (err != null) {
            if (err instanceof IOException) {
                throw (IOException)err;
            }
            throw new IOException("" + err);
        }
        return ret;
    }

    public static byte[] doPost(URL address, byte[] dat, String mimetype, String[][] headers) throws IOException {
        return HTTPClientPool.doPost(address, dat, mimetype, headers, null, -1, null);
    }

    public static byte[] doPost(URL address, byte[] dat, String mimetype, String[][] headers, CookieCache cookies) throws IOException {
        return HTTPClientPool.doPost(address, dat, mimetype, headers, null, -1, null, cookies);
    }

    public static byte[] doPost(URL address, byte[] dat, String mimetype, String[][] headers, String correlationKey) throws IOException {
        return HTTPClientPool.doPost(address, dat, mimetype, headers, null, -1, correlationKey, null);
    }

    public static byte[] doPost(URL address, byte[] dat, String mimetype, String[][] headers, String proxy_host, int proxy_port) throws IOException {
        return HTTPClientPool.doPost(address, dat, mimetype, headers, proxy_host, proxy_port, null, null);
    }

    public static byte[] doPost(URL address, byte[] dat, String mimetype, String[][] headers, String proxy_host, int proxy_port, CookieCache cookies) throws IOException {
        return HTTPClientPool.doPost(address, dat, mimetype, headers, proxy_host, proxy_port, null, cookies);
    }

    public static byte[] doPost(URL address, byte[] dat, String mimetype, String[][] headers, String proxy_host, int proxy_port, String correlationKey, CookieCache cookies) throws IOException {
        String key = HTTPClientPool.getKey(address, correlationKey);
        HTTPClient client = HTTPClientPool.getConnectionFromPool(key, address);
        byte[] ret = null;
        Throwable err = null;
        try {
            client.setProxy(proxy_host, proxy_port);
            ret = client.doPost(dat, mimetype, headers, cookies);
        }
        catch (Throwable t) {
            err = t;
        }
        HTTPClientPool.returnConnectionToPool(key, client);
        if (err != null) {
            if (err instanceof IOException) {
                throw (IOException)err;
            }
            throw new IOException("" + err);
        }
        return ret;
    }
}

