/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELCorrelationSet;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPClientTransport;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPClientPool;
import org.eclipse.stp.b2j.core.jengine.internal.utils.UIDPool;

public class SOAPClientTransportHTTP
implements SOAPClientTransport {
    UIDPool instances = new UIDPool();
    static final long TIMEOUT = 30000L;
    URL address;
    boolean rpc_type = false;
    String[][] headers = new String[][]{{"SOAPAction", ""}};
    BPELCorrelationSet cset;
    String correlationKey;
    String proxy_host = null;
    int proxy_port = -1;

    public SOAPClientTransportHTTP(String address, BPELCorrelationSet cset, String proxy_host, int proxy_port, String[] excluded_hosts) throws MalformedURLException {
        this.address = new URL(address);
        this.cset = cset;
        this.proxy_host = proxy_host;
        this.proxy_port = proxy_port;
        String lchost = this.address.getHost().toLowerCase();
        int i = 0;
        while (i < excluded_hosts.length) {
            String lcexc = excluded_hosts[i].toLowerCase();
            int lclen = lcexc.length();
            if (lclen > 0) {
                if (lchost.equals(lcexc)) {
                    this.proxy_host = null;
                    this.proxy_port = -1;
                } else if (lcexc.charAt(0) == '*') {
                    if (lcexc.charAt(lclen - 1) == '*') {
                        if (lchost.indexOf(lcexc.substring(1, lclen - 1)) != -1) {
                            this.proxy_host = null;
                            this.proxy_port = -1;
                        }
                    } else if (lchost.endsWith(lcexc.substring(1))) {
                        this.proxy_host = null;
                        this.proxy_port = -1;
                    }
                } else if (lcexc.charAt(lclen - 1) == '*' && lchost.startsWith(lcexc.substring(0, lclen - 1))) {
                    this.proxy_host = null;
                    this.proxy_port = -1;
                }
            }
            ++i;
        }
        this.correlationKey = cset != null ? cset.toString() : null;
    }

    public void send(String xml, String soapAction) throws Exception {
        this.headers[0][1] = soapAction;
        if (this.proxy_host == null) {
            HTTPClientPool.doPost(this.address, xml.getBytes("UTF-8"), "text/xml", this.headers, this.correlationKey);
        } else {
            HTTPClientPool.doPost(this.address, xml.getBytes("UTF-8"), "text/xml", this.headers, this.proxy_host, this.proxy_port, this.correlationKey, null);
        }
    }

    public String sendAndReceive(String xml, String soapAction) throws Exception {
        this.headers[0][1] = soapAction;
        if (this.proxy_host == null) {
            return new String(HTTPClientPool.doPost(this.address, xml.getBytes("UTF-8"), "text/xml", this.headers, this.correlationKey), "UTF-8");
        }
        return new String(HTTPClientPool.doPost(this.address, xml.getBytes("UTF-8"), "text/xml", this.headers, this.proxy_host, this.proxy_port, this.correlationKey, null), "UTF-8");
    }

    public void close() {
    }
}

