/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPNotFoundException;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPServerTransportListener;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPUtils;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPException;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPNotFoundException;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPServer;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPServerListener;
import org.eclipse.stp.b2j.core.misc.internal.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPServerTransportHTTP
implements HTTPServerListener {
    SOAPServerTransportListener listener;
    boolean rpc_type = false;

    public SOAPServerTransportHTTP(WSEndpointReference epr, boolean rpc_type, SOAPServerTransportListener listener) throws Exception {
        this.rpc_type = rpc_type;
        this.listener = listener;
        HTTPServer.addHttpListener(new URL(epr.getAddress()), this);
    }

    public String doRequest(int port, String resource, String payload, HashMap lc_headers) throws HTTPException {
        try {
            String soapAction = (String)lc_headers.get("soapaction");
            if (soapAction == null) {
                soapAction = (String)lc_headers.get("action");
            }
            String operation = null;
            String operationNamespace = null;
            if (soapAction == null) {
                soapAction = (String)lc_headers.get("action");
            }
            if (soapAction == null) {
                soapAction = "";
            }
            if ((soapAction = soapAction.trim()).length() > 0) {
                char first = soapAction.charAt(0);
                char last = soapAction.charAt(soapAction.length() - 1);
                if (first == '\"' || first == '\'') {
                    soapAction = soapAction.substring(1);
                }
                if (last == '\"' || last == '\'') {
                    soapAction = soapAction.substring(0, soapAction.length() - 1);
                }
            }
            if (this.rpc_type) {
                Document doc = XMLUtil.documentFromString(payload);
                ArrayList namespaces = new ArrayList();
                Element envelope_elem = doc.getDocumentElement();
                Element body_elem = null;
                Element opname_elem = null;
                SOAPUtils.gatherNamespaces(namespaces, envelope_elem);
                NodeList bodies = envelope_elem.getChildNodes();
                int b = 0;
                while (body_elem == null) {
                    Node body;
                    if ((body = bodies.item(b++)).getNodeType() != 1) continue;
                    body_elem = (Element)body;
                    SOAPUtils.gatherNamespaces(namespaces, body_elem);
                    NodeList opnames = body_elem.getChildNodes();
                    int p = 0;
                    while (opname_elem == null) {
                        Node opname;
                        if ((opname = opnames.item(p++)).getNodeType() != 1) continue;
                        opname_elem = (Element)opname;
                        SOAPUtils.gatherNamespaces(namespaces, opname_elem);
                    }
                }
                String tagname = opname_elem.getTagName();
                operation = NamespaceTranslator.getName(tagname);
                operationNamespace = "";
                String opns = "";
                if (operation.length() != tagname.length()) {
                    opns = tagname.substring(0, tagname.length() - operation.length() - 1);
                }
                int i = 0;
                while (i < namespaces.size()) {
                    Attr attr = (Attr)namespaces.get(i);
                    String name = attr.getName();
                    String value = attr.getValue();
                    if (name.startsWith("xmlns")) {
                        String nsname = "";
                        if (!name.equals("xmlns")) {
                            nsname = NamespaceTranslator.getName(name);
                        }
                        if (nsname.equals(opns)) {
                            operationNamespace = value;
                        }
                    }
                    ++i;
                }
            }
            return this.listener.doRequest(this.rpc_type, operationNamespace, operation, soapAction, payload);
        }
        catch (SOAPNotFoundException e) {
            throw new HTTPNotFoundException(e.toString());
        }
        catch (Exception e) {
            throw new HTTPException("\n-----\n" + SOAPUtils.getStackTrace(e) + "\n-----\n");
        }
    }
}

