/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface;

public class DeploymentStrategyPort {
    public static final String DEPLOYMENT_STRATEGY_MAP_KEY = "DeploymentStrategy";
    public static final String DEPLOYMENT_STRATEGY_KEY = "DeploymentStrategy";
    public static final String DEPLOYMENT_STRATEGY_SPECIFIC_HOST_KEY = "DeploymentStrategy.SpecificHostIndex";
    public static final Object DEPLOYMENT_STRATEGY_FIRST_HOST = new Object();
    public static final Object DEPLOYMENT_STRATEGY_EVEN_SPREAD = new Object();
    public static final Object DEPLOYMENT_STRATEGY_SPECIFIC_HOST = new Object();

    public void deployAllHostsEvenSpread() {
        DeploymentStrategyPort.setDeploymentStrategy(DEPLOYMENT_STRATEGY_EVEN_SPREAD);
    }

    public void deployOnFirstHost() {
        DeploymentStrategyPort.setDeploymentStrategy(DEPLOYMENT_STRATEGY_FIRST_HOST);
    }

    public void deployOnSpecificHost(int n) {
        DeploymentStrategyPort.setDeploymentStrategy(DEPLOYMENT_STRATEGY_SPECIFIC_HOST);
        DeploymentStrategyPort.setSpecificHostIndex(n);
    }

    public static int getSpecificHostIndex() {
        Thread thread = Thread.currentThread();
        if (thread instanceof RunnerInterface) {
            RunnerInterface engine = (RunnerInterface)thread;
            HashMap deploymentStrategy = engine.getEngineLocalStorageMap("DeploymentStrategy");
            return (Integer)deploymentStrategy.get(DEPLOYMENT_STRATEGY_SPECIFIC_HOST_KEY);
        }
        return 0;
    }

    public static Object getDeploymentStrategy() {
        Thread thread = Thread.currentThread();
        if (thread instanceof RunnerInterface) {
            RunnerInterface engine = (RunnerInterface)thread;
            HashMap deploymentStrategy = engine.getEngineLocalStorageMap("DeploymentStrategy");
            return deploymentStrategy.get("DeploymentStrategy");
        }
        return DEPLOYMENT_STRATEGY_EVEN_SPREAD;
    }

    public static void setDeploymentStrategy(Object o) {
        Thread thread = Thread.currentThread();
        if (thread instanceof RunnerInterface) {
            RunnerInterface engine = (RunnerInterface)thread;
            HashMap deploymentStrategy = engine.getEngineLocalStorageMap("DeploymentStrategy");
            deploymentStrategy.put("DeploymentStrategy", o);
        }
    }

    public static void setSpecificHostIndex(int n) {
        Thread thread = Thread.currentThread();
        if (thread instanceof RunnerInterface) {
            RunnerInterface engine = (RunnerInterface)thread;
            HashMap deploymentStrategy = engine.getEngineLocalStorageMap("DeploymentStrategy");
            deploymentStrategy.put(DEPLOYMENT_STRATEGY_SPECIFIC_HOST_KEY, new Integer(n));
        }
    }
}

