/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import java.util.GregorianCalendar;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports.ThroughputTimerData;

public class ThroughputTimerPort {
    private static final long ERROR_MARGIN = 100L;

    public Double getTimeAsDouble() {
        return new Double(System.currentTimeMillis());
    }

    public Double getElapsedTimeAsDouble(double time) {
        return new Double((double)System.currentTimeMillis() - time);
    }

    public boolean pollTimer(ThroughputTimerData timer) throws InterruptedException {
        long previous_time = timer.timeMS.getTimeInMillis();
        long next_time = previous_time + (long)timer.incrementMS;
        if (next_time - System.currentTimeMillis() > (long)(2 * timer.pollFrequencyMS)) {
            Thread.sleep(timer.pollFrequencyMS);
            return false;
        }
        long diff = next_time - System.currentTimeMillis();
        if (diff > 0L) {
            Thread.sleep(diff);
        }
        return true;
    }

    public ThroughputTimerData incrementTimer(ThroughputTimerData timer) {
        timer.timeMS.setTimeInMillis(timer.timeMS.getTimeInMillis() + (long)timer.incrementMS);
        return timer;
    }

    public ThroughputTimerData getTime(ThroughputTimerData timer) {
        timer.timeMS = new GregorianCalendar();
        timer.timeMS.setTimeInMillis(System.currentTimeMillis());
        return timer;
    }
}

