/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.core.Runner;
import org.eclipse.stp.b2j.core.jengine.internal.core.SubControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedHashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedBarrier;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedSemaphore;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.RunnerLock;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.ThreadGroupListener;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.Variable;
import org.eclipse.stp.b2j.core.jengine.internal.message.MTTransactionClient;
import org.eclipse.stp.b2j.core.jengine.internal.message.MTTransactionServer;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.TransactionListener;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ID;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.UIDPool;

public abstract class ControllerConnection
implements SubControllerInterface,
TransactionListener,
ThreadGroupListener {
    protected int id;
    private Object TEMP_ID_LOCK = new Object();
    private int temp_id = 1;
    protected Object shared_vars_LOCK = new Object();
    protected ArrayList shared_vars = new ArrayList();
    protected HashMap shared_vars_map = new HashMap();
    protected MTTransactionClient tc;
    protected MTTransactionServer ts;
    protected Object cached_hashmap_LOCK = new Object();
    protected Object cached_mutex_LOCK = new Object();
    protected Object cached_barrier_LOCK = new Object();
    protected Object cached_semaphore_LOCK = new Object();
    protected Object cached_hosts_LOCK = new Object();
    protected HashMap cached_hashmap = new HashMap();
    protected HashMap cached_mutex = new HashMap();
    protected HashMap cached_barrier = new HashMap();
    protected HashMap cached_semaphore = new HashMap();
    protected String[] cached_hosts = null;
    private Object waiting_map_LOCK = new Object();
    private HashMap waiting_map = new HashMap();
    private Object wait_directory_LOCK = new HashMap();
    private Object[] wait_directory = new Object[100];
    private Object msg_directory_LOCK = new HashMap();
    private Object[] msg_directory = new Object[100];
    private Object localmaps_LOCK = new Object();
    private HashMap localmaps = new HashMap();
    UIDPool uidpool = new UIDPool(20);

    private Object[] expandArray(Object[] rwait) {
        return this.expandArray(rwait, rwait.length - 1);
    }

    private Object[] expandArray(Object[] rwait, int minindex) {
        int minlen = minindex + 1;
        minlen = Math.max(minlen * 2, rwait.length * 2);
        Object[] nrwait = new Object[minlen];
        System.arraycopy(rwait, 0, nrwait, 0, rwait.length);
        return nrwait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ControllerConnection(int id) {
        this.id = id;
        Object object = this.TEMP_ID_LOCK;
        synchronized (object) {
            this.temp_id = 100000 * id;
        }
    }

    private void pushStack(String note) {
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            Runner.pushStack("Engine Transaction - " + note);
        }
    }

    private void popStack() {
        if (Switches.APPEND_TRANSACTIONS_TO_CALLSTACK) {
            Runner.popStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getEngineLocalStorageMap(String name) {
        Object object = this.localmaps_LOCK;
        synchronized (object) {
            HashMap map = (HashMap)this.localmaps.get(name);
            if (map == null) {
                map = new HashMap();
                this.localmaps.put(name, map);
            }
            return map;
        }
    }

    public void terminate() throws Exception {
        Logger.error("Terminate Request", new Throwable("Terminate Request STACKTRACE"));
        new Terminator().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadException(Thread t, Throwable e) {
        Object object;
        Logger.warning("Engine about to die, waking all runner waits");
        try {
            object = this.wait_directory_LOCK;
            synchronized (object) {
                int i = 0;
                while (i < this.wait_directory.length) {
                    try {
                        RunnerLock rlock;
                        RunnerLock runnerLock = rlock = (RunnerLock)this.wait_directory[i];
                        synchronized (runnerLock) {
                            rlock.notifyAll();
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        Logger.warning("Engine about to die, waking all semaphore waits");
        try {
            object = this.waiting_map_LOCK;
            synchronized (object) {
                ArrayList list = new ArrayList(this.waiting_map.values());
                int i = 0;
                while (i < list.size()) {
                    try {
                        Object tlock;
                        Object v = tlock = list.get(i);
                        synchronized (v) {
                            tlock.notifyAll();
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
    }

    private void setLogLevel(boolean error, boolean warning, boolean info) throws Exception {
        Logger.PRINT_ERROR = error;
        Logger.PRINT_WARNING = warning;
        Logger.PRINT_INFO = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinRunner(Long remote_id) throws Exception {
        int uid = this.uidpool.getUID();
        long rid = 0L;
        Object object = this.wait_directory_LOCK;
        synchronized (object) {
            RunnerLock rlock = new RunnerLock();
            rid = ID.CREATE_ID(this.id, uid);
            if (uid >= this.wait_directory.length) {
                this.wait_directory = this.expandArray(this.wait_directory, uid);
            }
            this.wait_directory[uid] = rlock;
        }
        this.joinRunnerInternal(new Long(rid), remote_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinRunnerInternal(Long waiter_id, Long remote_id) throws Exception {
        Message m = new Message(4196904);
        m.append(waiter_id);
        m.append(remote_id);
        this.pushStack("joinRunner");
        m = this.tc.doTransaction(m);
        this.popStack();
        int mtype = m.getType();
        if (mtype != 2601 && mtype != 2602) {
            throw new Exception("Controller launch runner failed " + m);
        }
        int uid = ID.RUNNER_ID(waiter_id);
        if (mtype == 2602) {
            RunnerLock rlock = null;
            Object object = this.wait_directory_LOCK;
            synchronized (object) {
                rlock = (RunnerLock)this.wait_directory[uid];
            }
            object = rlock;
            synchronized (object) {
                if (rlock.lock) {
                    rlock.lock = false;
                } else {
                    rlock.lock = true;
                    this.pushStack("waiting for runner " + uid + " to finish");
                    rlock.wait();
                    this.popStack();
                }
            }
        }
        Logger.info("ControllerConnection: TOLD TO CONTINUE");
        this.uidpool.releaseUID(uid);
    }

    public Message sendAndReceiveMessage(String conversation, Message msg, String conversationReturn, long mstimeout) throws Exception {
        Message tmp = new Message();
        tmp.append(conversationReturn);
        return this.sendAndReceiveMessage(conversation, msg, tmp, false, mstimeout);
    }

    public Message sendAndReceiveMessage(String conversation, Message msg, String conversationReturn) throws Exception {
        Message tmp = new Message();
        tmp.append(conversationReturn);
        return this.sendAndReceiveMessage(conversation, msg, tmp, false, 0L);
    }

    public Message sendAndReceiveMessage(String conversation, Message msg, Message conversationReturns, long mstimeout) throws Exception {
        return this.sendAndReceiveMessage(conversation, msg, conversationReturns, true, mstimeout);
    }

    public Message sendAndReceiveMessage(String conversation, Message msg, Message conversationReturns) throws Exception {
        return this.sendAndReceiveMessage(conversation, msg, conversationReturns, true, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message sendAndReceiveMessage(String conversation, Message msg, Message conversationReturns, boolean return_conversation, long mstimeout) throws Exception {
        int uid = this.uidpool.getUID();
        long rid = 0L;
        Object object = this.msg_directory_LOCK;
        synchronized (object) {
            RunnerLock rlock = new RunnerLock();
            rid = ID.CREATE_ID(this.id, uid);
            if (uid >= this.msg_directory.length) {
                this.msg_directory = this.expandArray(this.msg_directory, uid);
            }
            this.msg_directory[uid] = rlock;
        }
        Long waiter_id = new Long(rid);
        String timeout_conversation = waiter_id + ":~TMT~";
        if (mstimeout > 0L) {
            conversationReturns.append(timeout_conversation);
        } else if (mstimeout < 0L) {
            mstimeout = 0L;
        }
        Message m = new Message(4197304);
        m.append(conversation);
        m.append(msg);
        m.append(rid);
        m.append(conversationReturns);
        this.pushStack("sendAndReceiveMessage");
        m = this.tc.doTransaction(m);
        this.popStack();
        int mtype = m.getType();
        if (mtype != 3001 && mtype != 3002) {
            throw new Exception("Controller launch runner failed " + m);
        }
        Message received = null;
        if (mtype == 3002) {
            if (m.length() > 0) {
                this.pushStack("sendAndReceiveMessage - piggyBacked transaction");
                this.doTransaction((Message)m.get(0));
                this.popStack();
            }
            received = this.receiveMessageOnRunnerLock(uid, waiter_id, conversationReturns, mstimeout, timeout_conversation);
        } else {
            if (m.length() > 1) {
                this.pushStack("sendAndReceiveMessage - piggyBacked transaction");
                this.doTransaction((Message)m.get(1));
                this.popStack();
            }
            received = (Message)m.get(0);
        }
        this.uidpool.releaseUID(uid);
        if (return_conversation && received != null && conversationReturns.length() == 1) {
            received.append((String)conversationReturns.get(0));
        }
        return received;
    }

    public void sendMessage(String conversation, Message msg) throws Exception {
        Message m = new Message(4197204);
        m.append(conversation);
        m.append(msg);
        m.append(ID.CREATE_ID(this.id, 0));
        this.pushStack("sendMessage");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.length() > 0) {
            this.pushStack("sendMessage - piggyBacked transaction");
            this.doTransaction((Message)m.get(0));
            this.popStack();
        }
    }

    public Message receiveMessage(String conversation) throws Exception {
        return this.receiveMessage(conversation, 0L);
    }

    public Message receiveMessage(String conversation, long mstimeout) throws Exception {
        Message tmp = new Message();
        tmp.append(conversation);
        return this.receiveMessage(tmp, mstimeout, false);
    }

    public Message receiveMessage(Message conversations) throws Exception {
        return this.receiveMessage(conversations, 0L);
    }

    public Message receiveMessage(Message conversations, long mstimeout) throws Exception {
        return this.receiveMessage(conversations, mstimeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveMessage(Message conversations, long mstimeout, boolean return_conversation) throws Exception {
        int uid = this.uidpool.getUID();
        long rid = 0L;
        Object object = this.msg_directory_LOCK;
        synchronized (object) {
            RunnerLock rlock = new RunnerLock();
            rid = ID.CREATE_ID(this.id, uid);
            if (uid >= this.msg_directory.length) {
                this.msg_directory = this.expandArray(this.msg_directory, uid);
            }
            this.msg_directory[uid] = rlock;
        }
        return this.receiveMessageInternal(new Long(rid), conversations, mstimeout, return_conversation);
    }

    private Message receiveMessageInternal(Long waiter_id, Message conversations, long mstimeout, boolean return_conversation) throws Exception {
        String timeout_conversation = waiter_id + ":~TMT~";
        if (mstimeout > 0L) {
            conversations.append(timeout_conversation);
        } else if (mstimeout < 0L) {
            mstimeout = 0L;
        }
        Message m = new Message(4197104);
        m.append(waiter_id);
        m.append(conversations);
        this.pushStack("receiveMessageInternal");
        m = this.tc.doTransaction(m);
        this.popStack();
        int mtype = m.getType();
        if (mtype != 2801 && mtype != 2802) {
            throw new Exception("Controller launch runner failed " + m);
        }
        Message received = null;
        int uid = ID.RUNNER_ID(waiter_id);
        received = mtype == 2802 ? this.receiveMessageOnRunnerLock(uid, waiter_id, conversations, mstimeout, timeout_conversation) : (Message)m.get(0);
        this.uidpool.releaseUID(uid);
        if (return_conversation && received != null && conversations.length() == 1) {
            received.append((String)conversations.get(0));
        }
        return received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveMessageOnRunnerLock(int uid, Long waiter_id, Message conversations, long mstimeout, String timeout_conversation) throws InterruptedException, Exception {
        RunnerLock rlock = null;
        Object object = this.msg_directory_LOCK;
        synchronized (object) {
            rlock = (RunnerLock)this.msg_directory[uid];
        }
        object = rlock;
        synchronized (object) {
            if (rlock.lock) {
                rlock.lock = false;
            } else {
                rlock.lock = true;
                this.pushStack("waiting to receive message on " + conversations);
                rlock.wait(mstimeout);
                this.popStack();
            }
            if (rlock.data == null) {
                rlock.lock = false;
            }
        }
        if (rlock.data == null) {
            this.sendMessage(timeout_conversation, new Message());
            object = rlock;
            synchronized (object) {
                if (rlock.lock) {
                    rlock.lock = false;
                } else {
                    rlock.lock = true;
                    this.pushStack("waiting to receive timeout message on " + conversations);
                    rlock.wait();
                    this.popStack();
                }
                Message real_received = (Message)rlock.data;
                if (real_received.get(real_received.length() - 1).equals(timeout_conversation)) {
                    rlock.data = null;
                } else {
                    Message timeout_conversations = new Message();
                    timeout_conversations.append(timeout_conversation);
                    Message timeout_cleanup = new Message(4197104);
                    timeout_cleanup.append(waiter_id);
                    timeout_cleanup.append(timeout_conversations);
                    this.pushStack("receiveMessageInternal - timeout cleanup");
                    timeout_cleanup = this.tc.doTransaction(timeout_cleanup);
                    this.popStack();
                    if (timeout_cleanup.getType() == 2802) {
                        Logger.direct("ERROR - got a WILL NOTIFY back from a timeout cleanup message");
                    }
                    rlock.data = real_received;
                }
            }
        }
        return (Message)rlock.data;
    }

    public Message launchRunner(int count, String method, int host_index) throws Exception {
        return this.launchRunner(count, method, host_index, new ArrayList(1));
    }

    public Message launchRunner(int count, String method, int host_index, String[] args) throws Exception {
        ArrayList<String> list = new ArrayList<String>(args.length);
        int i = 0;
        while (i < list.size()) {
            list.add(args[i]);
            ++i;
        }
        return this.launchRunner(count, method, host_index, list);
    }

    public Message launchRunner(int count, String method, int host_index, List args) throws Exception {
        Message margs = new Message();
        int i = 0;
        while (i < args.size()) {
            margs.append((String)args.get(i));
            ++i;
        }
        return this.launchRunner(count, method, host_index, margs);
    }

    public Message launchRunner(int count, String method, int host_index, Message args) throws Exception {
        Message m = new Message(2097352);
        m.append(count);
        m.append(method);
        m.append(host_index);
        m.append(args);
        this.pushStack("launchRunner");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() != 201) {
            throw new Exception("Controller launch runner failed " + m);
        }
        return (Message)m.get(0);
    }

    public SharedVariable newVariable(String name, int type, boolean dirty) throws Exception {
        Message m = null;
        m = dirty ? new Message(1049676) : new Message(1048876);
        m.append(name);
        m.append(type);
        this.pushStack("newVariable");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() != 301 && m.getType() != 303) {
            throw new Exception("Controller make variable failed " + m);
        }
        Integer vid = (Integer)m.get(0);
        SharedVariable sv = new SharedVariable(this, name, vid, type, null);
        return sv;
    }

    public SharedSemaphore newSemaphore(String name, int initial) throws Exception {
        Message m = new Message(0x100190);
        m.append(name);
        m.append(initial);
        this.pushStack("newSemaphore");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() != 401 && m.getType() != 403) {
            throw new Exception("Controller make semaphore failed " + m);
        }
        Integer vid = (Integer)m.get(0);
        SharedSemaphore sm = new SharedSemaphore(this, name, vid);
        return sm;
    }

    public SharedHashMap newHashMap(String name) throws Exception {
        Message m = null;
        m = new Message(1050076);
        m.append(name);
        this.pushStack("newHashMap");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() != 1501 && m.getType() != 1503) {
            throw new Exception("Controller make hashmap failed " + m);
        }
        Integer hid = (Integer)m.get(0);
        SharedHashMap shmp = new SharedHashMap(this, name, hid);
        return shmp;
    }

    public SharedBarrier newBarrier(String name, int size) throws Exception {
        SharedSemaphore waiting = this.newSemaphore(String.valueOf(name) + "%_sBARRIER_WAITING", 0);
        SharedSemaphore barrier = this.newSemaphore(String.valueOf(name) + "%_sBARRIER_BARRIER", 0);
        SharedVariable barrier_size = this.newVariable(String.valueOf(name) + "%_sBARRIER_SIZE", 0, true);
        barrier_size.setValue(size);
        barrier_size.varStore();
        SharedBarrier sbarrier = new SharedBarrier(waiting, barrier, size);
        return sbarrier;
    }

    public SharedMutex newMutex(String name) throws Exception {
        SharedSemaphore msem = this.newSemaphore(String.valueOf(name) + "%_sMUTEX", 1);
        SharedMutex smutex = new SharedMutex(msem);
        return smutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedBarrier getBarrier(String name) throws Exception {
        SharedBarrier sbarrier = null;
        Object object = this.cached_barrier_LOCK;
        synchronized (object) {
            sbarrier = (SharedBarrier)this.cached_barrier.get(name);
        }
        if (sbarrier == null) {
            SharedSemaphore waiting = this.getSemaphore(String.valueOf(name) + "%_sBARRIER_WAITING");
            SharedSemaphore barrier = this.getSemaphore(String.valueOf(name) + "%_sBARRIER_BARRIER");
            SharedVariable barrier_size = this.getVariable(String.valueOf(name) + "%_sBARRIER_SIZE");
            barrier_size.varFetch();
            sbarrier = new SharedBarrier(waiting, barrier, barrier_size.getValueInt());
            Object object2 = this.cached_barrier_LOCK;
            synchronized (object2) {
                this.cached_barrier.put(name, sbarrier);
            }
        }
        return sbarrier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedMutex getMutex(String name) throws Exception {
        SharedMutex smutex = null;
        Object object = this.cached_mutex_LOCK;
        synchronized (object) {
            smutex = (SharedMutex)this.cached_mutex.get(name);
        }
        if (smutex == null) {
            SharedSemaphore msem = this.getSemaphore(String.valueOf(name) + "%_sMUTEX");
            smutex = new SharedMutex(msem);
            Object object2 = this.cached_mutex_LOCK;
            synchronized (object2) {
                this.cached_mutex.put(name, smutex);
            }
        }
        return smutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedHashMap getHashMap(String name) throws Exception {
        SharedHashMap map = null;
        Object object = this.cached_hashmap_LOCK;
        synchronized (object) {
            map = (SharedHashMap)this.cached_hashmap.get(name);
        }
        if (map == null) {
            Message m = new Message(2098752);
            m.append(name);
            this.pushStack("getHashMap");
            m = this.tc.doTransaction(m);
            this.popStack();
            if (m.getType() != 1601) {
                throw new Exception("Controller get hashmap failed " + m);
            }
            Integer hid = (Integer)m.get(0);
            map = new SharedHashMap(this, name, hid);
            Object object2 = this.cached_hashmap_LOCK;
            synchronized (object2) {
                this.cached_hashmap.put(name, map);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedVariable getVariable(String name) throws Exception {
        Variable v;
        Object object = this.shared_vars_LOCK;
        synchronized (object) {
            v = (Variable)this.shared_vars_map.get(name);
        }
        SharedVariable sv = new SharedVariable(this, name, v.getID(), v.getType(), null);
        return sv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedSemaphore getSemaphore(String name) throws Exception {
        SharedSemaphore sem = null;
        Object object = this.cached_semaphore_LOCK;
        synchronized (object) {
            sem = (SharedSemaphore)this.cached_semaphore.get(name);
        }
        if (sem == null) {
            Message m = new Message(2098152);
            m.append(name);
            this.pushStack("getSemaphore");
            m = this.tc.doTransaction(m);
            this.popStack();
            if (m.getType() != 1001) {
                throw new Exception("Controller get semaphore failed " + m);
            }
            Integer sid = (Integer)m.get(0);
            sem = new SharedSemaphore(this, name, sid);
            Object object2 = this.cached_semaphore_LOCK;
            synchronized (object2) {
                this.cached_semaphore.put(name, sem);
            }
        }
        return sem;
    }

    public void hashmapSet(int id, String key, Object value) throws Exception {
        Message m = new Message(4196004);
        m.append(id);
        m.append(key);
        if (value instanceof String) {
            m.append((String)value);
        } else if (value instanceof byte[]) {
            m.append((byte[])value);
        } else if (value instanceof Integer) {
            m.append((Integer)value);
        } else if (value instanceof Long) {
            m.append((Long)value);
        } else if (value instanceof Double) {
            m.append((Double)value);
        } else if (value instanceof Message) {
            m.append((Message)value);
        } else {
            throw new Exception("value is of no recognised type");
        }
        this.pushStack("hashmapSet");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() != 1701) {
            throw new Exception("Controller store hashmap failed " + m);
        }
    }

    public String[] hashmapGetKeys(int id) throws Exception {
        Message m = new Message(4197704);
        m.append(id);
        this.pushStack("hashmapGetKeys");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() != 3401) {
            throw new Exception("Controller retrieve hashmap keylist failed " + m);
        }
        String[] keys = new String[m.length()];
        int i = 0;
        while (i < keys.length) {
            keys[i] = (String)m.get(i);
            ++i;
        }
        return keys;
    }

    public Object hashmapGet(int id, String key) throws Exception {
        Message m = new Message(4196104);
        m.append(id);
        m.append(key);
        this.pushStack("hashmapGet");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() == 1803) {
            return null;
        }
        if (m.getType() != 1801) {
            throw new Exception("Controller retrieve hashmap failed " + m);
        }
        return m.get(0);
    }

    public void hashmapClear(int id) throws Exception {
        Message m = new Message(4196504);
        m.append(id);
        this.pushStack("hashmapClear");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() != 2201) {
            throw new Exception("Controller clear hashmap failed " + m);
        }
    }

    public void doRunnerStackTrace(int stack_message_id) throws Exception {
        new StackDumper(true, stack_message_id).start();
    }

    public void doRunnerStackDump() throws Exception {
        new StackDumper(false, 0).start();
    }

    public String getHost() throws Exception {
        return "unknown(client)";
    }

    public String[] getHosts() throws Exception {
        String[] hosts = this.cached_hosts;
        if (hosts == null) {
            Message m = new Message(1050876);
            this.pushStack("getHosts");
            m = this.tc.doTransaction(m);
            this.popStack();
            if (m.getType() != 2301) {
                throw new Exception("Controller get hosts failed " + m);
            }
            Integer count = (Integer)m.get(0);
            hosts = new String[count.intValue()];
            int i = 0;
            while (i < hosts.length) {
                hosts[i] = (String)m.get(i + 1);
                ++i;
            }
            this.cached_hosts = hosts;
        }
        return hosts;
    }

    public String[] getVariableNames() throws Exception {
        Message m = new Message(1050976);
        this.pushStack("getVariableNames");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() != 2401) {
            throw new Exception("Controller get variable list failed " + m);
        }
        Integer count = (Integer)m.get(0);
        String[] vars = new String[count.intValue()];
        int i = 0;
        while (i < vars.length) {
            vars[i] = (String)m.get(i + 1);
            ++i;
        }
        return vars;
    }

    public void storeVariable(int id, int type, Object newval) throws Exception {
        Message m = new Message(4195004);
        m.append(id);
        m.append(type);
        switch (type) {
            case 0: {
                m.append((Integer)newval);
                break;
            }
            case 4: {
                m.append((String)newval);
                break;
            }
            case 5: {
                m.append((byte[])newval);
                break;
            }
            case 1: {
                m.append((Long)newval);
                break;
            }
            case 6: {
                m.append((Message)newval);
                break;
            }
            case 3: {
                m.append((Double)newval);
                break;
            }
            case 2: {
                m.append(((Number)newval).doubleValue());
                break;
            }
            default: {
                throw new Exception("variable has no recognised type");
            }
        }
        this.pushStack("storeVariable");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() != 701) {
            throw new Exception("Controller store variable failed " + m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVariableDirty(int id) throws Exception {
        Variable v;
        Object object = this.shared_vars_LOCK;
        synchronized (object) {
            v = (Variable)this.shared_vars.get(id - 1);
        }
        return v.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fetchVariable(int id, int type) throws Exception {
        Variable v;
        Object object = this.shared_vars_LOCK;
        synchronized (object) {
            v = (Variable)this.shared_vars.get(id - 1);
        }
        object = v.LOCK;
        synchronized (object) {
            if (v.getDirtyType()) {
                if (v.isDirty()) {
                    v.setDirty(false);
                    Object o = this.realFetchVariable(id, type);
                    v.setValue(o);
                    return o;
                }
                return v.getValue();
            }
            return this.realFetchVariable(id, type);
        }
    }

    public Object realFetchVariable(int id, int type) throws Exception {
        Message m = new Message(4195104);
        m.append(this.id);
        m.append(id);
        m.append(type);
        this.pushStack("realFetchVariable");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() != 801) {
            throw new Exception("Controller make variable failed " + m);
        }
        Integer vtype_o = (Integer)m.get(0);
        int vtype = vtype_o;
        Object newval = m.get(1);
        switch (vtype) {
            case 0: {
                return (Integer)newval;
            }
            case 4: {
                return (String)newval;
            }
            case 5: {
                return (byte[])newval;
            }
            case 6: {
                return (Message)newval;
            }
            case 1: {
                return (Long)newval;
            }
            case 3: {
                return (Double)newval;
            }
            case 2: {
                return new Float(((Double)newval).floatValue());
            }
        }
        throw new Exception("unrecognised returned variable type");
    }

    public void signalSemaphore(int id, int n) throws Exception {
        Message m = new Message(4194904);
        m.append(id);
        m.append(n);
        this.pushStack("signalSemaphore");
        m = this.tc.doTransaction(m);
        this.popStack();
        if (m.getType() != 601) {
            throw new Exception("Controller signal semaphore failed " + m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitSemaphore(int id, int n) throws Exception {
        Object tlock;
        long rid = 0L;
        Object object = this.TEMP_ID_LOCK;
        synchronized (object) {
            rid = ID.CREATE_ID(this.id, this.temp_id);
            ++this.temp_id;
        }
        Message m = new Message(4194804);
        m.append(id);
        m.append(n);
        m.append(rid);
        Integer key = new Integer((int)(rid & 0xFFFFFFFFFFFFFFFFL));
        Object object2 = tlock = new Object();
        synchronized (object2) {
            Object object3 = this.waiting_map_LOCK;
            synchronized (object3) {
                this.waiting_map.put(key, tlock);
            }
            this.pushStack("waitSemaphore");
            m = this.tc.doTransaction(m);
            this.popStack();
            if (m.getType() == 501) {
                object3 = this.waiting_map_LOCK;
                synchronized (object3) {
                    this.waiting_map.remove(key);
                }
            } else if (m.getType() == 503) {
                this.pushStack("waiting on semaphore " + id);
                tlock.wait();
                this.popStack();
            } else {
                throw new Exception("Controller wait semaphore failed " + m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalObject(long lid) throws Exception {
        Integer key = new Integer((int)(lid & 0xFFFFFFFFFFFFFFFFL));
        Object t = null;
        Object object = this.waiting_map_LOCK;
        synchronized (object) {
            t = this.waiting_map.remove(key);
        }
        object = t;
        synchronized (object) {
            t.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message doTransaction(Message m) {
        Message r;
        int type = m.getType();
        if (type == 200) {
            Logger.info("SUBCONTROLLER: Signal Runner");
            Long id = (Long)m.get(0);
            long lid = id;
            try {
                if (ID.CONTROLLER_ID(lid) != this.id) {
                    throw new Exception("SIGNAL RUNNER SENT TO WRONG CONTROLLER!");
                }
                this.signalObject(lid);
                r = new Message(201);
            }
            catch (Exception e) {
                r = new Message(202);
                r.append(Logger.getStackTrace(e));
                r.append(ID.ID_HEX(id));
            }
        } else if (type == 700) {
            Logger.info("SUBCONTROLLER: Receive Message");
            Long rid = (Long)m.get(0);
            Message data = (Message)m.get(1);
            RunnerLock rlock = null;
            Object e = this.msg_directory_LOCK;
            synchronized (e) {
                int uid = ID.RUNNER_ID(rid);
                rlock = (RunnerLock)this.msg_directory[uid];
                if (rlock == null) {
                    rlock = new RunnerLock();
                    this.msg_directory[uid] = rlock;
                }
            }
            e = rlock;
            synchronized (e) {
                rlock.data = data;
                if (rlock.lock) {
                    rlock.lock = false;
                    rlock.notify();
                } else {
                    rlock.lock = true;
                }
            }
            r = new Message(701);
        } else if (type == 300) {
            Logger.info("SUBCONTROLLER: Make Variable");
            Integer btype = (Integer)m.get(0);
            boolean dirty = btype == 1049676;
            String vname = (String)m.get(1);
            Integer vtype = (Integer)m.get(2);
            Integer vid = (Integer)m.get(3);
            try {
                Variable v = new Variable(vname, vid, vtype);
                if (dirty) {
                    v.setDirtyType(true);
                    v.setDirty(true);
                } else {
                    v.setDirtyType(false);
                    v.setDirty(true);
                }
                Object object = this.shared_vars_LOCK;
                synchronized (object) {
                    this.shared_vars.add(v);
                    this.shared_vars_map.put(vname, v);
                }
                r = new Message(301);
            }
            catch (Exception e) {
                r = new Message(302);
                r.append(Logger.getStackTrace(e));
            }
        } else if (type == 400) {
            Variable v;
            Logger.info("SUBCONTROLLER: Notify Dirty");
            Integer vid = (Integer)m.get(0);
            Object vname = this.shared_vars_LOCK;
            synchronized (vname) {
                v = (Variable)this.shared_vars.get(vid - 1);
            }
            v.setDirty(true);
            r = new Message(401);
        } else if (type == 700) {
            Logger.info("SUBCONTROLLER: Receive Message");
            Long rid = (Long)m.get(0);
            Message data = (Message)m.get(1);
            RunnerLock rlock = null;
            Object object = this.msg_directory_LOCK;
            synchronized (object) {
                int uid = ID.RUNNER_ID(rid);
                rlock = (RunnerLock)this.msg_directory[uid];
                if (rlock == null) {
                    rlock = new RunnerLock();
                    this.msg_directory[uid] = rlock;
                }
            }
            object = rlock;
            synchronized (object) {
                rlock.data = data;
                if (rlock.lock) {
                    rlock.lock = false;
                    rlock.notify();
                } else {
                    rlock.lock = true;
                }
            }
            r = new Message(701);
        } else if (type == 600) {
            Logger.info("SUBCONTROLLER: Wake Runner");
            Long rid = (Long)m.get(0);
            RunnerLock rlock = null;
            Object object = this.wait_directory_LOCK;
            synchronized (object) {
                rlock = (RunnerLock)this.wait_directory[ID.RUNNER_ID(rid)];
            }
            object = rlock;
            synchronized (object) {
                if (rlock.lock) {
                    rlock.lock = false;
                    rlock.notify();
                } else {
                    rlock.lock = true;
                }
            }
            r = new Message(601);
        } else if (type == 1000) {
            Logger.info("SUBCONTROLLER: Set Log Level");
            try {
                this.setLogLevel((Integer)m.get(0) == 1, (Integer)m.get(1) == 1, (Integer)m.get(2) == 1);
                r = new Message(1001);
            }
            catch (Exception e) {
                r = new Message(1002);
                r.append(Logger.getStackTrace(e));
            }
        } else {
            r = new Message(-1);
        }
        return r;
    }

    class Terminator
    extends Thread {
        Terminator() {
        }

        public void run() {
            try {
                Message m = new Message(2700);
                m = ControllerConnection.this.tc.doTransaction(m);
            }
            catch (Throwable t) {
                Logger.error("Failed to complete engine terminate request", t);
            }
        }
    }

    private class StackDumper
    extends Thread {
        boolean trace;
        int msg_id;

        public StackDumper(boolean trace, int msg_id) {
            this.trace = trace;
            this.msg_id = msg_id;
        }

        public void run() {
            try {
                if (this.trace) {
                    Message m = new Message(3500);
                    m.append(this.msg_id);
                    m = ControllerConnection.this.tc.doTransaction(m);
                } else {
                    Message m = new Message(3100);
                    m = ControllerConnection.this.tc.doTransaction(m);
                }
            }
            catch (Throwable t) {
                Logger.error("Failed to complete stackdump request", t);
            }
        }
    }
}

