/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.multiplex;

import java.util.Random;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.ByteArrayInBuffer;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.ByteArrayOutBuffer;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;

public class ByteArrayOutBufferTest {
    static long start = System.currentTimeMillis();

    public static void main(String[] args) {
        ByteArrayOutBuffer bout = new ByteArrayOutBuffer();
        ByteArrayInBuffer bain = new ByteArrayInBuffer();
        new WriterThread(bout).start();
        new ReaderThread(bout, bain).start();
    }

    public static class WriterThread
    extends Thread {
        ByteArrayOutBuffer stream;

        public WriterThread(ByteArrayOutBuffer b) {
            this.stream = b;
        }

        public void run() {
            Random rand = new Random(start);
            try {
                while (true) {
                    int choice;
                    if ((choice = rand.nextInt(2)) == 0) {
                        StreamUtils.writeInt(this.stream, rand.nextInt());
                    } else if (choice == 1) {
                        StreamUtils.writeBytes(this.stream, new byte[rand.nextInt(30000)]);
                    } else if (choice == 2) {
                        StreamUtils.writeString(this.stream, new String("" + rand.nextInt() + rand.nextDouble() + rand.nextGaussian() + rand.nextLong()));
                    }
                    try {
                        Thread.sleep(2L);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
                return;
            }
        }
    }

    public static class ReaderThread
    extends Thread {
        ByteArrayOutBuffer baut;
        ByteArrayInBuffer bain;

        public ReaderThread(ByteArrayOutBuffer bout, ByteArrayInBuffer bin) {
            this.baut = bout;
            this.bain = bin;
        }

        public void run() {
            Exception exc = new Exception("out of sync");
            ByteArrayInBuffer bain = new ByteArrayInBuffer();
            Random rand = new Random(start);
            try {
                long t = System.currentTimeMillis();
                long total = 0L;
                while (true) {
                    int choice;
                    byte[] dat = this.baut.clearToByteArray(2000);
                    total += (long)dat.length;
                    bain.add(dat);
                    if (bain.length() > 30000 && ((choice = rand.nextInt(2)) == 0 ? rand.nextInt() != StreamUtils.readInt(bain) : (choice == 1 ? rand.nextInt(30000) != StreamUtils.readBytes(bain).length : choice == 2 && !new String("" + rand.nextInt() + rand.nextDouble() + rand.nextGaussian() + rand.nextLong()).equals(StreamUtils.readString(bain))))) {
                        throw exc;
                    }
                    if (System.currentTimeMillis() <= t) continue;
                    System.out.println(String.valueOf(total) + " bytes transferred (" + this.baut.size() + " bytes in OUT buffer) (" + bain.length() + " bytes in IN buffer)");
                    t = System.currentTimeMillis() + 2000L;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
                return;
            }
        }
    }
}

