/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.multiplex;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.OpenByteArrayOutputStream;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.UnqueuedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;

public class MultiplexerOutputStream
implements org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexingOutput {
    OutputStream outstream;
    private Object lock = new Object();
    HashMap streams = new HashMap();
    HashMap locks = new HashMap();
    IOException ioexception;
    private static final int MINCHUNK = 1024;
    private static final int MAXCHUNK = 4096;

    public MultiplexerOutputStream(OutputStream out) {
        this.outstream = new BufferedOutputStream(out);
    }

    public MultiplexerOutputStream(OutputStream out, String name) {
        this.outstream = new BufferedOutputStream(out);
    }

    public MultiplexerOutputStream(OutputStream out, String name, ThreadGroup tg) {
        this.outstream = new BufferedOutputStream(out);
    }

    public void closeAll(IOException err) {
        this.ioexception = err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnqueuedMutex getLock(short n) {
        Integer N = new Integer(n);
        Object object = this.lock;
        synchronized (object) {
            UnqueuedMutex nlock = (UnqueuedMutex)this.locks.get(N);
            if (nlock == null) {
                nlock = new UnqueuedMutex();
                this.locks.put(N, nlock);
            }
            return nlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream(short n) {
        HashMap hashMap = this.streams;
        synchronized (hashMap) {
            Integer N = new Integer(n);
            OutputStream out = (OutputStream)this.streams.get(N);
            if (out == null) {
                out = new MultiplexingOutput(n);
                this.streams.put(N, out);
            }
            return out;
        }
    }

    public void flushAll() throws IOException {
        Collection tmp = this.streams.values();
        Iterator it = tmp.iterator();
        while (it.hasNext()) {
            ((MultiplexingOutput)it.next()).flush();
        }
    }

    class MultiplexingOutput
    extends FilterOutputStream {
        short n;
        Object boutlock = new Object();
        OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();

        public MultiplexingOutput(short n) {
            super(MultiplexerOutputStream.this.outstream);
            this.n = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeChunk() throws IOException {
            Object object = MultiplexerOutputStream.this.lock;
            synchronized (object) {
                if (this.bout.size() > 0) {
                    StreamUtils.writeShort(MultiplexerOutputStream.this.outstream, this.n);
                    StreamUtils.writeBytes(MultiplexerOutputStream.this.outstream, this.bout.getByteArray(), 0, this.bout.size());
                    this.bout.reset();
                }
            }
        }

        public void flush() throws IOException {
            if (MultiplexerOutputStream.this.ioexception != null) {
                throw MultiplexerOutputStream.this.ioexception;
            }
            this.writeChunk();
            MultiplexerOutputStream.this.outstream.flush();
        }

        public void write(byte[] b) throws IOException {
            if (MultiplexerOutputStream.this.ioexception != null) {
                throw MultiplexerOutputStream.this.ioexception;
            }
            this.bout.write(b);
            if (this.bout.size() > 1024) {
                this.flush();
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (MultiplexerOutputStream.this.ioexception != null) {
                throw MultiplexerOutputStream.this.ioexception;
            }
            this.bout.write(b, off, len);
            if (this.bout.size() > 1024) {
                this.flush();
            }
        }

        public void write(int b) throws IOException {
            if (MultiplexerOutputStream.this.ioexception != null) {
                throw MultiplexerOutputStream.this.ioexception;
            }
            this.bout.write(b);
            if (this.bout.size() > 1024) {
                this.flush();
            }
        }
    }
}

