/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.transport.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.ByteArrayInBuffer;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.ByteArrayOutBuffer;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerInputStream;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerOutputStream;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.CircularObjectBuffer;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.CircularShortBuffer;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.SessionBeginThread;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransport;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class Session {
    private static final boolean DEBUG = false;
    public static final int RESERVED_STREAM_MIN = -84808480;
    public static final int RESERVED_STREAM_MAX = -84808488;
    public static final short DEFAULT_STREAM_INDEX = 0;
    private static final short CONTROL_STREAM_INDEX = 1;
    private static final int DEFAULT_READ_BUFFER_BYTES = 2048;
    private static final int DEFAULT_WRITE_BUFFER_BYTES = 4096;
    private static final int ACK_COUNT = 100;
    private static final int ACK_OFFSET = 99;
    private static final int LOGICAL_CLOCK_MAX = 10000;
    Object finish_LOCK = new Object();
    Object reconnection_LOCK = new Object();
    boolean started = false;
    boolean finished = false;
    boolean multiplexed = true;
    boolean use_acks = false;
    ByteArrayInBuffer bin;
    ByteArrayOutBuffer bout;
    MultiplexerOutputStream outstreams;
    MultiplexerInputStream instreams;
    public SessionTransport transport;
    SessionAddress address;
    ReaderThread reader_thread;
    WriterThread writer_thread;
    long session_id = System.currentTimeMillis();
    long remote_session_id = -1L;
    String session_ids = String.valueOf(this.session_id) + "-(never connected)";
    SecureRandom sr = new SecureRandom();
    Thread begin_thread = null;

    public Session(SessionAddress address, SessionTransport transport) throws Exception {
        this.address = address;
        this.transport = transport;
        this.use_acks = address.getRequiresLinkReconnection();
        this.multiplexed = address.getRequiresMultipleStreams();
        this.bin = new ByteArrayInBuffer();
        this.bout = new ByteArrayOutBuffer();
        if (this.multiplexed) {
            this.instreams = new MultiplexerInputStream(this.bin);
            this.outstreams = new MultiplexerOutputStream(this.bout);
        }
    }

    public String getTransportImplementationName() {
        return this.transport.getClass().getName();
    }

    public void beginNonBlocking() throws Exception {
        this.begin_thread = new SessionBeginThread(this);
        this.begin_thread.start();
    }

    public void waitUntilSessionTransportReady() {
        try {
            this.begin_thread.join();
        }
        catch (Exception exception) {}
    }

    public void waitUntilSessionTransportBound() throws Exception {
        while (this.transport.getActualAddress() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            if (this.begin_thread == null || !(this.begin_thread instanceof SessionBeginThread)) continue;
            SessionBeginThread sbthread = (SessionBeginThread)this.begin_thread;
            if (sbthread.error == null) continue;
            throw sbthread.error;
        }
    }

    public void begin() throws Exception {
        this.begin_thread = Thread.currentThread();
        if (!this.started) {
            this.reader_thread = new ReaderThread();
            this.writer_thread = new WriterThread();
            this.reader_thread.start();
            this.writer_thread.start();
            this.restartTransport(true);
            this.started = true;
        } else {
            this.restartTransport(true);
        }
        this.transport.setSessionAddress(this.transport.getActualAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartTransport(boolean startup) throws Exception {
        if (!this.finished) {
            Object object = this.reconnection_LOCK;
            synchronized (object) {
                boolean connected = false;
                Exception error = null;
                long abort_timeout = System.currentTimeMillis();
                if (this.address.getRequiresLinkReconnection()) {
                    abort_timeout = startup ? (abort_timeout += this.address.getStartupFailureAbortTimeout()) : (abort_timeout += this.address.getReconnectionFailureAbortTimeout());
                }
                do {
                    try {
                        this.transport.tryReconnect();
                        connected = true;
                        if (this.address.getRequiresPassword()) {
                            byte[] challenge_rand = new byte[128];
                            this.sr.nextBytes(challenge_rand);
                            StreamUtils.writeBytes(this.transport.getOutputStream(), challenge_rand);
                            byte[] response_rand = StreamUtils.readNBytes(this.transport.getInputStream(), 1024);
                            MessageDigest digest = MessageDigest.getInstance("MD5");
                            digest.reset();
                            digest.update(response_rand);
                            digest.update(this.address.getPassword().getBytes("UTF8"));
                            StreamUtils.writeBytes(this.transport.getOutputStream(), digest.digest());
                            byte[] challenge_hash = StreamUtils.readNBytes(this.transport.getInputStream(), 1024);
                            digest.reset();
                            digest.update(challenge_rand);
                            digest.update(this.address.getPassword().getBytes("UTF8"));
                            byte[] verify_hash = digest.digest();
                            if (!Arrays.equals(challenge_hash, verify_hash)) {
                                throw new Exception("incorrect session password");
                            }
                        }
                        StreamUtils.writeBoolean(this.transport.getOutputStream(), startup);
                        this.transport.getOutputStream().flush();
                        boolean rstartup = StreamUtils.readBoolean(this.transport.getInputStream());
                        if (rstartup != startup) {
                            if (startup) {
                                throw new IOException("old session tried to connect");
                            }
                            IOException x = new IOException("old session must have died and been replaced");
                            this.end(x);
                            throw x;
                        }
                        if (startup) {
                            StreamUtils.writeLong(this.transport.getOutputStream(), this.session_id);
                            this.transport.getOutputStream().flush();
                            this.remote_session_id = StreamUtils.readLong(this.transport.getInputStream());
                            this.session_ids = String.valueOf(this.session_id) + "-" + this.remote_session_id;
                        } else {
                            StreamUtils.writeLong(this.transport.getOutputStream(), this.session_id);
                            this.transport.getOutputStream().flush();
                            long tmp_session_id = StreamUtils.readLong(this.transport.getInputStream());
                            if (tmp_session_id != this.remote_session_id) {
                                IOException failure = new IOException("Reconnected to incorrect session - sessions out of sync");
                                failure.printStackTrace();
                                this.end(failure);
                                throw failure;
                            }
                        }
                        if (this.use_acks) {
                            StreamUtils.writeShort(this.transport.getOutputStream(), this.reader_thread.logical_clock);
                            this.transport.getOutputStream().flush();
                            short requested_clock = StreamUtils.readShort(this.transport.getInputStream());
                            this.writer_thread.setOutputStream(null);
                            this.writer_thread.setAckStream(null);
                            if (!startup) {
                                this.writer_thread.resendFromClock(requested_clock);
                                this.writer_thread.interrupt();
                            }
                        }
                        if (this.use_acks) {
                            MultiplexerInputStream xin = new MultiplexerInputStream(new BufferedInputStream(this.transport.getInputStream()));
                            MultiplexerOutputStream xout = new MultiplexerOutputStream(new BufferedOutputStream(this.transport.getOutputStream()));
                            this.reader_thread.setAckStream(xout.getOutputStream((short)1));
                            this.writer_thread.setAckStream(xin.getInputStream((short)1));
                            this.reader_thread.setInputStream(xin.getInputStream((short)0));
                            this.writer_thread.setOutputStream(xout.getOutputStream((short)0));
                        } else {
                            this.reader_thread.setInputStream(this.transport.getInputStream());
                            this.writer_thread.setOutputStream(this.transport.getOutputStream());
                        }
                        if (startup) {
                            Logger.info("session connect attempt OK");
                            continue;
                        }
                        Logger.info("session reconnect attempt OK");
                    }
                    catch (Exception e) {
                        if (startup) {
                            Logger.info("session connect attempt failed: " + e);
                        } else {
                            Logger.info("session reconnect attempt failed: " + e);
                        }
                        connected = false;
                        error = e;
                        if (!this.address.getRequiresLinkReconnection()) continue;
                        try {
                            Thread.sleep(1000L + (long)(Math.random() * 500.0));
                        }
                        catch (Exception exception) {}
                    }
                } while (!this.finished && !connected && System.currentTimeMillis() < abort_timeout);
                if (!connected) {
                    IOException failure = startup ? (this.address.getRequiresLinkReconnection() ? new IOException("Session start failed to connect within " + this.address.getStartupFailureAbortTimeout() + "ms: " + error) : new IOException("Session start failed: " + error + " (Address: " + this.address + ")")) : (this.address.getRequiresLinkReconnection() ? new IOException("Failed to reconnect within " + this.address.getStartupFailureAbortTimeout() + "ms: " + error) : new IOException("Failed to reconnect: " + error));
                    this.end(failure);
                    throw failure;
                }
            }
        }
    }

    public void end(long ms_receive, long ms_write) {
        long t = System.currentTimeMillis();
        while (this.reader_thread.last_read + ms_receive > t || this.writer_thread.last_write + ms_write > t) {
            long wait = 200L;
            wait = Math.max(wait, this.reader_thread.last_read + ms_receive - t);
            wait = Math.max(wait, this.writer_thread.last_write + ms_write - t);
            Logger.info("Waiting for read thread to receive nothing for " + ms_receive + " (waiting for " + wait + ")");
            try {
                Thread.sleep(wait);
            }
            catch (Exception exception) {}
            t = System.currentTimeMillis();
        }
        this.end(null);
    }

    public void end() {
        this.end(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end(IOException e) {
        Object object = this.finish_LOCK;
        synchronized (object) {
            if (!this.finished) {
                if (e != null) {
                    Logger.info("session ended: " + e, e);
                    Throwable t = new Throwable("session ended by request of... (see stacktrace)");
                    Logger.info("session end request: " + t, t);
                }
                this.finished = true;
                if (e != null) {
                    this.bin.setClosed(e);
                    this.bout.setClosed(e);
                    if (this.multiplexed && this.instreams != null && this.outstreams != null) {
                        this.instreams.closeAll(e);
                        this.outstreams.closeAll(e);
                    }
                } else {
                    this.bin.setClosed();
                    this.bout.setClosed(new EOFException("session and stream has been closed"));
                    if (this.multiplexed && this.instreams != null && this.outstreams != null) {
                        this.instreams.closeAll();
                        this.outstreams.closeAll(new EOFException("session and stream has been closed"));
                    }
                }
                try {
                    this.writer_thread.setOutputStream(null);
                    this.writer_thread.interrupt();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    this.reader_thread.setInputStream(null);
                    this.reader_thread.interrupt();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.transport.close();
            }
        }
    }

    public boolean supportsMultipleStreams() {
        return this.multiplexed;
    }

    public OutputStream getOutputStream(short n) throws IOException {
        if (this.multiplexed) {
            if (n >= -84808480 && n <= -84808488) {
                throw new IOException("This stream is reserved for control information");
            }
            return this.outstreams.getOutputStream(n);
        }
        if (n != 0) {
            throw new IOException("This session does not support multiple streams");
        }
        return this.bout;
    }

    public InputStream getInputStream(short n) throws IOException {
        if (this.multiplexed) {
            if (n >= -84808480 && n <= -84808488) {
                throw new IOException("This stream is reserved for control information");
            }
            return this.instreams.getInputStream(n);
        }
        if (n != 0) {
            throw new IOException("This session does not support multiple streams");
        }
        return this.bin;
    }

    public boolean isAlive() {
        return this.transport.isAlive();
    }

    public SessionAddress getActualAddress() {
        return this.transport.getActualAddress();
    }

    class ReaderThread
    extends Thread {
        long last_read = System.currentTimeMillis();
        long total_read = 0L;
        InputStream in;
        OutputStream ack_out;
        short logical_clock = 0;

        ReaderThread() {
        }

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setAckStream(OutputStream out) {
            this.ack_out = out;
        }

        private void readPlain() throws EOFException, Exception {
            int n = 0;
            while (n != -1 && !Session.this.finished) {
                byte[] tmp = StreamUtils.readBytes(this.in);
                Session.this.bin.add(tmp);
                this.total_read += (long)tmp.length;
                this.last_read = System.currentTimeMillis();
            }
            if (n == -1) {
                throw new EOFException("end of stream");
            }
        }

        private void readAcked() throws EOFException, Exception {
            while (!Session.this.finished) {
                short clock = StreamUtils.readShort(this.in);
                byte[] dat = StreamUtils.readBytes(this.in);
                if (clock == this.logical_clock) {
                    Session.this.bin.add(dat);
                    this.logical_clock = (short)(this.logical_clock + 1);
                    if (this.logical_clock == 10000) {
                        this.logical_clock = 0;
                    }
                    this.total_read += (long)dat.length;
                    this.last_read = System.currentTimeMillis();
                }
                if (clock % 100 != 0) continue;
                StreamUtils.writeShort(this.ack_out, clock);
                this.ack_out.flush();
            }
        }

        public void run() {
            Exception last_error = null;
            boolean first = true;
            while (!Session.this.finished) {
                try {
                    if (Session.this.use_acks) {
                        if (first) {
                            StreamUtils.writeShort(this.ack_out, (short)0);
                            this.ack_out.flush();
                            first = false;
                        }
                        this.readAcked();
                    } else {
                        this.readPlain();
                    }
                }
                catch (EOFException e) {
                    last_error = e;
                }
                catch (IOException e) {
                    last_error = e;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Exception e) {
                    last_error = e;
                }
                try {
                    if (last_error != null) {
                        if (Session.this.use_acks) {
                            Logger.warning("session " + Session.this.session_ids + " restarting (" + last_error + ") (" + Session.this.getActualAddress() + ")");
                            Session.this.restartTransport(false);
                        } else {
                            Session.this.end();
                        }
                    }
                }
                catch (IOException x) {
                    Logger.warning("session " + Session.this.session_ids + " restart failed (" + x + ") (" + Session.this.getActualAddress() + ")");
                    Session.this.end(x);
                }
                catch (Exception x) {
                    Logger.warning("session " + Session.this.session_ids + " restart failed (" + x + ") (" + Session.this.getActualAddress() + ")");
                    Session.this.end(new IOException(Logger.getStackTrace(x)));
                }
                if (last_error != null && !Session.this.use_acks) {
                    if (last_error instanceof IOException) {
                        Session.this.end(last_error);
                    } else {
                        Session.this.end(new IOException(Logger.getStackTrace(last_error)));
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            Session.this.bin.setClosed();
            Logger.info("session " + Session.this.session_ids + " reader thread finished (" + last_error + ") (" + Session.this.getActualAddress() + ") (" + Session.this.finished + ")");
        }
    }

    class WriterThread
    extends Thread {
        long last_write = System.currentTimeMillis();
        long total_write = 0L;
        OutputStream out;
        InputStream ack_in;
        CircularObjectBuffer resend_buffer = new CircularObjectBuffer(200);
        CircularShortBuffer resend_clock = new CircularShortBuffer(200);
        Short resend_required = null;
        short logical_clock = (short)-1;

        WriterThread() {
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setAckStream(InputStream in) {
            this.ack_in = in;
        }

        public void resendFromClock(short rlogical_clock) {
            this.resend_required = new Short(rlogical_clock);
        }

        private void writePlain() throws Exception {
            while (!Session.this.finished) {
                byte[] dat = Session.this.bout.clearToByteArray(4096);
                if (dat.length <= 0) continue;
                StreamUtils.writeBytes(this.out, dat);
                this.out.flush();
                this.total_write += (long)dat.length;
                this.last_write = System.currentTimeMillis();
            }
        }

        private String printClocks() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.resend_clock.size()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.resend_clock.get(i));
                ++i;
            }
            return sb.toString();
        }

        private void writeAcked() throws Exception {
            while (!Session.this.finished) {
                if (this.resend_required != null) {
                    int i = 0;
                    while (i < this.resend_buffer.size()) {
                        byte[] dat = (byte[])this.resend_buffer.get(i);
                        short clock = this.resend_clock.get(i);
                        StreamUtils.writeShort(this.out, clock);
                        StreamUtils.writeBytes(this.out, dat);
                        this.out.flush();
                        ++i;
                    }
                    this.resend_required = null;
                    continue;
                }
                byte[] dat = Session.this.bout.clearToByteArray(4096);
                if (dat.length <= 0) continue;
                this.logical_clock = (short)(this.logical_clock + 1);
                if (this.logical_clock == 10000) {
                    this.logical_clock = 0;
                }
                this.resend_buffer.add(dat);
                this.resend_clock.add(this.logical_clock);
                StreamUtils.writeShort(this.out, this.logical_clock);
                StreamUtils.writeBytes(this.out, dat);
                this.out.flush();
                while (this.resend_buffer.size() > 199) {
                    short rlogical_clock = StreamUtils.readShort(this.ack_in);
                    int chop = 1 + this.resend_clock.indexOf(rlogical_clock);
                    if (chop == 0) continue;
                    this.resend_clock.discard(this.resend_clock.size() - chop);
                    this.resend_buffer.discard(this.resend_buffer.size() - chop);
                }
                this.total_write += (long)dat.length;
                this.last_write = System.currentTimeMillis();
            }
        }

        public void run() {
            Exception last_error = null;
            while (!Session.this.finished) {
                try {
                    if (Session.this.use_acks) {
                        this.writeAcked();
                    } else {
                        this.writePlain();
                    }
                }
                catch (IOException e) {
                    last_error = e;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Exception e) {
                    last_error = e;
                }
                if (last_error != null && !Session.this.use_acks) {
                    if (last_error instanceof IOException) {
                        Session.this.end(last_error);
                    } else {
                        Session.this.end(new IOException(Logger.getStackTrace(last_error)));
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            Logger.info("session " + Session.this.session_ids + " writer thread finished (" + last_error + ") (" + Session.this.getActualAddress() + ") (" + Session.this.finished + ")");
        }
    }
}

