/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.utils;

import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.XPathAccessible;

public class XNode {
    public String name;
    public XPathAccessible value;
    public XNode parent;
    public Object[] container;
    public int containerIndex;

    public XNode(String name, Object value, Object[] container, int containerIndex, XNode parent) {
        this.name = name;
        this.value = (XPathAccessible)value;
        this.parent = parent;
        this.container = container;
        this.containerIndex = containerIndex;
    }

    public XNode getParent() {
        return this.parent;
    }

    public XPathAccessible getValue() {
        return this.value;
    }

    public void setValueInContainer(Object o) throws Exception {
        this.setValueInContainer(o, false);
    }

    public void setValueInContainer(Object o, boolean ignoreNoContainer) throws Exception {
        try {
            this.value = (XPathAccessible)o;
            if (!ignoreNoContainer || this.container != null) {
                this.container[this.containerIndex] = o;
            }
        }
        catch (ArrayStoreException e) {
            Logger.error("Tried to set element in array of type " + this.container.getClass().getName() + " to object of type " + o.getClass().getName(), e);
        }
    }

    public String toString() {
        return this.value.toXpathStringValue();
    }

    public void toString(StringBuffer sb) {
        this.value.appendXpathStringValue(sb);
    }
}

