/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageReader;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageWriter;
import org.eclipse.stp.b2j.core.misc.internal.HexData;

public class JARDependency {
    private byte[] jar_dat;
    private String path;
    private String name;
    private boolean enabled = true;
    private String[] namespaces = null;
    private String plugin_name = null;

    private JARDependency() {
    }

    public JARDependency(byte[] dat, String path) {
        this.jar_dat = dat;
        this.path = path;
        this.name = path.substring(Math.max(path.lastIndexOf(47), path.lastIndexOf(92)) + 1);
    }

    public void setFilePath(String path) {
        this.path = path;
        this.name = path.substring(Math.max(path.lastIndexOf(47), path.lastIndexOf(92)) + 1);
    }

    public String getFilePath() {
        return this.path;
    }

    public String getFileName() {
        return this.name;
    }

    public byte[] getJarData() {
        return this.jar_dat;
    }

    public void setPluginName(String name) {
        this.plugin_name = name;
    }

    public String getPluginName() {
        return this.plugin_name;
    }

    public void setAssociatedNamespaces(String[] namespaces) {
        this.namespaces = namespaces;
    }

    public String[] getAssociatedNamespaces() {
        return this.namespaces;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public static String toHex(JARDependency j) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        MessageWriter mwrite = new MessageWriter(bout);
        mwrite.write(JARDependency.toMessage(j));
        return HexData.byteArrayToHexString(bout.toByteArray());
    }

    public static JARDependency fromHex(String s) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(HexData.hexStringToByteArray(s));
        MessageReader mread = new MessageReader(bin);
        Message m = mread.read();
        return JARDependency.fromMessage(m);
    }

    public static Message toMessage(JARDependency j) {
        Message m = new Message();
        m.append(j.jar_dat);
        m.append(j.path);
        m.append(j.name);
        if (j.enabled) {
            m.append(1);
        } else {
            m.append(0);
        }
        return m;
    }

    public static JARDependency fromMessage(Message m) {
        JARDependency j = new JARDependency();
        j.jar_dat = (byte[])m.get(0);
        j.path = (String)m.get(1);
        j.name = (String)m.get(2);
        if (m.length() > 3) {
            j.enabled = (Integer)m.get(3) == 1;
        }
        return j;
    }

    public static JARDependency writeTemporaryDependency(JARDependency dep) throws IOException {
        File tmpjar = File.createTempFile("B2jEngineDependency_", ".jar");
        FileOutputStream fout = new FileOutputStream(tmpjar);
        fout.write(dep.jar_dat);
        fout.flush();
        fout.close();
        tmpjar.deleteOnExit();
        dep.path = tmpjar.getCanonicalPath();
        return dep;
    }
}

