/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.ui.internal.debug;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.ui.internal.debug.ControllerStreamsProxy;

public class ControllerDebugProcess
implements IProcess {
    ControllerInterface engine;
    String engine_name;
    public ILaunch launch;
    public ControllerStreamsProxy streams_proxy;
    boolean terminated = false;

    public ControllerDebugProcess(ILaunch launch, ControllerInterface controller, String engine_name) {
        this.launch = launch;
        this.engine = controller;
        this.engine_name = engine_name;
        this.streams_proxy = new ControllerStreamsProxy(controller);
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        System.err.println("getStreamsProxy");
        return this.streams_proxy;
    }

    public boolean canTerminate() {
        return true;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
        this.terminated = true;
        try {
            this.engine.terminate();
        }
        catch (Exception e) {
            throw new DebugException((IStatus)new Status(4, B2jPlugin.getDefault().getBundle().getSymbolicName(), 5010, "Failed to terminate engine", (Throwable)e));
        }
    }

    public int getExitValue() {
        return 0;
    }

    public String getLabel() {
        return this.engine_name;
    }

    public void setAttribute(String name, String value) {
    }

    public String getAttribute(String name) {
        if (name.equals(IProcess.ATTR_CMDLINE)) {
            return "";
        }
        if (name.equals(IProcess.ATTR_PROCESS_LABEL)) {
            return this.engine_name;
        }
        if (name.equals(IProcess.ATTR_PROCESS_TYPE)) {
            return "b2j engine";
        }
        return "";
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

