/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.ui.internal.debug;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedHashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.ui.internal.debug.ControllerDebugElement;
import org.eclipse.stp.b2j.core.ui.internal.debug.ControllerDebugProcess;
import org.eclipse.stp.b2j.core.ui.internal.debug.ControllerStackTracker;
import org.eclipse.stp.b2j.core.ui.internal.debug.DebugUtils;
import org.eclipse.stp.b2j.core.ui.internal.debug.RunnerDebugThread;

public class ControllerDebugTarget
extends ControllerDebugElement
implements IDebugTarget {
    public ControllerInterface engine;
    public String engine_name;
    public ControllerDebugProcess process;
    public ControllerStackTracker stack_tracker;
    public ILaunch launch;
    HashMap threadIds = new HashMap();
    public IThread[] threads = new IThread[0];

    public ControllerDebugTarget(ILaunch launch, ControllerInterface controller, String engine_name) {
        super(null);
        this.launch = launch;
        this.engine = controller;
        this.engine_name = engine_name;
        this.stack_tracker = new ControllerStackTracker(controller);
        this.process = new ControllerDebugProcess(launch, controller, engine_name);
        try {
            this.getThreadMap();
            this.getSuspendVariable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DebugUtils.fireCreationEvent((Object)this);
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    private SharedHashMap getThreadMap() throws Exception {
        SharedHashMap map = this.engine.newHashMap("BPEL_THREADS_MAP");
        return map;
    }

    private SharedVariable getSuspendVariable() throws Exception {
        SharedVariable var = this.engine.newVariable("BPEL_BREAKPOINT_VAR", 0, true);
        return var;
    }

    public IProcess getProcess() {
        System.err.println("getProcess()");
        return this.process;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public String getName() throws DebugException {
        return this.engine_name;
    }

    public boolean canTerminate() {
        return this.process.canTerminate();
    }

    public boolean isTerminated() {
        return this.process.isTerminated();
    }

    public void terminate() throws DebugException {
        this.process.terminate();
    }

    public IThread[] getThreads() throws DebugException {
        if (this.isTerminated()) {
            return new IThread[0];
        }
        System.err.println("getThreads()");
        try {
            System.err.println("GETTING THREADS FROM ENGINE");
            SharedHashMap map = this.getThreadMap();
            Object[] keys = map.getKeys();
            Arrays.sort(keys);
            IThread[] tmp = new IThread[keys.length];
            int i = 0;
            while (i < tmp.length) {
                tmp[i] = new RunnerDebugThread(this, this.engine, this.stack_tracker, (String)keys[i]);
                ++i;
            }
            this.threads = tmp;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        System.err.println("hasThreads() - true");
        return true;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        System.err.println("supportsBreakpoint() - false");
        return false;
    }

    public boolean canResume() {
        System.err.println("canResume()");
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated();
    }

    public boolean isSuspended() {
        if (this.isTerminated()) {
            return false;
        }
        System.err.println("isSuspended()");
        try {
            SharedVariable var = this.getSuspendVariable();
            var.varFetch();
            return var.getValueInt() == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void resume() throws DebugException {
        try {
            System.err.println("resume()");
            SharedVariable var = this.getSuspendVariable();
            var.setValue(0);
            var.varStore();
        }
        catch (Exception exception) {}
        DebugUtils.fireResumeEvent((Object)this, 32);
    }

    public void suspend() throws DebugException {
        try {
            System.err.println("suspend()");
            SharedVariable var = this.getSuspendVariable();
            var.setValue(1);
            var.varStore();
            this.engine.doRunnerStackTrace(-558440778);
            System.err.println("REQUESTED RUNNER STACK TRACE FROM ENGINE");
        }
        catch (Exception exception) {}
        DebugUtils.fireSuspendEvent((Object)this, 32);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }
}

