/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.ui.internal.debug;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.ui.internal.debug.ControllerDebugElement;
import org.eclipse.stp.b2j.core.ui.internal.debug.ControllerDebugTarget;
import org.eclipse.stp.b2j.core.ui.internal.debug.ControllerStackTracker;
import org.eclipse.stp.b2j.core.ui.internal.debug.RunnerStackFrame;

public class RunnerDebugThread
extends ControllerDebugElement
implements IThread {
    ControllerInterface engine;
    ControllerStackTracker stacks;
    ControllerDebugTarget target;
    String threadId;
    IStackFrame[] stackframes = new IStackFrame[0];

    public RunnerDebugThread(ControllerDebugTarget target, ControllerInterface engine, ControllerStackTracker stacks, String threadId) {
        super(target);
        this.target = target;
        this.engine = engine;
        this.stacks = stacks;
        this.threadId = threadId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        return o instanceof RunnerDebugThread && ((RunnerDebugThread)((Object)o)).threadId.equals(this.threadId);
    }

    public String getName() throws DebugException {
        return this.threadId;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.getDebugTarget().isSuspended();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        try {
            System.err.println("GET STACKFRAMES!");
            Message stack = this.stacks.getStack(this.threadId);
            if (stack == null) {
                return this.stackframes;
            }
            System.err.println("STACKFRAMES:");
            ArrayList<RunnerStackFrame> frames = new ArrayList<RunnerStackFrame>();
            RunnerStackFrame curr_frame = null;
            int i = 0;
            while (i < stack.length()) {
                Object o = stack.get(i);
                if (o instanceof String) {
                    if (curr_frame != null) {
                        frames.add(curr_frame);
                    }
                    curr_frame = new RunnerStackFrame(curr_frame, this, (String)o);
                    System.err.println("STACKFRAME:" + curr_frame.getName());
                } else if (curr_frame != null) {
                    curr_frame.addFrameMessage((Message)o);
                }
                ++i;
            }
            if (curr_frame != null) {
                frames.add(curr_frame);
            }
            IStackFrame[] tmp = new IStackFrame[frames.size()];
            frames.toArray(tmp);
            this.stackframes = tmp;
            return this.stackframes;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        try {
            System.err.println("GET TOP STACKFRAME!");
            if (this.stackframes == null) {
                this.getStackFrames();
            } else if (this.stackframes.length == 0) {
                this.getStackFrames();
            }
            if (this.stackframes.length > 0) {
                System.err.println("TOP STACKFRAME: " + this.stackframes[0]);
                return this.stackframes[0];
            }
            System.err.println("TOP STACKFRAME: NULL!");
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public boolean canResume() {
        return this.getDebugTarget().canResume();
    }

    public boolean canSuspend() {
        return this.getDebugTarget().canSuspend();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public String getModelIdentifier() {
        return "org.eclipse.tptp.choregraphy.debug.model";
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ((Object)((Object)this)).getClass()) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
    }

    public void stepOver() throws DebugException {
    }

    public void stepReturn() throws DebugException {
    }
}

