/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.ui.internal.debug;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.ui.internal.debug.ControllerDebugElement;
import org.eclipse.stp.b2j.core.ui.internal.debug.ControllerDebugTarget;
import org.eclipse.stp.b2j.core.ui.internal.debug.RunnerDebugVariable;

public class RunnerDebugVariableValue
extends ControllerDebugElement
implements IValue {
    Message value;
    String type;
    String xml;
    ArrayList variables = new ArrayList();

    public RunnerDebugVariableValue(RunnerDebugVariable var, Message value) {
        super((ControllerDebugTarget)var.getDebugTarget());
        this.value = value;
        this.type = (String)value.get(0);
        this.type = this.type.substring(this.type.indexOf("xmlns.") + "xmlns.".length());
        this.xml = this.parse(value);
    }

    private String parse(Message value) {
        int i;
        int len;
        StringBuffer sb = new StringBuffer();
        int index = 0;
        String type = (String)value.get(index++);
        String classname = type.substring(type.lastIndexOf(46) + 1 + NamespaceTranslator.getJavaClassName("").length());
        int n = ++index;
        ++index;
        String tag = (String)value.get(n);
        if (tag == null) {
            tag = classname;
        }
        if (tag.equals("null")) {
            tag = classname;
        }
        sb.append("<");
        sb.append(tag);
        if (String.valueOf(value.get(index)).equalsIgnoreCase("ATTRIBUTES")) {
            int n2 = ++index;
            ++index;
            len = (Integer)value.get(n2);
            i = 0;
            while (i < len * 2) {
                String name = (String)value.get(index++);
                Message attrvalue = (Message)value.get(index++);
                sb.append(" " + name + "=\"");
                sb.append(this.parse(attrvalue));
                sb.append("\"");
                i += 2;
            }
        }
        sb.append(">");
        if (String.valueOf(value.get(index)).equalsIgnoreCase("ELEMENTS")) {
            int n3 = ++index;
            ++index;
            len = (Integer)value.get(n3);
            i = 0;
            while (i < len) {
                Message elemvalue = (Message)value.get(index++);
                sb.append(this.parse(elemvalue));
                ++i;
            }
        }
        if (String.valueOf(value.get(index)).equalsIgnoreCase("VALUE")) {
            int n4 = ++index;
            ++index;
            sb.append(String.valueOf(value.get(n4)));
        }
        sb.append("</");
        sb.append(tag);
        sb.append(">");
        this.xml = sb.toString();
        return this.xml;
    }

    public String getReferenceTypeName() throws DebugException {
        return "unknown";
    }

    public String getValueString() throws DebugException {
        return this.xml;
    }

    public boolean isAllocated() throws DebugException {
        return false;
    }

    public IVariable[] getVariables() throws DebugException {
        IVariable[] vars = new IVariable[this.variables.size()];
        this.variables.toArray(vars);
        return vars;
    }

    public boolean hasVariables() throws DebugException {
        return this.variables.size() > 0;
    }
}

