/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.xpath.internal;

import java.util.ArrayList;
import org.eclipse.stp.b2j.core.xpath.internal.XPathVisitor;

public class XPathVisitorAdapter
extends XPathVisitor {
    public XPathVisitorAdapter() {
    }

    public XPathVisitorAdapter(boolean debug) {
        super(debug);
    }

    public void processNumber() {
        String num = (String)this.pop();
        if (this.debug) {
            System.out.println("PROCESS NUMBER " + num);
        }
        this.push(new Double(num));
    }

    public void processLiteral() {
        String lit = (String)this.pop();
        lit = lit.substring(1, lit.length() - 1);
        if (this.debug) {
            System.out.println("PROCESS LITERAL " + lit);
        }
        this.push(lit);
    }

    public void processSlash() {
        String op = (String)this.pop();
        if (this.debug) {
            System.out.println("PROCESS SLASH " + op);
        }
        this.push(op);
    }

    public void processAbsoluteSlash() {
        String slash = (String)this.pop();
        if (this.debug) {
            System.out.println("PROCESS ABSOLUTE SLASH " + slash);
        }
        this.push(slash);
    }

    public void setContextNode() {
    }

    public void prePredicateEval() {
    }

    public void postPredicateEval() {
    }

    public void evaluateNodeTypeTest() {
        Object closeb = this.pop();
        Object openb = this.pop();
        Object nodetype = this.pop();
        if (this.debug) {
            System.out.println("NODE TYPE TEST " + nodetype + "()");
        }
        this.push("" + nodetype + openb + closeb);
    }

    public void evaluateAdditiveExpr() {
        Object expression2 = this.pop();
        Object op = this.pop();
        Object expression1 = this.pop();
        if (this.debug) {
            System.out.println("ADDITIVE EXPR " + expression1 + op + expression2);
        }
        this.push("" + expression1 + op + expression2);
    }

    public void evaluateMultiplicativeExpr() {
        Object expression2 = this.pop();
        Object op = this.pop();
        Object expression1 = this.pop();
        if (this.debug) {
            System.out.println("MULTIPLICATIVE EXP | " + expression1 + op + expression2);
        }
        this.push("" + expression1 + op + expression2);
    }

    public void evaluateUnaryExpr() {
        Object expression = this.pop();
        Object minus = this.pop();
        if (this.debug) {
            System.out.println("UNARY EXPR | " + minus + expression);
        }
        this.push("" + minus + expression);
    }

    public void evaluateRelationalExpr() {
        Object expression2 = this.pop();
        Object op = this.pop();
        Object expression1 = this.pop();
        if (this.debug) {
            System.out.println("RELATIONAL EXPR | " + expression1 + op + expression2);
        }
        this.push("" + expression1 + op + expression2);
    }

    public void evaluateEqualityExpr() {
        Object expression2 = this.pop();
        Object op = this.pop();
        Object expression1 = this.pop();
        if (this.debug) {
            System.out.println("EQUALITY EXPR | " + expression1 + op + expression2);
        }
        this.push("" + expression1 + op + expression2);
    }

    public void evaluateAndExpr() {
        Object expression2 = this.pop();
        Object op = this.pop();
        Object expression1 = this.pop();
        if (this.debug) {
            System.out.println("AND EXPR | " + expression1 + op + expression2);
        }
        this.push("" + expression1 + op + expression2);
    }

    public void evaluateOrExpr() {
        Object expression2 = this.pop();
        Object op = this.pop();
        Object expression1 = this.pop();
        if (this.debug) {
            System.out.println("OR EXPR | " + expression1 + op + expression2);
        }
        this.push("" + expression1 + op + expression2);
    }

    public void evaluateRelativePathPattern() {
        Object pattern2 = this.pop();
        Object op = this.pop();
        Object pattern1 = this.pop();
        if (this.debug) {
            System.out.println("REL. PATH. PAT | " + pattern1 + op + pattern2);
        }
        this.push("" + pattern1 + op + pattern2);
    }

    public void evaluateRelativeLocationPath() {
        Object path2 = this.pop();
        Object op = this.pop();
        Object path1 = this.pop();
        if (this.debug) {
            System.out.println("REL. LOC. PATH | " + path1 + op + path2);
        }
        this.push("" + path1 + op + path2);
    }

    public void evaluateStepPredicate() {
        int i;
        String s;
        Object temp;
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (this.peek() instanceof String) {
            temp = (String)this.peek();
            while (temp != null && temp instanceof String && ((String)temp).equals("]")) {
                this.pop();
                Object predicate = this.pop();
                predicates.add(0, predicate);
                this.pop();
                if (!(this.peek() instanceof String)) break;
                temp = (String)this.peek();
            }
        }
        Object node = this.pop();
        String axis = "";
        temp = this.peek();
        if (temp != null && temp instanceof String) {
            axis = (String)temp;
            axis = axis.equals("@") || axis.endsWith("::") ? (String)this.pop() : "";
        }
        if (this.debug) {
            s = String.valueOf(axis) + node;
            i = 0;
            while (i < predicates.size()) {
                s = String.valueOf(s) + "[" + predicates.get(i) + "]";
                ++i;
            }
            System.out.println("STEP PRED | " + s);
        }
        s = String.valueOf(axis) + node;
        i = 0;
        while (i < predicates.size()) {
            s = String.valueOf(s) + "[" + predicates.get(i) + "]";
            ++i;
        }
        System.out.println("STEP PRED | " + s);
        this.push(s);
    }

    public void evaluateQName() {
        Object name2 = this.pop();
        Object name1 = this.pop();
        if (this.debug) {
            System.out.println("QNAME | " + name1 + ":" + name2);
        }
        this.push(name1 + ":" + name2);
    }

    public void evaluateQNameWONodeType() {
        String name2 = (String)this.pop();
        String name1 = (String)this.pop();
        if (this.debug) {
            System.out.println("QNAME WO NODE | " + name1 + ":" + name2);
        }
        this.push(name1 + ":" + name2);
    }

    public void evaluatePattern() {
        Object path2 = this.pop();
        Object op = this.pop();
        Object path1 = this.pop();
        if (this.debug) {
            System.out.println("PATTERN | " + path1 + op + path2);
        }
        this.push("" + path1 + op + path2);
    }

    public void evaluateLocationPathPattern() {
        Object temp = this.peek();
        Object path = null;
        Object slash = null;
        if (temp instanceof String) {
            String tempString = (String)temp;
            if (tempString.equals("/")) {
                path = null;
                slash = this.pop();
            } else {
                path = this.pop();
                slash = this.pop();
            }
        }
        if (this.debug) {
            if (path == null) {
                System.out.println("LOC. PATH. PATT | " + slash);
            } else {
                System.out.println("LOC. PATH. PATT | " + slash + path);
            }
        }
        if (path != null) {
            this.push("" + slash + path);
        } else {
            this.push("" + slash);
        }
    }

    public void evaluateLocationIDPathPattern() {
        String tempString;
        Object path = null;
        Object op = null;
        Object temp = this.peek();
        if (!(!(temp instanceof String) || (tempString = (String)temp).equals("//") && tempString.equals("/"))) {
            path = this.pop();
            op = this.pop();
        }
        Object id = this.pop();
        if (this.debug) {
            System.out.println("LOCATIONIDPATHPATTERN | " + id + " " + op + " " + path);
        }
        this.push(id + " " + op + " " + path);
    }

    public void evaluateLocationRelPathPattern() {
        Object path = this.pop();
        Object op = this.pop();
        if (this.debug) {
            System.out.println("LOC. REL. PATH PATTERN | " + op + path);
        }
        this.push("" + op + path);
    }

    public void evaluateSingleIDKeyPattern() {
        Object closebracket = this.pop();
        Object literal = this.pop();
        Object openbracket = this.pop();
        Object id = this.pop();
        if (this.debug) {
            System.out.println("EVALUATESINGLEIDKEYPATTERN | " + id + openbracket + literal + closebracket);
        }
        this.push("" + id + openbracket + literal + closebracket);
    }

    public void evaluateDoubleIDKeyPattern() {
        Object closeb = this.pop();
        Object literal2 = this.pop();
        Object comma = this.pop();
        Object literal1 = this.pop();
        Object openb = this.pop();
        Object id = this.pop();
        if (this.debug) {
            System.out.println("DOUBLEIDKEYPATTERN | " + id + openb + literal1 + comma + literal2 + closeb);
        }
        this.push("" + id + openb + literal1 + comma + literal2 + closeb);
    }

    public void evaluateVariableReference() {
        Object qname = this.pop();
        Object var = this.pop();
        if (this.debug) {
            System.out.println("VARIABLE REF | " + qname + " " + var);
        }
        this.push(qname + " " + var);
    }

    public void evaluateWildCardQName() {
    }

    public void evaluateWildCardStar() {
        if (this.debug) {
            System.out.println("*");
        }
        this.push("*");
    }

    public void evaluateWildCardNCName() {
        Object name = this.pop();
        if (this.debug) {
            System.out.print("WILDCARD NC NAME | " + name + ":" + "*");
        }
        this.push(name + ":" + "*");
    }

    public void evaluatePrimaryFilterExpr() {
        Object primaryExpression = this.pop();
        if (this.debug) {
            System.out.println("PRIMARY EXPR | " + primaryExpression);
        }
        this.push(primaryExpression);
    }

    public void evaluatePathExpr() {
        Object relativeLocPath = this.pop();
        Object op = this.pop();
        Object filterExp = this.pop();
        if (this.debug) {
            System.out.println("PATH EXPR | " + filterExp + op + relativeLocPath);
        }
        this.push("" + filterExp + op + relativeLocPath);
    }

    public void evaluateUnionExpr() {
        Object path2 = this.pop();
        Object op = this.pop();
        Object path1 = this.pop();
        if (this.debug) {
            System.out.println("UNION EXPR | " + path1 + op + path2);
        }
        this.push("" + path1 + op + path2);
    }

    public void evaluateFunctionCall() {
        int i;
        String s;
        ArrayList<Object> arglist = new ArrayList<Object>();
        this.pop();
        this.pop();
        Object arg = this.pop();
        String argString = arg instanceof String ? (String)arg : null;
        while (argString == null || !argString.equals("(")) {
            arglist.add(arg);
            arg = this.pop();
            argString = arg instanceof String ? (String)arg : null;
        }
        Object functionName = this.pop();
        if (this.debug) {
            s = functionName + "(";
            i = 0;
            while (i < arglist.size()) {
                s = i == 0 ? String.valueOf(s) + arglist.get(i) : String.valueOf(s) + "," + arglist.get(i);
                ++i;
            }
            s = String.valueOf(s) + ")";
            System.out.println("FUNCTION CALL | " + s);
        }
        s = functionName + "(";
        i = 0;
        while (i < arglist.size()) {
            s = i == 0 ? String.valueOf(s) + arglist.get(i) : String.valueOf(s) + "," + arglist.get(i);
            ++i;
        }
        s = String.valueOf(s) + ")";
        System.out.println("FUNCTION CALL | " + s);
        this.push(s);
    }

    public void evaluateAbsoluteLocationPath() {
        String tempString = null;
        Object temp = this.peek();
        Object slash = null;
        Object path = null;
        if (temp instanceof String) {
            tempString = (String)temp;
        }
        if (tempString != null && tempString.equals("/")) {
            slash = this.pop();
        } else {
            path = this.pop();
            slash = this.pop();
        }
        if (this.debug) {
            System.out.println("ABS. LOC. PATH | " + slash + path);
        }
        this.push("" + slash + path);
    }

    public void evaluateProcessingInstruction() {
        this.pop();
        Object literal = this.pop();
        this.pop();
        Object pi = this.pop();
        if (this.debug) {
            System.out.println("PROCESSING INFO | " + pi + "(" + literal + ")");
        }
        this.push(pi + "(" + literal + ")");
    }

    public void evaluateAbbreviatedAbsoluteLocationPath() {
        Object path = this.pop();
        this.pop();
        if (this.debug) {
            System.out.println("ABBREV. ABS. LOC. PATH | //" + path);
        }
        this.push("//" + path);
    }

    public void evaluateAbbreviatedRelativeLocationPath() {
        Object step = this.pop();
        this.pop();
        Object relativeLocPath = this.pop();
        if (this.debug) {
            System.out.println("ABBREV. REL. LOC. PATH | " + relativeLocPath + "//" + step);
        }
        this.push(relativeLocPath + "//" + step);
    }

    public void processAbbreviatedAbsoluteSlash() {
        if (this.debug) {
            System.out.println("PROCESSING ABBREVIATEDABSOLUTESLASH");
        }
    }

    public void processAbbreviatedRelativeSlash() {
        if (this.debug) {
            System.out.println("PROCESSING ABBREVIATEDRELATIVESLASH");
        }
    }

    public void evaluateNameTest() {
        if (this.debug) {
            System.out.println("PROCESSING NAMETEST");
        }
    }

    public void evaluateAxisSpecifier() {
        if (this.debug) {
            System.out.println("PROCESSING AXISSPECIFIER");
        }
    }
}

