/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal;

import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * 
 * @author amiguel
 *
 * This class contains versioning information for the engine.  Whenever the engine is modified this
 * version should be updated so that the engine can auto-update remote Daemons
 */
public class Version {
	private static Message VERSION = new Message();

	static {
		VERSION.append(5); //Major (5 == B2J move)
		VERSION.append(0); //Minor
		VERSION.append(0); //Maintenance
		VERSION.append(0); //Development
	}
	
	public static Message getVersion() {
		return VERSION;
	}

	public static String getVersionAsString() {
		return toString(VERSION);
	}

	public static String toString(Message version) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < version.length(); i++) {
			if (i > 0) {
				sb.append("-");
			}
			sb.append((Integer)version.get(i));
		}
		return sb.toString();
	}
}