/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.api;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.bpel.BPELTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StringBufferTranslatorLog;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingLoader;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslator;
import org.eclipse.stp.b2j.core.publicapi.importresolver.WsdlImportResolver;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.JavaCompiler;

/**
 * 
 * @author amiguel
 *
 * A class to create engine Programs from various sources, such as a set of pre compiled java Class files
 * or a set of BPEL, WSDL and XSD files
 */
public class BpelProgramFactory {

	private static Object LOCK = new Object();
	private static int INSTANCE_ID = 1;
	
	/**
	 * Create a new engine Program from a BPEL source file
	 * @param debug whether this should be a debug translation of the BPEL source file
	 * @param base_uri the base URI of the BPEL source file
	 * @param bpel_source the BPEL source file
	 * @param deps any JAR dependencies which the program needs
	 * @return the engine Program representing the source BPEL file
	 * @throws Exception if an error occurs while translating the BPEL source file
	 */
	public static Program createEngineProgramFromBpelSource(boolean debug, Switches switches, JavaCompiler jcompiler, WsdlImportResolver iresolver, String base_uri, String bpel_source, JARDependency[] deps, TranslatorLog log, boolean validateOnly) throws Exception {
		if (log == null) log = new StringBufferTranslatorLog();
		
		if (switches == null) {
			switches = new Switches();
		}
		
		String program_prefix;
		
		synchronized(LOCK) {

			program_prefix = "bpel_"+INSTANCE_ID+"_"+System.currentTimeMillis()+".";
			
			INSTANCE_ID++;
			try {
				Thread.sleep(11);
			} catch(Exception e) {
			}
		}
		
		BPELTranslator bt = new BPELTranslator(program_prefix,switches);
		
		WSDLBindingTranslator[] bindings = WSDLBindingLoader.getBindingsUnfiltered();
		for (int i = 0; i < bindings.length; i++) {
			System.out.println("\tBinding: "+bindings[i].getClass().getName());
		}
		
		Program engineprog = bt.getProgram(debug,bpel_source,base_uri,jcompiler,iresolver,deps,bindings,log,validateOnly);
		
		return engineprog;
	}		
}