/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.api;

import java.io.File;
import java.io.FileInputStream;

import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.DaemonInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedSemaphore;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SoapDaemon;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

/**
 * 
 * @author amiguel
 *
 * A simple class to test the engine based on a souce Program file
 */
public class Test implements TraceListener {

boolean SHOW_PRINTS = true;
boolean SHOW_THROUGHPUT = true;
int TRACES_PER_USER = 2;

public static void main(String[] args) {
	Test t = new Test(args);
}

public Test(String[] args) {

//GCThread.startThread();

Runtime runtime = Runtime.getRuntime();
System.out.println(runtime.totalMemory()+" "+(runtime.totalMemory()-runtime.freeMemory()));
	System.out.println("Java Engine Test");
	
	if (args.length < 1) {
		System.out.println("Usage: Test <program source file>");
		System.exit(1);	
	}
	
	try {
		FileInputStream fin = new FileInputStream(args[0]);
	
		//
		// Get the program
		//
		System.out.println("Getting program");
//		Program p = new Program(fin);
		Program p = null;	
		fin.close();
		SessionAddress addr = new SessionAddress("localhost",SessionAddress.TRANSPORT_PORT_ANY,SessionAddress.TRANSPORT_PORT_ANY,"localhost",SoapDaemon.DAEMON_PORT,SoapDaemon.DAEMON_PORT);
		p.addHostAddress(addr,addr);	
//		p.addHost("sif");	
	
		//
		// Start a SoapDaemon (should be started from command line really)
		//
		System.out.println("Starting a SoapDaemon");
		SoapDaemon d = new SoapDaemon(new File("."),new File("./b2j.jar"),SoapDaemon.DAEMON_PORT);
		
		//
		// Connect to the daemon
		//
		System.out.println("Connecting to daemon");
		DaemonInterface dcon = EngineFactory.connectToMainEngineDaemon(new SessionAddress("localhost",SessionAddress.TRANSPORT_PORT_ANY,SessionAddress.TRANSPORT_PORT_ANY,"localhost",SoapDaemon.DAEMON_PORT,SoapDaemon.DAEMON_PORT));
		
		//
		// Get an engine instance
		//
		System.out.println("Creating a new engine");
		ControllerInterface ccon = dcon.newEngine("My Engine "+System.currentTimeMillis(), this, new JARDependency[0],addr);
		
		//
		// Run the program
		//
		System.out.println("Running the program");
		ccon.setProgram(p);
		ccon.launchRunner(1,"engine_main",0);

		System.out.println("Program launched!");
		
		SharedVariable runmult = null;
		SharedSemaphore usercount = null;		
		
		while (true) {
			try {
				Thread.sleep(1000);
				runmult = ccon.getVariable("run_multiplier");
				usercount = ccon.getSemaphore("usercount");
				break;
			} catch (Exception e) {

			}	
		}
		
		try {
			runmult.varFetch();
		
			System.out.println("RUN MULTIPLIER = "+runmult);
			System.out.println("USERCOUNT = "+usercount);
		
			usercount.semSignal(1000);
			System.out.println("Usercount 100, run multiplier 1");

			Thread.sleep(20000);
			System.out.println("Usercount 100, run multiplier 10");
			runmult.setValue(10);
			runmult.varStore();
		
		} catch (Exception e) {
			e.printStackTrace();	
		}
		
//		Thread.sleep(10000);
	} catch (Throwable t) {
		t.printStackTrace();
	}


//	System.exit(0);
}

//throughput test
long l = System.currentTimeMillis();
double n = 0;
public void trace(Message trace) {
	if (SHOW_THROUGHPUT) {
		if (System.currentTimeMillis() > l) {
			n = n/2;
			n = n/TRACES_PER_USER;
			System.out.println(n);
			l = System.currentTimeMillis()+2000;
			n = 0;
		}	
		n++;
	}

}

public void print(String msg) {
	if (SHOW_PRINTS) {
		if (msg.endsWith("\n")) {
			System.out.print("ENGINE:"+msg);
		} else {
			System.out.println("ENGINE:"+msg);
		}
	}
}
public void debug(String msg) {
	if (SHOW_PRINTS) {
		if (msg.endsWith("\n")) {
			System.out.print("ENGINE DEBUG:"+msg);
		} else {
			System.out.println("ENGINE DEBUG:"+msg);
		}
	}
}
	
}