/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.bpel;

import java.io.PrintStream;
import java.io.PrintWriter;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.w3c.dom.Node;

/**
 * 
 * @author amiguel
 *
 * An exception that may be thrown by the BPELTranslator class.
 * Contains a reference to the XML node that the exception was thrown as
 * a result of.
 */
public class BPELTranslatorException extends Exception {
Exception e;
	public BPELTranslatorException(Util compiler_util, Node current, Exception e) {
		super(compiler_util.getBpelLineNumberString(current)+" "+compiler_util.getBpelStackTraceString(current)+" "+e.getMessage());
		this.e = e;
	}
	public BPELTranslatorException(Util compiler_util, Node current, String msg) {
		super(compiler_util.getBpelLineNumberString(current)+" "+compiler_util.getBpelStackTraceString(current)+" "+msg);
	}	
	public void printStackTrace() {
		if (e != null) {
			System.err.println(getMessage());
			e.printStackTrace();
		} else {
			super.printStackTrace();
		}
	}
	public void printStackTrace(PrintStream s) {
		if (e != null) {
			s.println(getMessage());
			e.printStackTrace(s);
		} else {
			super.printStackTrace(s);
		}
	}
	public void printStackTrace(PrintWriter s) {
		if (e != null) {
			s.println(getMessage());
			e.printStackTrace(s);
		} else {
			super.printStackTrace(s);
		}
	}
	
	public String toString() {
		if (e != null) {
			return getMessage()+": "+e;
		} else {
			return super.toString();
		}
	}
}