/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.locks;

import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.bpel.BPELTranslatorException;
import org.w3c.dom.Node;

public class LockModel {
	
	LockObject root = null;
	
	LockObject curr = null;
	
	HashMap syncMap = new HashMap();
	
	public LockModel(String rootThreadName) {
		LockFlow flow = new LockFlow(null);
		LockThread thread = new LockThread(flow,rootThreadName);
		
		flow.add(thread);
		
		root = flow;
		curr = thread;
	}
	
	private void push(LockObject obj) {
		curr.add(obj);
		curr = obj;
	}
	private LockObject pop(Util compiler_util, Node current) throws BPELTranslatorException {
		LockObject tmpcurr = curr;
		curr = curr.getParent();

		if (curr == null) throw new BPELTranslatorException(compiler_util,current,"Popped too many from the LockModel");
		
		return tmpcurr;
	}

	//
	// public
	//
	public void pushNewThreads(Util compiler_util, Node current) throws BPELTranslatorException {
		LockFlow flow = new LockFlow(curr);
		push(flow);
	}
	public void popThreads(Util compiler_util, Node current) throws BPELTranslatorException {
		if (!(pop(compiler_util,current) instanceof LockFlow)) {
			throw new BPELTranslatorException(compiler_util,current,"Expected to pop Threads but got something else instead");
		}
	}
	
	public void pushNewThread(Util compiler_util, Node current, String name) throws BPELTranslatorException {
		if (!(curr instanceof LockFlow)) {
			throw new BPELTranslatorException(compiler_util,current,"Tried to add new thread to something other than flow");
		}
		LockThread thread = new LockThread(curr,name);
		push(thread);
	}
	public void popThread(Util compiler_util, Node current) throws BPELTranslatorException {
		if (!(pop(compiler_util,current) instanceof LockThread)) {
			throw new BPELTranslatorException(compiler_util,current,"Expected to pop Thread but got something else instead");
		}
	}
	public void duplicatePreviousThread(Util compiler_util, Node current) throws BPELTranslatorException {
		LockFlow parent = (LockFlow)curr;
		LockThread prev = (LockThread)parent.getChild(parent.size()-1);
		
		try {
			//duplicate
			prev = (LockThread)prev.cloneDeep();
			prev.name = prev.name+"_dup";
			
			parent.add(prev);
		} catch (CloneNotSupportedException e) {
			throw new BPELTranslatorException(compiler_util,current,e);
		}
	}
	
	public void pushLock(Util compiler_util, Node current, String name) throws BPELTranslatorException {
		LockLock lock = new LockLock(curr,name);
		curr.addLock(lock);
	}
	/*
	public void popLock(Util compiler_util, Node current) throws BPELTranslatorException {
		if (!(pop(compiler_util,current) instanceof LockFlow)) {
			throw new BPELTranslatorException(compiler_util,current,"Expected to pop Lock but got something else instead");
		}
	}
	*/

	public void pushSync(Util compiler_util, Node current, String lockName, String methodAlias, int from, int to) throws BPELTranslatorException {
		//need to insert this sync request
		LockSync sync = new LockSync(curr,lockName,methodAlias,from,to);
		curr.addSync(sync);
		
		syncMap.put(methodAlias,sync);
	}
	
	public LockSync getSyncForMethodAlias(String methodAlias) {
		return (LockSync)syncMap.get(methodAlias);
	}
	/*
	public void popSync(Util compiler_util, Node current) throws BPELTranslatorException {
		if (!(pop(compiler_util,current) instanceof LockSync)) {
			throw new BPELTranslatorException(compiler_util,current,"Expected to pop Sync but got something else instead");
		}
	}
	*/
	public String toString() {
		return "\n"+root.toString(1,true);
	}

	public String toStringNoDisabled() {
		return "\n"+root.toString(1,false);
	}
	
	public LockObject getRoot() {
		return root;
	}
}