/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.locks;

import java.util.ArrayList;
import java.util.HashMap;

public abstract class LockObject implements Cloneable {
	
	LockObject parent;
	ArrayList children = new ArrayList();
	ArrayList locks = new ArrayList();
	
	public LockObject(LockObject parent) {
		this.parent = parent;
	}
	
	public LockThread getParentThread() {
		LockObject tmp = parent;
		while (!(tmp instanceof LockThread)) {
			tmp = tmp.getParent();
		}
		return (LockThread)tmp;
	}
	
	public LockObject getParent() {
		return parent;
	}
	
	public LockObject getChild(int index) {
		return (LockObject)children.get(index);
	}
		
	void add(LockObject obj) {
		children.add(obj);
	}
	
	public void addLock(LockLock lock) {
		locks.add(lock);
	}
	
	public void addSync(LockSync sync) {
		for (int i = 0; i < children.size(); i++) {
			LockObject obj = get(i);
			if (obj instanceof LockSync) {
				LockSync tmp = (LockSync)obj;
				
				if (sync.from < tmp.from) {
					//insert here
					children.add(i,sync);
					return;
				}
			}
		}
		children.add(sync);
	}
	
	public LockObject get(int index) {
		return (LockObject)children.get(index);
	}
	
	public int size() {
		return children.size();
	}
	
	public LockLock getLock(String name) {
		for (int i = 0; i < locks.size(); i++) {
			LockLock tmp = (LockLock)locks.get(i);
			if (tmp.getName().equals(name)) return tmp;
		}
		return null;
	}
	
	public LockObject cloneDeep() throws CloneNotSupportedException {
		LockObject obj = (LockObject)clone();
		
		for (int i = 0; i < obj.children.size(); i++) {
			LockObject tmp = (LockObject)obj.children.get(i);
			tmp = tmp.cloneDeep();
			obj.children.set(i,tmp);
		}
		for (int i = 0; i < obj.locks.size(); i++) {
			LockObject tmp = (LockObject)obj.locks.get(i);
			tmp = tmp.cloneDeep();
			obj.locks.set(i,tmp);
		}
		
		return obj;
	}
	
	public String toString() {
		String name = getClass().getName();
		name = name.substring(name.lastIndexOf(".Lock")+5);
		return name;
	}
	public String toString(int depth, boolean show_disabled) {
//		System.out.println("DEPTH:"+depth);
		StringBuffer sb = new StringBuffer();
		
		for (int d = 0; d < depth; d++) {
			sb.append("  ");
		}
		sb.append(this);
		sb.append("\n");

//System.out.println(hashCode()+": "+sb+" "+getClass());	

		for (int i = 0; i < locks.size(); i++) {
			LockLock obj = (LockLock)locks.get(i);
			if (show_disabled || obj.isEnabled()) {
				sb.append(obj.toString(depth+1,show_disabled));
			}
		}
		
		for (int i = 0; i < children.size(); i++) {
			LockObject obj = (LockObject)children.get(i);
			if (!show_disabled) {
				if (obj instanceof LockSync) {
					LockSync sync = (LockSync)obj;
					if (!sync.isEnabled()) continue;
				}
			}
			sb.append(obj.toString(depth+1,show_disabled));
		}
		
		return sb.toString();
	}
	
	public ArrayList getDeepLockList() {
		ArrayList tmp = new ArrayList();
		tmp.addAll(locks);
		
		for (int i = 0; i < children.size(); i++) {
			LockObject obj = (LockObject)children.get(i);
			tmp.addAll(obj.getDeepLockList());
		}
		
		return tmp;
	}
	public ArrayList getDeepSyncList() {
		ArrayList tmp = new ArrayList();
		for (int i = 0; i < children.size(); i++) {
			LockObject obj = get(i);
			if (obj instanceof LockSync) {
				LockSync sync = (LockSync)obj;
				if (sync.isEnabled()) {
					tmp.add(sync);
				}
			}
		}
		
		for (int i = 0; i < children.size(); i++) {
			LockObject obj = (LockObject)children.get(i);
			tmp.addAll(obj.getDeepSyncList());
		}
		
		return tmp;
	}
	
	public boolean hasLock(String lockName) {
		for (int i = 0; i < locks.size(); i++) {
			LockLock lock = (LockLock)locks.get(i);
			if (lock.getName().equals(lockName)) {
				return true;
			}
				
		}
		return false;
	}
}