/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.locks;

public class LockSync extends LockObject {
	String lockName;
	String methodName;
	int from;
	int to;
	
	public LockSync(LockObject parent, String lockName, String methodName, int from, int to) {
		super(parent);
		
		this.lockName = lockName;
		this.methodName = methodName;
		this.from = from;
		this.to = to;
	}
	
	public boolean isEnabled() {
		LockObject parent = getParent();
		while (parent.getLock(lockName) == null) {
			parent = parent.getParent();
		}
		LockLock lock = parent.getLock(lockName);
		return lock.isEnabled();
	}
	
	public String toString() {
		
		if (isEnabled()) {
			return super.toString()+" ^"+lockName+" "+from+"->"+to;
		} else {
			return super.toString()+" ^"+lockName+" "+from+"->"+to+" DISABLED";
		}
	}
	
	public String getLockName() {
		return lockName;
	}
}