/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap;

import java.util.HashMap;

/**
 * 
 * @author amiguel
 *
 * A class to represent a WSDL operation, used in the translation 
 * of BPEL source files into engine Programs
 */
public class WSDLOperation {
	public static final int TYPE_ONEWAY = 0;
	public static final int TYPE_REQUEST_RESPONSE = 1;
	public static final int TYPE_SOLICIT_RESPONSE = 2;
	public static final int TYPE_NOTIFICATION = 3;
	
	//input->blah:blah, output->blah:blah, faultBlah->blah:blah
	public HashMap message_types = new HashMap();
	public int type;
	
	public int getType() {
		return type;
	}
	public String getMessageType(String name) {
		return (String)message_types.get(name);
	}
}

