/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

import org.eclipse.stp.b2j.core.jengine.internal.utils.TranslatorUtils;
import org.w3c.dom.Node;

/**
 * 
 * @author amiguel
 *
 * An exception that may be thrown as part of translating an XPATH expression
 * into a valid engine Program part
 */
public class XPATHTranslatorException extends Exception {
	Throwable e;
	public XPATHTranslatorException(String str) {
		this(str,new Exception(""));
	}
	public XPATHTranslatorException(String str, Throwable e) {
		super(str);
		this.e = e;
	}

	public void printStackTrace() {
		if (e != null) {
			System.err.println(getMessage());
			e.printStackTrace();
		} else {
			super.printStackTrace();
		}
	}
	public void printStackTrace(PrintStream s) {
		if (e != null) {
			s.println(getMessage());
			e.printStackTrace(s);
		} else {
			super.printStackTrace(s);
		}
	}
	public void printStackTrace(PrintWriter s) {
		if (e != null) {
			s.println(getMessage());
			e.printStackTrace(s);
		} else {
			super.printStackTrace(s);
		}
	}
	
	public String toString() {
		if (e != null) {
			return getMessage()+": "+e;
		} else {
			return super.toString();
		}
	}
	/*	
	public static String getStackTrace(Throwable t) {
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		PrintStream ps = new PrintStream(os);   // printing destination
		t.printStackTrace(ps);
		return os.toString();
	}//end method
	*/
	
	public static XPATHTranslatorException parserError(Throwable parserError, String expression, Node source) {

		if (expression.trim().length() == 0) {
			expression = "(empty expression, node = "+source+")";
		}
		
//		String msg = getStackTrace(parserError);
		return new XPATHTranslatorException(parserError.getMessage()+", EXPRESSION="+TranslatorUtils.toJavaString(expression), parserError);
	}
}