/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * 
 * @author amiguel
 *
 * A class to represent a XSD complex type, used in the translation 
 * of BPEL source files into engine Programs
 */
public class XSDComplexType extends XSDType {
	String name;
	String qtype;
	
	XSDComplexType parent;
	
	ArrayList attributes_list = new ArrayList();
	HashMap attributes_map = new HashMap();
	
	ArrayList elements_list = new ArrayList();
	HashMap elements_map = new HashMap();
	
	void addAttribute(XSDComplexTypeAttribute attr) {
		attributes_list.add(attr);
		attributes_map.put(attr.name,attr);
	}
	void addElement(XSDComplexTypeElement elem) {
		elements_list.add(elem);
		elements_map.put(elem.name,elem);
	}
	
	public String getName() {
		return name;
	}
	public String getQualifiedType() {
		return qtype;
	}
	
	public XSDType getParentType() {
		return parent;
	}
	
	public XSDComplexTypeAttribute getAttribute(String name) {
		XSDComplexTypeAttribute attr = (XSDComplexTypeAttribute)attributes_map.get(name);
		if (attr == null && parent != null) {
			return parent.getAttribute(name);
		} else {
			return null;
		}
	}
	public int getAttributeCount() {
		if (parent != null) {
			return attributes_list.size() + parent.getAttributeCount();
		} else {
			return attributes_list.size();
		}
	}
	public XSDComplexTypeAttribute getAttribute(int index) {
		if (index < attributes_list.size()) {
			return (XSDComplexTypeAttribute)attributes_list.get(index);
		} else if (parent != null) {
			return parent.getAttribute(index - attributes_list.size());
		} else {
			//will fail
			return (XSDComplexTypeAttribute)attributes_list.get(index);
		}
	}
	
	public XSDComplexTypeElement getElement(String name) {
		XSDComplexTypeElement elem = (XSDComplexTypeElement)elements_map.get(name);
		if (elem == null && parent != null) {
			return parent.getElement(name);
		} else {
			return null;
		}
	}
	public int getElementCount() {
		if (parent != null) {
			return elements_list.size() + parent.getElementCount();
		} else {
			return elements_list.size();
		}
	}
	public XSDComplexTypeElement getElement(int index) {
		if (index < elements_list.size()) {
			return (XSDComplexTypeElement)elements_list.get(index);
		} else if (parent != null) {
			return parent.getElement(index - elements_list.size());
		} else {
			//will fail
			return (XSDComplexTypeElement)elements_list.get(index);
		}
	}
}
