/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core.datapool;

import org.eclipse.stp.b2j.core.jengine.internal.core.SubControllerInterface;

/**
 * 
 * @author amiguel
 * 
 * Part of the generic runtime engine API, implements a HashMap which seamlessly
 * shares data across any part of the engine.
 */
public class SharedHashMap {

SubControllerInterface controller;
String name;
int id;
	
	public SharedHashMap(SubControllerInterface controller, String name, int id) {
		this.controller = controller;
		this.name = name;
		this.id = id;
	}

	public String[] getKeys() throws Exception {
		return controller.hashmapGetKeys(id);
	}
	
	public void put(String key, Object value) throws Exception {
		controller.hashmapSet(id,key,value);
	}

	public Object get(String key) throws Exception {
		Object o = controller.hashmapGet(id,key);
		return o;
	}
	
	public void clear() throws Exception {
		controller.hashmapClear(id);	
	}
}