/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.sessiontransport.tcpip;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransport;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

/**
 * 
 * @author amiguel
 *
 * Represents a single instance of a TCPIP implementation of a
 * Session Transport.
 */
public class TCPIPTransport implements SessionTransport {
	private static final long MIN_TIMEOUT = 10000;

	SessionAddress address;
	SessionAddress actual_address;
	
	public boolean initiator;
	
	public InputStream in;
	public OutputStream out;
	
	ServerSocket ssocket = null;
	public Socket socket = null;
	
//	int actual_port = -1;
	
	public TCPIPTransport(SessionAddress address, boolean initiator) throws Exception {
		this.address = address;
		this.initiator = initiator;
	}

	public boolean isAlive() {
		try {
//			if (socket.isConnected()) {
//System.out.println(initiator+" ALIVE");			
//			}
//			return socket.isConnected();
			socket.getKeepAlive();
//System.out.println(initiator+" ALIVE");			
			return true;
		} catch (Exception e) {
System.out.println(initiator+" DEAD");			
			return false;
		}
	}
	
	public void tryReconnect() throws Exception {
		tryReconnect(0);
	}
	public void tryReconnect(long timeout) throws Exception {
		voidActualAddress();
		
		try {
			socket.close();
			socket = null;
		} catch (Exception e) {
		}

		if (initiator) {
			//client
			socket = new Socket(address.getListenerHost(),address.getListenerPortMinimum());
			int actual_port = socket.getLocalPort();
			
			createActualAddress(actual_port);
			
		} else {
			//server
			if (ssocket == null) {
				if (address.getRequiresMultipleConnections()) {
					ssocket = ServerSocketPool.getPooledServerSocket(address.getListenerPortMinimum());
				} else {
					ssocket = ServerSocketPool.getFreeServerSocket(address.getListenerPortMinimum(),address.getListenerPortMaximum());
				}
			}
			int actual_port = ssocket.getLocalPort();
			
			createActualAddress(actual_port);
			
			if (timeout > 0) {
				try {
					ssocket.setSoTimeout(Math.max((int)MIN_TIMEOUT,(int)timeout));
				} catch (Exception e) {}
			}

			socket = ssocket.accept();

			if (actual_address != null) {
				//set the actual host that connected to us in the actual address too
				actual_address.setInitiatorHost( socket.getInetAddress().getHostAddress() );
			}
		}
		
		socket.setTcpNoDelay(true);
		socket.setKeepAlive(true);
		
		in = socket.getInputStream();
		out = socket.getOutputStream();
	}
	
	public void close() {
		try {
			socket.close();
		} catch (Exception e) {
		}
		if (!address.getRequiresMultipleConnections()) {
			try {
				ssocket.close();
			} catch (Exception e) {
			}
		}
	}
	
	public void setSessionAddress(SessionAddress address) {
		this.address = address;
	}

	public boolean providesEncryption() {
		return false;
	}
	public boolean providesAuthentication() {
		return false;
	}
	public static int getMaxEncryptionStrengthBits() {
		return 0;
	}
	public int getEncryptionStrengthBits() {
		return 0;
	}
	public void setRequiredEncryptionStrengthBits(int bits) {
		//do nothing
	}
	
	public OutputStream getOutputStream() {
		return out;
	}
	public InputStream getInputStream() {
		return in;
	}
	
	private void voidActualAddress() {
		SessionAddress actual_address = null;
	}
	
	private void createActualAddress(int actual_port) {
		SessionAddress real_address = (SessionAddress)address.clone();
		if (initiator) {
			real_address.setInitiatorPortMinimum(actual_port);
			real_address.setInitiatorPortMaximum(actual_port);
		} else {
			real_address.setListenerPortMinimum(actual_port);
			real_address.setListenerPortMaximum(actual_port);
		}
		actual_address = real_address;
	}
	
	public SessionAddress getActualAddress() {
		return actual_address;
	}
	
}