/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal;

import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLTypeTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslatorException;
import org.w3c.dom.Element;

/**
 * 
 * @author amiguel
 *
 * The engine internal Message XSD type translator
 */
public class MessageCodec implements XSDTypeTranslator, WSDLTypeTranslator {
	
XSDMap xsdmap;
WSDLMap wsdlmap;

Util compiler_util;

ClassLoader dependancy_loader;

StringBuffer methods = new StringBuffer();

int ref_ids = 0;
HashMap refs = new HashMap();

	public Integer getClassIndex(Object clazz) {
		Integer ref = (Integer)refs.get(clazz);
		if (ref == null) {
			ref = new Integer(ref_ids++);
			refs.put(clazz,ref);
		}
		return ref;
	}
	
	public void init(Util compiler_util, XSDMap xsdmap, WSDLMap wsdlmap, ClassLoader dependancy_loader) {
		this.xsdmap = xsdmap;
		this.wsdlmap = wsdlmap;
		this.dependancy_loader = dependancy_loader;
		this.compiler_util = compiler_util;
	}

	public void readWSDL(Element elem) {
	}

	public void translateComplex(NamespaceTranslator nt, String name, String[] atypes, String[] anames, String[] types, String[] names, String[] elem_names, Element complex) throws XSDTypeTranslatorException, NamespaceException {

		methods.setLength(0);

		String classname = NamespaceTranslator.getJavaClassName(name);

		String fullname = nt.qualify(name,true);

		//
		// TO
		//

		methods.append("\n");
		methods.append("  public static "+Util.jengine_package+".message.Message toEngineMessage(Object jobj) throws Exception {\n");
		methods.append("    //"+name+"\n");
		methods.append("    "+classname+" obj = ("+classname+")jobj;\n");

		methods.append("    "+Util.jengine_package+".message.Message tmp = new "+Util.jengine_package+".message.Message();\n");

		if (compiler_util.getSwitches().MAP_XSDTYPE_TO_INDEXMAP) {
			methods.append("    tmp.append("+getClassIndex(fullname)+");\n");
		} else {
			methods.append("    tmp.append(\""+fullname+"\");\n");
		}

		//IF NULL
		methods.append("    if (obj == null) {\n");
		methods.append("      tmp.append(0);\n");
		methods.append("	} else {\n");
		methods.append("      tmp.append(1);\n");
		
		methods.append("    //Tag Name\n");
		if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
			methods.append("    tmp.append(\"TAG\");\n");
		}
		methods.append("    tmp.append((String)obj."+NamespaceTranslator.getElementTagName()+");\n");

		methods.append("    //Attributes\n");
		if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
			methods.append("    tmp.append(\"ATTRIBUTES\");\n");
			methods.append("    tmp.append("+anames.length+");\n");
		}
		for (int i = 0; i < anames.length; i++) {
			if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
				methods.append("    tmp.append(\""+anames[i]+"\");\n");
			}
			methods.append("    tmp.append("+atypes[i]+".toEngineMessage(obj."+NamespaceTranslator.getAttribute(anames[i])+"));\n");
		}
		methods.append("    //Elements\n");
		if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
			methods.append("    tmp.append(\"ELEMENTS\");\n");
		}
		for (int i = 0; i < names.length; i++) {
			methods.append("    tmp.append(obj."+NamespaceTranslator.getElement(names[i])+".length);\n");
			methods.append("    for (int i = 0; i < obj."+NamespaceTranslator.getElement(names[i])+".length; i++) {\n");
			methods.append("      tmp.append("+types[i]+".toEngineMessage(obj."+NamespaceTranslator.getElement(names[i])+"[i]));\n");	
			methods.append("    }\n");
		}

		//End IF NULL
		methods.append("	}\n");
		
		methods.append("    return tmp;\n");		

		methods.append("  }\n");
		
		//
		// FROM
		//
		
		methods.append("\n");
		methods.append("  public static Object fromEngineMessage("+Util.jengine_package+".message.Message tmp) throws Exception {\n");
		methods.append("    //"+name+"\n");
		methods.append("    "+classname+" obj = new "+classname+"();\n");
		methods.append("    int index = 1;  //skip the class reference at the beginning of the message\n");
		methods.append("    int tmpi;\n");

		methods.append("    if (((Integer)tmp.get(index++)).intValue() == 0) {\n");
		methods.append("      return null;\n");
		methods.append("    }\n");
		
		methods.append("    //Tag Name\n");
		if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
			methods.append("    index++;//skip 'TAG'\n");
		}
		methods.append("    obj."+NamespaceTranslator.getElementTagName()+" = (String)tmp.get(index++);\n");

		methods.append("    //Attributes\n");
		if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
			methods.append("    index++;//skip 'ATTRIBUTES'\n");
			methods.append("    index++;//skip attributes length\n");
		}
		for (int i = 0; i < anames.length; i++) {
			if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
				methods.append("    index++;//skip attribute name\n");
			}
			methods.append("    obj."+NamespaceTranslator.getAttribute(anames[i])+" = ("+atypes[i]+") "+atypes[i]+".fromEngineMessage( ("+Util.jengine_package+".message.Message)tmp.get(index++) );\n");
		}

		methods.append("    //Elements\n");
		if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
			methods.append("    index++;//skip 'ELEMENTS'\n");
		}
		for (int i = 0; i < names.length; i++) {
			methods.append("    tmpi = ((Integer)tmp.get(index++)).intValue();\n");
			methods.append("    obj."+NamespaceTranslator.getElement(names[i])+" = new "+types[i]+"[tmpi];\n");
			methods.append("    for (int i = 0; i < tmpi; i++) {\n");
			methods.append("      obj."+NamespaceTranslator.getElement(names[i])+"[i] = ("+types[i]+") "+types[i]+".fromEngineMessage( ("+Util.jengine_package+".message.Message)tmp.get(index++) );\n");
			methods.append("    }\n");
		}

		methods.append("    return obj;\n");		

		methods.append("  }\n");
	}

	public void translateSimple(NamespaceTranslator nt, String name, String base, Element simple) throws XSDTypeTranslatorException, NamespaceException {
		methods.setLength(0);

		String listType = Util.getSimpleTypeListType(nt,simple);

		//just treat this as its base type
		translateBase(nt,base,name,listType);
	}

	public void translateBase(NamespaceTranslator nt, String name) throws XSDTypeTranslatorException, NamespaceException {
		translateBase(nt,name,name,XSDTypeTranslator.XSD_TYPE_ANYTYPE);
	}

	public void translateBase(NamespaceTranslator nt, String name, String realname, String listType) throws XSDTypeTranslatorException, NamespaceException {
		methods.setLength(0);
		methods.append("\n");

		name = nt.qualify(name,false);

		String qlistType = nt.qualify(listType,false);

		String classname = NamespaceTranslator.getJavaClassName(realname);

		String fullname = name;
	
		String mapping = compiler_util.getInternalBaseMapping(nt,name);
		
		if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_ANYTYPE,false))) {
			
			if (compiler_util.getSwitches().MAP_XSDTYPE_TO_INDEXMAP) {
				methods.append("  public static java.lang.reflect.Method[] engineMessage_xsd_map = new java.lang.reflect.Method["+refs.size()+"];\n");
			
				ArrayList keys = new ArrayList();
				keys.addAll(refs.keySet());
			
				methods.append("  static {\n");
				methods.append("    try {\n");
				methods.append("      ClassLoader cl = "+nt.qualify(XSDTypeTranslator.XSD_TYPE_ANYTYPE,false)+".class.getClassLoader();\n");
				methods.append("      Class[] enginemsg_param = new Class[]{"+Util.jengine_package+".message.Message.class};\n");
				for (int i = 0; i < keys.size(); i++) {
					String key = (String)keys.get(i);
					Integer val = (Integer)refs.get(key);
//					methods.append("      engineMessage_xsd_map["+val+"] = "+key+".class.getDeclaredMethod(\"fromEngineMessage\",enginemsg_param);\n");
					methods.append("      engineMessage_xsd_map["+val+"] = cl.loadClass(\""+key+"\").getDeclaredMethod(\"fromEngineMessage\",enginemsg_param);\n");
				}
				methods.append("    } catch (ClassNotFoundException e) {\n");
				methods.append("      Logger.error(\"problem initialising engine message class index lookup tables \",e);\n");
				methods.append("    } catch (NoSuchMethodException e) {\n");
				methods.append("      Logger.error(\"problem initialising engine message class index lookup tables \",e);\n");
				methods.append("    }\n");
				methods.append("  }\n");
			}
			
			methods.append("  static Class[] toenginemsg_param = new Class[]{Object.class};\n");
			methods.append("  public static "+Util.jengine_package+".message.Message toEngineMessage(Object tmp) throws Exception {\n");
			if (compiler_util.getSwitches().MAP_XSDTYPE_TO_INDEXMAP) {
				methods.append("    java.lang.reflect.Method method = tmp.getClass().getDeclaredMethod(\"toEngineMessage\",toenginemsg_param);\n");  
				methods.append("    return ("+Util.jengine_package+".message.Message)method.invoke(null,new Object[]{tmp});\n");
			} else {
				methods.append("    java.lang.reflect.Method[] methods = tmp.getClass().getMethods();\n");  
				methods.append("    for (int i = 0; i < methods.length; i++) {\n");
				methods.append("      if (methods[i].getName().equals(\"toEngineMessage\"))\n");
				methods.append("        return ("+Util.jengine_package+".message.Message)methods[i].invoke(null,new Object[]{tmp});\n");
				methods.append("    }\n");
				methods.append("    throw new Exception(\"Could not find toEngineMessage method for class \"+tmp.getClass());\n");
			}			
			methods.append("  }\n");

			if (!compiler_util.getSwitches().MAP_XSDTYPE_TO_INDEXMAP) {
				methods.append("  static Class[] enginemsg_param = new Class[]{"+Util.jengine_package+".message.Message.class};\n");
			}
			methods.append("  public static Object fromEngineMessage("+Util.jengine_package+".message.Message m) throws Exception {\n");
			if (compiler_util.getSwitches().MAP_XSDTYPE_TO_INDEXMAP) {
				methods.append("    int cindex = ((Integer)m.get(0)).intValue();\n");
				methods.append("    java.lang.reflect.Method method = engineMessage_xsd_map[cindex];\n");
				methods.append("    return method.invoke(null,new Object[]{m});\n");
			} else {
				methods.append("    String cname = (String)m.get(0);\n");
				methods.append("    java.lang.reflect.Method method = "+NamespaceTranslator.getJavaClassName("anyType")+".class.getClassLoader().loadClass(cname).getDeclaredMethod(\"fromEngineMessage\",enginemsg_param);\n");  
				methods.append("    return method.invoke(null,new Object[]{m});\n");
			}
			methods.append("  }\n");
			
		} else {
	
			//
			// TO method
			//
			methods.append("  public static "+Util.jengine_package+".message.Message toEngineMessage(Object jobj) throws Exception {\n");
			methods.append("    //"+name+"\n");
			methods.append("    "+classname+" obj = ("+classname+")jobj;\n");
			methods.append("    "+Util.jengine_package+".message.Message tmp = new "+Util.jengine_package+".message.Message();\n");
			if (compiler_util.getSwitches().MAP_XSDTYPE_TO_INDEXMAP) {
				methods.append("    tmp.append("+getClassIndex(fullname)+");\n");
			} else {
				methods.append("    tmp.append(\""+fullname+"\");\n");
			}

			//IF NULL
			methods.append("    if (obj == null) {\n");
			methods.append("      tmp.append(0);\n");
			methods.append("	} else {\n");
			methods.append("      tmp.append(1);\n");
			
			methods.append("    //Tag Name\n");
			if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
				methods.append("    tmp.append(\"TAG\");\n");
			}
			methods.append("    tmp.append((String)obj."+NamespaceTranslator.getElementTagName()+");\n");
			
			if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
				methods.append("    tmp.append(\"VALUE\");\n");
			}

			if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_BOOLEAN,false))) {
				//boolean -> Boolean
				methods.append("    if (obj.INTERNAL_VALUE.booleanValue()) {\n");
				methods.append("      tmp.append(1);\n");
				methods.append("    } else {\n");
				methods.append("      tmp.append(0);\n");
				methods.append("    }\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DATE,false))) {
				//GregorianCalendar
				methods.append("    tmp.append(obj.INTERNAL_VALUE.getTimeInMillis());\n");
				methods.append("    tmp.append((int)obj.INTERNAL_VALUE.getTimeZone().getRawOffset());\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DOUBLE,false))) {
				//double -> Double
				methods.append("    tmp.append(Double.doubleToRawLongBits(obj.INTERNAL_VALUE.doubleValue()));\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_INT,false))) {
				//int -> Integer
				methods.append("    tmp.append(obj.INTERNAL_VALUE);\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_LONG,false))) {
				//long -> Long
				methods.append("    tmp.append(obj.INTERNAL_VALUE);\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_STRING,false))) {
				//java.lang.String
				methods.append("    tmp.append(obj.INTERNAL_VALUE);\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_LIST,false))) {
				//java.util.List
				methods.append("    tmp.append(obj.INTERNAL_VALUE.size());\n");
				methods.append("    for (int k = 0; k < obj.INTERNAL_VALUE.size(); k++) {\n");

				methods.append("      tmp.append("+qlistType+".toEngineMessage(obj.INTERNAL_VALUE.get(k)));\n");
//				methods.append("      tmp.append(obj.INTERNAL_VALUE.get(k));\n");
				methods.append("    }\n");
			} else {
				throw new XSDTypeTranslatorException("Unknown XSD base type "+name+" ("+mapping+")");	
			}
			
			methods.append("	}\n");
			
			methods.append("    return tmp;\n");
			methods.append("  }\n");
	
			//
			// FROM method
			//
	
			methods.append("  public static Object fromEngineMessage("+Util.jengine_package+".message.Message m) throws Exception {\n");
			methods.append("    //"+name+"\n");
			methods.append("    int llen = 0;\n");
			methods.append("    "+classname+" obj = new "+classname+"();\n");
			methods.append("    int index = 1; //skip class reference\n");

			methods.append("    if (((Integer)m.get(index++)).intValue() == 0) {\n");
			methods.append("      return null;\n");
			methods.append("    }\n");

			methods.append("    //Tag Name\n");
			if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
				methods.append("    index++; //skip 'TAG'\n");
			}
			methods.append("    obj."+NamespaceTranslator.getElementTagName()+" = (String)m.get(index++);\n");
			
			if (compiler_util.getSwitches().RICH_ENGINE_SERIALISATION) {
				methods.append("    index++; //skip 'VALUE'\n");
			}
			if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_BOOLEAN,false))) {
				//boolean -> Boolean
				methods.append("    obj.INTERNAL_VALUE = new Boolean( ((Integer)m.get(index)).intValue() == 1 );\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DATE,false))) {
				//GregorianCalendar
				methods.append("    int tmp = ((Integer)m.get(index+1)).intValue();\n");
				methods.append("    obj.INTERNAL_VALUE = new java.util.GregorianCalendar( new java.util.SimpleTimeZone( tmp, \"GMT\"+tmp ) );\n");
				methods.append("    obj.INTERNAL_VALUE.setTimeInMillis( ((Long)m.get(index)).longValue() );\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_DOUBLE,false))) {
				//double -> Double
				methods.append("    obj.INTERNAL_VALUE = new Double( Double.longBitsToDouble( ((Long)m.get(index)).longValue() ) );\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_INT,false))) {
				//int -> Integer
				methods.append("    obj.INTERNAL_VALUE = (Integer)m.get(index);\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_LONG,false))) {
				//long -> Long
				methods.append("    obj.INTERNAL_VALUE = (Long)m.get(index);\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_STRING,false))) {
				//java.lang.String
				methods.append("    obj.INTERNAL_VALUE = (String)m.get(index);\n");
			} else if (mapping.equals(nt.qualify(XSDTypeTranslator.XSD_TYPE_LIST,false))) {
				//java.util.List
				methods.append("    obj.INTERNAL_VALUE = new java.util.ArrayList();\n");
				methods.append("    llen = ((Integer)m.get(index)).intValue();\n");
				methods.append("    for (int k = 0; k < llen; k++) {\n");
				methods.append("      obj.INTERNAL_VALUE.add( "+qlistType+".fromEngineMessage(("+Util.jengine_package+".message.Message)m.get(index+1 + k)) );\n");
				methods.append("    }\n");
			} else {
				throw new XSDTypeTranslatorException("Unknown XSD base type "+name);	
			}
			methods.append("    return obj;\n");
			methods.append("  }\n");
		
		}
	}
	
	/**
	 * Returns a java class body with any method implementations for this particular complex type
	 * @return
	 */
	public String getMethods() {
		if (methods.length() == 0) return "";
		return methods.toString();
	}
	
	/**
	 * Returns an array of interfaces that this complex type will be said to implement
	 * @return
	 */
	public String[] getImplementations() {
		return new String[] {
//			MessageXSDType.class.getName(),
		};
	}

	public String[] getImports() {
		return new String[] {
		};
	}
	
}