/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap;


import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELCorrelationSet;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.SOAPClientTransportHTTP;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.SOAPServerTransportHTTP;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SoapDaemon;

/**
 * 
 * @author amiguel
 *
 * A factory which returns a SOAP transport implementation based on given parameters
 */
public class SOAPFactory {
	
	public static final boolean DEBUG = false;

	
	static HashMap soapClients = new HashMap();
	static Object soapClients_LOCK = new Object();
	
	public static void addServerTransportListenerForEPR(WSEndpointReference epr, String transportURI, boolean rpc_type, SOAPServerTransportListener listener) throws Exception {

		if (transportURI == null) {
			String addr = epr.getAddress();
			String lc_addr = addr.toLowerCase();
			
			if (lc_addr.startsWith("http")) {
				transportURI = SOAPNamespaces.BINDING_TRANSPORT_HTTP;
			} else {
				throw new Exception("Could not detect valid SOAP transport for endpoint reference");
			}
		}
		
		//TODO return different transports according to EPR
		//TODO set up transports according to EPR

		if (transportURI.equalsIgnoreCase(SOAPNamespaces.BINDING_TRANSPORT_HTTP)) {
			SOAPServerTransportHTTP proxy = new SOAPServerTransportHTTP(epr,rpc_type,listener);
		} else {
			throw new Exception("Could not detect valid SOAP transport for URI \""+transportURI+"\"");
		}
	}
	public static SOAPClientTransport getClientTransportForEPR(WSEndpointReference epr, BPELCorrelationSet cset, String transportURI) throws Exception {

		if (transportURI == null) {
			String addr = epr.getAddress();
			String lc_addr = addr.toLowerCase();
			
			if (lc_addr.startsWith("http")) {
				transportURI = SOAPNamespaces.BINDING_TRANSPORT_HTTP;
			} else {
				throw new Exception("Could not detect valid SOAP transport for endpoint reference");
			}
		}

		//TODO return different transports according to EPR
		//TODO set up transports according to EPR

		if (transportURI.equalsIgnoreCase(SOAPNamespaces.BINDING_TRANSPORT_HTTP)) {
			String addr = epr.getAddress().toLowerCase();
			
			String proxy_host = null;
			int proxy_port = 8080;
			
			if (addr.startsWith("https")) {
				if (SoapDaemon.SOAP_HTTPS_PROXY_ON) {
					proxy_host = SoapDaemon.SOAP_HTTPS_PROXY_HOST;
					proxy_port = SoapDaemon.SOAP_HTTPS_PROXY_PORT;
				}
			} else {
				if (SoapDaemon.SOAP_HTTP_PROXY_ON) {
					proxy_host = SoapDaemon.SOAP_HTTP_PROXY_HOST;
					proxy_port = SoapDaemon.SOAP_HTTP_PROXY_PORT;
				}
			}
			
			return new SOAPClientTransportHTTP(epr.getAddress(),cset,proxy_host,proxy_port,SoapDaemon.SOAP_PROXY_EXCLUDED_HOSTS);
		} else {
			throw new Exception("Could not detect valid SOAP transport for URI \""+transportURI+"\"");
		}
	}
	/*
	public static SOAPServerInterface getClientForEPR(boolean rpc_style, WSEndpointReference epr) throws Exception {
		return getClientForEPR(rpc_style,epr,null);
		
	}
	public static SOAPServerInterface getClientForEPR(boolean rpc_style, WSEndpointReference epr, String transportURI) throws Exception {

		synchronized(soapClients_LOCK) {
			String key = rpc_style+" : "+transportURI+" : "+epr.toString();
			
			SOAPServer client = (SOAPServer)soapClients.get(key);
			
			if (client == null) {
				client = new SOAPServer(getTransportForEPR(rpc_style,epr,transportURI),rpc_style);
				soapClients.put(key,client);
				//TODO set up client according to EPR
			}

			return client;
		}
	}
	*/

}