/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

import org.eclipse.stp.b2j.core.misc.internal.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * 
 * @author amiguel
 *
 * SOAP utility methods
 */
public class SOAPUtils {

	public static String getStackTrace(Throwable t) {
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		PrintStream ps = new PrintStream(os);   // printing destination
		t.printStackTrace(ps);
		return os.toString();
	}

	public static String basicWrapInSoapEnvelopeDocument(String xml) {
		StringBuffer sb = new StringBuffer();
		sb.append("<?xml version='1.0' encoding='UTF-8'?>");
		sb.append("<SOAP:Envelope xmlns:SOAP=\"").append(SOAPNamespaces.NAMESPACE_SOAP_ENV_1_1).append("\">");
		sb.append("<SOAP:Body ");
		sb.append("SOAP:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" ");
		sb.append(">");
		
		//XSD types for WSDL message
		sb.append(xml);
	
		sb.append("</SOAP:Body>");
		sb.append("</SOAP:Envelope>");
		return sb.toString();
	}

	public static String basicWrapInSoapEnvelopeRPC(String xml, String operationNamespace, String operation) {
		StringBuffer sb = new StringBuffer();
		sb.append("<?xml version='1.0' encoding='UTF-8'?>");
		sb.append("<SOAP:Envelope xmlns:SOAP=\"").append(SOAPNamespaces.NAMESPACE_SOAP_ENV_1_1).append("\">");
		sb.append("<SOAP:Body ");
		sb.append("SOAP:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" ");
		sb.append(">");
		
		// operation header
		sb.append("<opns:").append(operation).append(" xmlns:opns=\"").append(operationNamespace).append("\" ");
		sb.append("xmlns:xsi=\"").append(SOAPNamespaces.NAMESPACE_XSI_1_1).append("\" ");
		sb.append("xmlns:xsd=\"").append(SOAPNamespaces.NAMESPACE_XSD_1_1).append("\" ");
		sb.append(">");

		//XSD types for WSDL message
		sb.append(xml);
	
		// operation tail
		sb.append("</opns:").append(operation).append(">");

		sb.append("</SOAP:Body>");
		sb.append("</SOAP:Envelope>");
		return sb.toString();
	}
	
	public static void gatherNamespaces(ArrayList namespaces, Element elem) {
		NamedNodeMap map = elem.getAttributes();
		for (int i = 0; i < map.getLength(); i++) {
			Attr attr = (Attr)map.item(i);
			if (attr.getName().toLowerCase().startsWith("xmlns:")) {

				if (SOAPFactory.DEBUG) System.out.println("GATHERED NAMESPACE: "+attr.getName()+"="+attr.getValue());		
				namespaces.add(attr);
			}
		}
	}
	
	public static void dumpNamespaces(ArrayList namespaces, Element elem) {
		for (int i = namespaces.size()-1; i >= 0; i--) {
			Attr attr = (Attr)namespaces.get(i);
			if (!elem.hasAttribute(attr.getNodeName())) {
				elem.setAttribute(attr.getName(),attr.getValue());
			}
		}
	}
	
	public static String basicRemoveSoapEnvelopeDocument(String xml) throws Exception {

		ArrayList namespaces = new ArrayList();
		
		Document doc = XMLUtil.documentFromString(xml);
		
		gatherNamespaces(namespaces,doc.getDocumentElement());
		
		NodeList envs = doc.getDocumentElement().getChildNodes();
		for (int i = 0; i < envs.getLength(); i++) {
			Node n = envs.item(i);
			
			if (n.getNodeType() == Node.ELEMENT_NODE
					&& n.getNodeName().endsWith("Body")) {

				gatherNamespaces(namespaces,(Element)n);
				
//				NodeList responses = n.getChildNodes();
//				for (int k = 0; k < responses.getLength(); k++) {
//					Node response = responses.item(k);
//					if (response.getNodeType() == Node.ELEMENT_NODE) {
//						
//						gatherNamespaces(namespaces,(Element)response);
						
						NodeList nodes = n.getChildNodes();
						
						for (int z = 0; z < nodes.getLength(); z++) {
							if (nodes.item(z).getNodeType() == Node.ELEMENT_NODE) {
								dumpNamespaces(namespaces,(Element)nodes.item(z));
							}
						}
						
						return XMLUtil.nodeChildrenToString(n);
//					}
//				}
			}
		}
		throw new Exception("found no valid response");
	}

	public static String basicRemoveSoapEnvelopeRPC(String xml) throws Exception {

		ArrayList namespaces = new ArrayList();
		
		Document doc = XMLUtil.documentFromString(xml);
		
		gatherNamespaces(namespaces,doc.getDocumentElement());
		
		NodeList envs = doc.getDocumentElement().getChildNodes();
		for (int i = 0; i < envs.getLength(); i++) {
			Node n = envs.item(i);
			if (n.getNodeType() == Node.ELEMENT_NODE
					&& n.getNodeName().endsWith("Body")) {
				
				gatherNamespaces(namespaces,(Element)n);
				
				NodeList responses = n.getChildNodes();
				for (int k = 0; k < responses.getLength(); k++) {
					Node response = responses.item(k);
					if (response.getNodeType() == Node.ELEMENT_NODE) {
						
						gatherNamespaces(namespaces,(Element)response);
						
						NodeList nodes = response.getChildNodes();
						
						for (int z = 0; z < nodes.getLength(); z++) {
							if (nodes.item(z).getNodeType() == Node.ELEMENT_NODE) {
								dumpNamespaces(namespaces,(Element)nodes.item(z));
							}
						}
						
						return XMLUtil.nodeChildrenToString(response);
					}
				}
			}
		}
		throw new Exception("found no valid response");
	}
	
}