/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.io.FileOutputStream;
import java.net.URL;

public class CookieTest {
	
	public static void main(String[] args) throws Exception {
		String[][] headers = new String[0][];
		
		CookieCache cookies = new CookieCache();
		
		String[] urls = new String[]{
				"http://www.radmin.com/",
				"http://www.radmin.com/go.php?event1=Famatech&event2=Ordering&event3=MainPageEn&goto=/ordering/options/",
				"http://www.radmin.com:80/ordering/options/",
				"http://www.radmin.com/go.php?event1=go_out&event2=element5&event3=single&goto=http%3A//shop.element5.com/cart.html%3Fproductid%3D510919%26nopflink%3D1",
				"http://shop.element5.com/cart.html?productid=510919&nopflink=1",
//				"http://www.ebuyer.com",
//				"http://www.ebuyer.com/customer/gateway/",
//				"http://www.ebuyer.com/customer/products/index.html?rb=9150604788&action=Y2FydF9hZGRfaXRlbQ==",
		};
		String[] posts = new String[]{
				null,
				null,
				null,
				null,
				null,
//				null,
//				null,
//				"?qty=1&x_cHJvZHVjdF91aWQ%3D=ODY4NjQ%3D",
		};
		for (int i = 0; i < urls.length; i++) {
			HTTPClient client = new HTTPClient(new URL(urls[i]));
		
//			client.setProxy("192.168.1.1",8080);
			
			System.out.println("FETCHING "+urls[i]);
			
			String response;
			if (posts[i] != null) {
				response = new String(client.doPost(posts[i].getBytes(),"application/x-www-form-urlencoded",headers,cookies));
			} else {
				response = new String(client.doGet(headers,cookies));
			}
			
			FileOutputStream fout = new FileOutputStream(System.currentTimeMillis()+".html");
			fout.write(response.getBytes());
			fout.close();

			client.close();

			Thread.sleep(1000);
		}
/*
		Thread.sleep(1000);

		System.out.println("DOING SECOND GET");
		client.doGet(headers,cookies);
		*/
		
	}
}