/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.utils.XSDUtil;

/**
 * 
 * @author amiguel
 *
 * A WSIF Java port implementing engine logging
 */
public class EnginePrinterPort {
	public void print(String msg) {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;
			try {
				engine.print(msg);
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			System.out.println(msg);
		}
	}
	public void printXml(String msg) {
		print(XSDUtil.fromXMLString(msg));
	}
}