/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import javax.imageio.ImageIO;

/**
 * 
 * @author amiguel
 *
 * Probably obsolete.
 *
 * A WSIF Java port implementing a 3D scene
 */
public class ScenePort {
	
	ArrayList triangles = new ArrayList();
	
	public void addShape(Triangle t) {
		triangles.add(t);
	}
	
	public Triangles getTriangles() {
		Triangles tmp = new Triangles();
		tmp.triangle = new Triangle[triangles.size()];
		triangles.toArray(tmp.triangle);
		return tmp;
	}
	public void setTriangles(Triangles tmp) {
		triangles.clear();
		for (int i = 0; i < tmp.triangle.length; i++) {
			triangles.add(tmp.triangle[i]);
		}
	}
	
	public String toString() {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < triangles.size(); i++) {
			sb.append(triangles.get(i).toString());
			sb.append("\n");
		}
		return sb.toString();
	}
	
	public BufferedImage toImage() {
		BufferedImage image = new BufferedImage(800,600,BufferedImage.TYPE_INT_RGB);
		Graphics2D g = (Graphics2D)image.getGraphics();
		g.setColor(Color.black);
		g.fillRect(0,0,800,600);
		for (int i = 0; i < triangles.size(); i++) {
			Triangle t = (Triangle)triangles.get(i);
			g.setColor(t.getColor().getAwtColor());
			g.fillPolygon(t.getAwtPolygon());
		}
		return image;
	}
	
	public void writeImageToFile(String path) throws IOException {
		BufferedImage img = toImage();
		ImageIO.write(img,"jpeg",new File(path+".jpeg"));
	}
}